/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.store;

import java.util.Collection;
import org.apache.log4j.Logger;
import org.wso2.andes.server.ClusterResourceHolder;
import org.wso2.andes.store.HealthAwareStore;
import org.wso2.andes.store.StoreHealthListener;

public class StoreHealthCheckTask
implements Runnable {
    private static final Logger logger = Logger.getLogger(StoreHealthCheckTask.class);
    private HealthAwareStore store;

    StoreHealthCheckTask(HealthAwareStore store, Collection<StoreHealthListener> healthListeners) {
        this.store = store;
    }

    @Override
    public void run() {
        try {
            String myNodeId = ClusterResourceHolder.getInstance().getClusterManager().getMyNodeID();
            logger.info((Object)String.format("about to check store [%s]'s operational status ", this.store.getClass()));
            this.store.isOperational(myNodeId, System.currentTimeMillis());
        }
        catch (Throwable e) {
            logger.error((Object)"Error occurred while checking store availability.", e);
        }
    }
}

