/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.store;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.wso2.andes.configuration.AndesConfigurationManager;
import org.wso2.andes.configuration.enums.AndesConfiguration;
import org.wso2.andes.store.AndesStoreUnavailableException;
import org.wso2.andes.store.HealthAwareStore;
import org.wso2.andes.store.StoreHealthCheckTask;
import org.wso2.andes.store.StoreHealthListener;

public class FailureObservingStoreManager {
    private static Collection<StoreHealthListener> healthListeners = Collections.synchronizedCollection(new ArrayList());
    private final ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("FailureObservingStores-HealthCheckPool").build();
    private final ScheduledExecutorService executor = Executors.newScheduledThreadPool(2, this.namedThreadFactory);
    private AtomicBoolean isStoreAvailable = new AtomicBoolean(true);
    private AtomicBoolean isContextStoreAvailable = new AtomicBoolean(true);
    private AtomicBoolean isMessageStoreAvailable = new AtomicBoolean(true);

    public static void registerStoreHealthListener(StoreHealthListener healthListener) {
        healthListeners.add(healthListener);
    }

    ScheduledFuture<?> scheduleHealthCheckTask(HealthAwareStore store) {
        int taskDelay = (Integer)AndesConfigurationManager.readValue(AndesConfiguration.PERSISTENCE_STORE_HEALTH_CHECK_INTERVAL);
        StoreHealthCheckTask healthCheckTask = new StoreHealthCheckTask(store, healthListeners);
        return this.executor.scheduleWithFixedDelay(healthCheckTask, taskDelay, taskDelay, TimeUnit.SECONDS);
    }

    public void notifyContextStoreNonOperational(AndesStoreUnavailableException exception, HealthAwareStore healthAwareStore) {
        this.isContextStoreAvailable.compareAndSet(true, false);
        if (this.isStoreAvailable.compareAndSet(true, false)) {
            this.notifyStoreNonOperational(exception, healthAwareStore);
        }
    }

    private void notifyStoreNonOperational(AndesStoreUnavailableException exception, HealthAwareStore healthAwareStore) {
        ThreadFactory namedNotifierThreadFactory = new ThreadFactoryBuilder().setNameFormat("StoreFailure-NotifierPool").build();
        ScheduledExecutorService listenerNotifyingExecutor = Executors.newScheduledThreadPool(healthListeners.size(), namedNotifierThreadFactory);
        for (StoreHealthListener listener : healthListeners) {
            StoreFailureNotifier notifier = new StoreFailureNotifier(healthAwareStore, exception, listener);
            listenerNotifyingExecutor.schedule(notifier, 0L, TimeUnit.SECONDS);
        }
    }

    public void notifyMessageStoreNonOperational(AndesStoreUnavailableException exception, HealthAwareStore healthAwareStore) {
        this.isMessageStoreAvailable.compareAndSet(true, false);
        if (this.isStoreAvailable.compareAndSet(true, false)) {
            this.notifyStoreNonOperational(exception, healthAwareStore);
        }
    }

    private void notifyStoreOperational(HealthAwareStore healthAwareStore) {
        if (this.isContextStoreAvailable.get() && this.isMessageStoreAvailable.get() && this.isStoreAvailable.compareAndSet(false, true)) {
            for (StoreHealthListener listener : healthListeners) {
                listener.storeOperational(healthAwareStore);
            }
        }
    }

    public void notifyContextStoreOperational(HealthAwareStore healthAwareStore) {
        if (this.isContextStoreAvailable.compareAndSet(false, true)) {
            this.notifyStoreOperational(healthAwareStore);
        }
    }

    public void notifyMessageStoreOperational(HealthAwareStore healthAwareStore) {
        if (this.isMessageStoreAvailable.compareAndSet(false, true)) {
            this.notifyStoreOperational(healthAwareStore);
        }
    }

    void close() {
        this.executor.shutdown();
    }

    private class StoreFailureNotifier
    extends Thread {
        private HealthAwareStore healthAwareStore;
        private Exception exception;
        private StoreHealthListener listener;

        public StoreFailureNotifier(HealthAwareStore store, Exception exception, StoreHealthListener storeHealthListener) {
            this.healthAwareStore = store;
            this.exception = exception;
            this.listener = storeHealthListener;
        }

        @Override
        public void run() {
            this.listener.storeNonOperational(this.healthAwareStore, this.exception);
        }
    }
}

