/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.store;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;
import org.wso2.andes.store.AndesStoreUnavailableException;
import org.wso2.andes.store.FailureObservingStoreManager;
import org.wso2.andes.store.HealthAwareStore;

public abstract class FailureObservingStore<T extends HealthAwareStore>
implements HealthAwareStore {
    private static final Logger log = Logger.getLogger(FailureObservingStore.class);
    private AtomicBoolean isStoreAvailable;
    private ScheduledFuture<?> storeHealthDetectingFuture;
    protected FailureObservingStoreManager failureObservingStoreManager;
    protected T wrappedInstance;

    FailureObservingStore(T wrappedInstance, FailureObservingStoreManager storeManager) {
        this.wrappedInstance = wrappedInstance;
        this.failureObservingStoreManager = storeManager;
        this.isStoreAvailable = new AtomicBoolean(true);
    }

    @Override
    public boolean isOperational(String testString, long testTime) {
        if (this.wrappedInstance.isOperational(testString, testTime)) {
            this.isStoreAvailable.set(true);
            if (this.storeHealthDetectingFuture != null) {
                this.storeHealthDetectingFuture.cancel(false);
                this.storeHealthDetectingFuture = null;
            }
            this.failureObservingStoreManager.notifyMessageStoreOperational(this);
            return true;
        }
        return false;
    }

    protected void notifyFailures(AndesStoreUnavailableException e) {
        if (this.isStoreAvailable.compareAndSet(true, false)) {
            log.warn((Object)"Message store became non-operational");
            this.failureObservingStoreManager.notifyMessageStoreNonOperational(e, (HealthAwareStore)this.wrappedInstance);
            this.storeHealthDetectingFuture = this.failureObservingStoreManager.scheduleHealthCheckTask(this);
        }
    }

    protected T getWrappedInstance() {
        return this.wrappedInstance;
    }
}

