/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.store;

import com.gs.collections.impl.list.mutable.primitive.LongArrayList;
import com.gs.collections.impl.map.mutable.primitive.LongObjectHashMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.wso2.andes.configuration.util.ConfigurationProperties;
import org.wso2.andes.kernel.AndesContextStore;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.AndesMessage;
import org.wso2.andes.kernel.AndesMessageMetadata;
import org.wso2.andes.kernel.AndesMessagePart;
import org.wso2.andes.kernel.DeliverableAndesMetadata;
import org.wso2.andes.kernel.DtxStore;
import org.wso2.andes.kernel.DurableStoreConnection;
import org.wso2.andes.kernel.MessageStore;
import org.wso2.andes.kernel.slot.RecoverySlotCreator;
import org.wso2.andes.kernel.slot.Slot;
import org.wso2.andes.store.AndesStoreUnavailableException;
import org.wso2.andes.store.FailureObservingDtxStore;
import org.wso2.andes.store.FailureObservingStore;
import org.wso2.andes.store.FailureObservingStoreManager;
import org.wso2.andes.tools.utils.MessageTracer;

public class FailureObservingMessageStore
extends FailureObservingStore<MessageStore>
implements MessageStore {
    private FailureObservingDtxStore failureObservingDtxStore;
    private FailureObservingStoreManager failureObservingStoreManager;

    public FailureObservingMessageStore(MessageStore messageStore, FailureObservingStoreManager manager) {
        super(messageStore, manager);
        this.failureObservingStoreManager = manager;
        this.failureObservingDtxStore = null;
    }

    @Override
    public DurableStoreConnection initializeMessageStore(AndesContextStore contextStore, ConfigurationProperties connectionProperties) throws AndesException {
        try {
            DurableStoreConnection connection = ((MessageStore)this.wrappedInstance).initializeMessageStore(contextStore, connectionProperties);
            this.failureObservingDtxStore = new FailureObservingDtxStore(((MessageStore)this.wrappedInstance).getDtxStore(), this.failureObservingStoreManager);
            return connection;
        }
        catch (AndesStoreUnavailableException exception) {
            this.notifyFailures(exception);
            throw exception;
        }
    }

    @Override
    public void storeMessagePart(List<AndesMessagePart> partList) throws AndesException {
        try {
            ((MessageStore)this.wrappedInstance).storeMessagePart(partList);
        }
        catch (AndesStoreUnavailableException exception) {
            this.notifyFailures(exception);
            throw exception;
        }
    }

    @Override
    public AndesMessagePart getContent(long messageId, int offsetValue) throws AndesException {
        try {
            return ((MessageStore)this.wrappedInstance).getContent(messageId, offsetValue);
        }
        catch (AndesStoreUnavailableException exception) {
            this.notifyFailures(exception);
            throw exception;
        }
    }

    @Override
    public LongObjectHashMap<List<AndesMessagePart>> getContent(LongArrayList messageIDList) throws AndesException {
        try {
            return ((MessageStore)this.wrappedInstance).getContent(messageIDList);
        }
        catch (AndesStoreUnavailableException exception) {
            this.notifyFailures(exception);
            throw exception;
        }
    }

    @Override
    public void storeMessages(List<AndesMessage> messageList) throws AndesException {
        try {
            ((MessageStore)this.wrappedInstance).storeMessages(messageList);
        }
        catch (AndesStoreUnavailableException exception) {
            this.notifyFailures(exception);
            throw exception;
        }
    }

    @Override
    public void moveMetadataToQueue(long messageId, String currentQueueName, String targetQueueName) throws AndesException {
        try {
            ((MessageStore)this.wrappedInstance).moveMetadataToQueue(messageId, currentQueueName, targetQueueName);
        }
        catch (AndesStoreUnavailableException exception) {
            this.notifyFailures(exception);
            throw exception;
        }
    }

    @Override
    public void moveMetadataToDLC(long messageId, String dlcQueueName) throws AndesException {
        try {
            ((MessageStore)this.wrappedInstance).moveMetadataToDLC(messageId, dlcQueueName);
        }
        catch (AndesStoreUnavailableException exception) {
            this.notifyFailures(exception);
            throw exception;
        }
    }

    @Override
    public void moveMetadataToDLC(List<AndesMessageMetadata> messages, String dlcQueueName) throws AndesException {
        try {
            ((MessageStore)this.wrappedInstance).moveMetadataToDLC(messages, dlcQueueName);
        }
        catch (AndesStoreUnavailableException exception) {
            this.notifyFailures(exception);
            throw exception;
        }
    }

    @Override
    public void updateMetadataInformation(String currentQueueName, List<AndesMessageMetadata> metadataList) throws AndesException {
        try {
            ((MessageStore)this.wrappedInstance).updateMetadataInformation(currentQueueName, metadataList);
        }
        catch (AndesStoreUnavailableException exception) {
            this.notifyFailures(exception);
            throw exception;
        }
    }

    @Override
    public AndesMessageMetadata getMetadata(long messageId) throws AndesException {
        try {
            return ((MessageStore)this.wrappedInstance).getMetadata(messageId);
        }
        catch (AndesStoreUnavailableException exception) {
            this.notifyFailures(exception);
            throw exception;
        }
    }

    @Override
    public List<DeliverableAndesMetadata> getMetadataList(Slot slot, String storageQueueName, long firstMsgId, long lastMsgID) throws AndesException {
        try {
            return ((MessageStore)this.wrappedInstance).getMetadataList(slot, storageQueueName, firstMsgId, lastMsgID);
        }
        catch (AndesStoreUnavailableException exception) {
            this.notifyFailures(exception);
            throw exception;
        }
    }

    @Override
    public long getMessageCountForQueueInRange(String storageQueueName, long firstMessageId, long lastMessageId) throws AndesException {
        try {
            return ((MessageStore)this.wrappedInstance).getMessageCountForQueueInRange(storageQueueName, firstMessageId, lastMessageId);
        }
        catch (AndesStoreUnavailableException exception) {
            this.notifyFailures(exception);
            throw exception;
        }
    }

    @Override
    public int recoverSlotsForQueue(String storageQueueName, long firstMsgId, int count, RecoverySlotCreator.CallBack callBack) throws AndesException {
        try {
            return ((MessageStore)this.wrappedInstance).recoverSlotsForQueue(storageQueueName, firstMsgId, count, callBack);
        }
        catch (AndesStoreUnavailableException exception) {
            this.notifyFailures(exception);
            throw exception;
        }
    }

    @Override
    public List<AndesMessageMetadata> getNextNMessageMetadataFromQueue(String storageQueueName, long firstMsgId, int count) throws AndesException {
        try {
            return ((MessageStore)this.wrappedInstance).getNextNMessageMetadataFromQueue(storageQueueName, firstMsgId, count);
        }
        catch (AndesStoreUnavailableException exception) {
            this.notifyFailures(exception);
            throw exception;
        }
    }

    @Override
    public List<AndesMessageMetadata> getNextNMessageMetadataForQueueFromDLC(String storageQueueName, String dlcQueueName, long firstMsgId, int count) throws AndesException {
        try {
            return ((MessageStore)this.wrappedInstance).getNextNMessageMetadataForQueueFromDLC(storageQueueName, dlcQueueName, firstMsgId, count);
        }
        catch (AndesStoreUnavailableException exception) {
            this.notifyFailures(exception);
            throw exception;
        }
    }

    @Override
    public List<AndesMessageMetadata> getNextNMessageMetadataFromDLC(String dlcQueueName, long firstMsgId, int count) throws AndesException {
        try {
            return ((MessageStore)this.wrappedInstance).getNextNMessageMetadataFromDLC(dlcQueueName, firstMsgId, count);
        }
        catch (AndesStoreUnavailableException exception) {
            this.notifyFailures(exception);
            throw exception;
        }
    }

    @Override
    public void deleteMessageMetadataFromQueue(String storageQueueName, List<AndesMessageMetadata> messagesToRemove) throws AndesException {
        try {
            ((MessageStore)this.wrappedInstance).deleteMessageMetadataFromQueue(storageQueueName, messagesToRemove);
        }
        catch (AndesStoreUnavailableException exception) {
            this.notifyFailures(exception);
            throw exception;
        }
    }

    @Override
    public void deleteMessages(Collection<? extends AndesMessageMetadata> messagesToRemove) throws AndesException {
        try {
            ((MessageStore)this.wrappedInstance).deleteMessages(messagesToRemove);
            if (MessageTracer.isEnabled()) {
                for (AndesMessageMetadata andesMessageMetadata : messagesToRemove) {
                    MessageTracer.trace(andesMessageMetadata.getMessageID(), andesMessageMetadata.getStorageQueueName(), "message deleted");
                }
            }
        }
        catch (AndesStoreUnavailableException exception) {
            this.notifyFailures(exception);
            throw exception;
        }
    }

    @Override
    public void deleteMessages(List<Long> messagesToRemove) throws AndesException {
        try {
            ((MessageStore)this.wrappedInstance).deleteMessages(messagesToRemove);
            if (MessageTracer.isEnabled()) {
                for (Long messageId : messagesToRemove) {
                    MessageTracer.trace((long)messageId, "", "message deleted");
                }
            }
        }
        catch (AndesStoreUnavailableException exception) {
            this.notifyFailures(exception);
            throw exception;
        }
    }

    @Override
    public void deleteDLCMessages(List<AndesMessageMetadata> messagesToRemove) throws AndesException {
        try {
            ((MessageStore)this.wrappedInstance).deleteDLCMessages(messagesToRemove);
        }
        catch (AndesStoreUnavailableException exception) {
            this.notifyFailures(exception);
            throw exception;
        }
    }

    @Override
    public List<Long> getExpiredMessages(long lowerBoundMessageID, String queueName) throws AndesException {
        try {
            return ((MessageStore)this.wrappedInstance).getExpiredMessages(lowerBoundMessageID, queueName);
        }
        catch (AndesStoreUnavailableException exception) {
            this.notifyFailures(exception);
            throw exception;
        }
    }

    @Override
    public List<Long> getExpiredMessagesFromDLC(long messageCount) throws AndesException {
        try {
            return ((MessageStore)this.wrappedInstance).getExpiredMessagesFromDLC(messageCount);
        }
        catch (AndesStoreUnavailableException exception) {
            this.notifyFailures(exception);
            throw exception;
        }
    }

    @Override
    public void addMessageToExpiryQueue(Long messageId, Long expirationTime, boolean isMessageForTopic, String destination) throws AndesException {
        try {
            ((MessageStore)this.wrappedInstance).addMessageToExpiryQueue(messageId, expirationTime, isMessageForTopic, destination);
        }
        catch (AndesStoreUnavailableException exception) {
            this.notifyFailures(exception);
            throw exception;
        }
    }

    @Override
    public int deleteAllMessageMetadata(String storageQueueName) throws AndesException {
        try {
            return ((MessageStore)this.wrappedInstance).deleteAllMessageMetadata(storageQueueName);
        }
        catch (AndesStoreUnavailableException exception) {
            this.notifyFailures(exception);
            throw exception;
        }
    }

    @Override
    public int clearDLCQueue(String dlcQueueName) throws AndesException {
        try {
            return ((MessageStore)this.wrappedInstance).clearDLCQueue(dlcQueueName);
        }
        catch (AndesStoreUnavailableException exception) {
            this.notifyFailures(exception);
            throw exception;
        }
    }

    @Override
    public LongArrayList getMessageIDsAddressedToQueue(String storageQueueName, Long startMessageID) throws AndesException {
        try {
            return ((MessageStore)this.wrappedInstance).getMessageIDsAddressedToQueue(storageQueueName, startMessageID);
        }
        catch (AndesStoreUnavailableException exception) {
            this.notifyFailures(exception);
            throw exception;
        }
    }

    @Override
    public void addQueue(String storageQueueName) throws AndesException {
        try {
            ((MessageStore)this.wrappedInstance).addQueue(storageQueueName);
        }
        catch (AndesStoreUnavailableException exception) {
            this.notifyFailures(exception);
            throw exception;
        }
    }

    @Override
    public Map<String, Integer> getMessageCountForAllQueues(List<String> queueNames) throws AndesException {
        try {
            return ((MessageStore)this.wrappedInstance).getMessageCountForAllQueues(queueNames);
        }
        catch (AndesStoreUnavailableException exception) {
            this.notifyFailures(exception);
            throw exception;
        }
    }

    @Override
    public long getMessageCountForQueue(String storageQueueName) throws AndesException {
        try {
            return ((MessageStore)this.wrappedInstance).getMessageCountForQueue(storageQueueName);
        }
        catch (AndesStoreUnavailableException exception) {
            this.notifyFailures(exception);
            throw exception;
        }
    }

    @Override
    public long getApproximateQueueMessageCount(String storageQueueName) throws AndesException {
        try {
            return ((MessageStore)this.wrappedInstance).getApproximateQueueMessageCount(storageQueueName);
        }
        catch (AndesStoreUnavailableException exception) {
            this.notifyFailures(exception);
            throw exception;
        }
    }

    @Override
    public long getMessageCountForQueueInDLC(String storageQueueName, String dlcQueueName) throws AndesException {
        try {
            return ((MessageStore)this.wrappedInstance).getMessageCountForQueueInDLC(storageQueueName, dlcQueueName);
        }
        catch (AndesStoreUnavailableException exception) {
            this.notifyFailures(exception);
            throw exception;
        }
    }

    @Override
    public long getMessageCountForDLCQueue(String dlcQueueName) throws AndesException {
        try {
            return ((MessageStore)this.wrappedInstance).getMessageCountForDLCQueue(dlcQueueName);
        }
        catch (AndesStoreUnavailableException exception) {
            this.notifyFailures(exception);
            throw exception;
        }
    }

    @Override
    public void resetMessageCounterForQueue(String storageQueueName) throws AndesException {
        try {
            ((MessageStore)this.wrappedInstance).resetMessageCounterForQueue(storageQueueName);
        }
        catch (AndesStoreUnavailableException exception) {
            this.notifyFailures(exception);
            throw exception;
        }
    }

    @Override
    public void removeQueue(String storageQueueName) throws AndesException {
        try {
            ((MessageStore)this.wrappedInstance).removeQueue(storageQueueName);
        }
        catch (AndesStoreUnavailableException exception) {
            this.notifyFailures(exception);
            throw exception;
        }
    }

    @Override
    public void removeLocalQueueData(String storageQueueName) {
        ((MessageStore)this.wrappedInstance).removeLocalQueueData(storageQueueName);
    }

    @Override
    public void incrementMessageCountForQueue(String storageQueueName, long incrementBy) throws AndesException {
        try {
            ((MessageStore)this.wrappedInstance).incrementMessageCountForQueue(storageQueueName, incrementBy);
        }
        catch (AndesStoreUnavailableException exception) {
            this.notifyFailures(exception);
            throw exception;
        }
    }

    @Override
    public void decrementMessageCountForQueue(String storageQueueName, long decrementBy) throws AndesException {
        try {
            ((MessageStore)this.wrappedInstance).decrementMessageCountForQueue(storageQueueName, decrementBy);
        }
        catch (AndesStoreUnavailableException exception) {
            this.notifyFailures(exception);
            throw exception;
        }
    }

    @Override
    public void storeRetainedMessages(Map<String, AndesMessage> retainMap) throws AndesException {
        try {
            ((MessageStore)this.wrappedInstance).storeRetainedMessages(retainMap);
        }
        catch (AndesStoreUnavailableException exception) {
            this.notifyFailures(exception);
            throw exception;
        }
    }

    @Override
    public List<String> getAllRetainedTopics() throws AndesException {
        try {
            return ((MessageStore)this.wrappedInstance).getAllRetainedTopics();
        }
        catch (AndesStoreUnavailableException exception) {
            this.notifyFailures(exception);
            throw exception;
        }
    }

    @Override
    public Map<Integer, AndesMessagePart> getRetainedContentParts(long messageID) throws AndesException {
        try {
            return ((MessageStore)this.wrappedInstance).getRetainedContentParts(messageID);
        }
        catch (AndesStoreUnavailableException exception) {
            this.notifyFailures(exception);
            throw exception;
        }
    }

    @Override
    public DeliverableAndesMetadata getRetainedMetadata(String destination) throws AndesException {
        try {
            return ((MessageStore)this.wrappedInstance).getRetainedMetadata(destination);
        }
        catch (AndesStoreUnavailableException exception) {
            this.notifyFailures(exception);
            throw exception;
        }
    }

    @Override
    public void close() {
        ((MessageStore)this.wrappedInstance).close();
        this.failureObservingStoreManager.close();
    }

    @Override
    public DtxStore getDtxStore() {
        return this.failureObservingDtxStore;
    }

    @Override
    public List<Long> getMessageIdsInDLCForQueue(String sourceQueueName, String dlcQueueName, long startMessageId, int messageLimit) throws AndesException {
        try {
            return ((MessageStore)this.wrappedInstance).getMessageIdsInDLCForQueue(sourceQueueName, dlcQueueName, startMessageId, messageLimit);
        }
        catch (AndesStoreUnavailableException exception) {
            this.notifyFailures(exception);
            throw exception;
        }
    }

    @Override
    public List<Long> getMessageIdsInDLC(String dlcQueueName, long startMessageId, int messageLimit) throws AndesException {
        try {
            return ((MessageStore)this.wrappedInstance).getMessageIdsInDLC(dlcQueueName, startMessageId, messageLimit);
        }
        catch (AndesStoreUnavailableException exception) {
            this.notifyFailures(exception);
            throw exception;
        }
    }
}

