/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.virtualhost;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.log4j.Logger;
import org.wso2.andes.AMQException;
import org.wso2.andes.AMQStoreException;
import org.wso2.andes.amqp.QpidAndesBridge;
import org.wso2.andes.configuration.qpid.BrokerConfig;
import org.wso2.andes.configuration.qpid.ConfigStore;
import org.wso2.andes.configuration.qpid.ConfiguredObject;
import org.wso2.andes.configuration.qpid.ExchangeConfiguration;
import org.wso2.andes.configuration.qpid.QueueConfiguration;
import org.wso2.andes.configuration.qpid.VirtualHostConfigType;
import org.wso2.andes.configuration.qpid.VirtualHostConfiguration;
import org.wso2.andes.framing.AMQShortString;
import org.wso2.andes.framing.FieldTable;
import org.wso2.andes.kernel.AndesKernelBoot;
import org.wso2.andes.server.AMQBrokerManagerMBean;
import org.wso2.andes.server.binding.BindingFactory;
import org.wso2.andes.server.connection.ConnectionRegistry;
import org.wso2.andes.server.connection.IConnectionRegistry;
import org.wso2.andes.server.exchange.DefaultExchangeFactory;
import org.wso2.andes.server.exchange.DefaultExchangeRegistry;
import org.wso2.andes.server.exchange.Exchange;
import org.wso2.andes.server.exchange.ExchangeFactory;
import org.wso2.andes.server.exchange.ExchangeRegistry;
import org.wso2.andes.server.federation.BrokerLink;
import org.wso2.andes.server.information.management.QueueManagementInformationMBean;
import org.wso2.andes.server.logging.LogSubject;
import org.wso2.andes.server.logging.actors.CurrentActor;
import org.wso2.andes.server.logging.messages.VirtualHostMessages;
import org.wso2.andes.server.logging.subjects.MessageStoreLogSubject;
import org.wso2.andes.server.management.AMQManagedObject;
import org.wso2.andes.server.management.ManagedObject;
import org.wso2.andes.server.protocol.AMQConnectionModel;
import org.wso2.andes.server.protocol.AMQSessionModel;
import org.wso2.andes.server.queue.AMQQueue;
import org.wso2.andes.server.queue.AMQQueueFactory;
import org.wso2.andes.server.queue.DefaultQueueRegistry;
import org.wso2.andes.server.queue.QueueRegistry;
import org.wso2.andes.server.registry.ApplicationRegistry;
import org.wso2.andes.server.registry.IApplicationRegistry;
import org.wso2.andes.server.security.SecurityManager;
import org.wso2.andes.server.security.auth.manager.AuthenticationManager;
import org.wso2.andes.server.stats.StatisticsCounter;
import org.wso2.andes.server.store.ConfigurationRecoveryHandler;
import org.wso2.andes.server.store.DurableConfigurationStore;
import org.wso2.andes.server.store.MessageStore;
import org.wso2.andes.server.store.QpidDeprecatedMessageStore;
import org.wso2.andes.server.store.TransactionLog;
import org.wso2.andes.server.virtualhost.HouseKeepingTask;
import org.wso2.andes.server.virtualhost.ManagedVirtualHost;
import org.wso2.andes.server.virtualhost.VirtualHost;
import org.wso2.andes.server.virtualhost.VirtualHostConfigRecoveryHandler;
import org.wso2.andes.server.virtualhost.plugins.VirtualHostHouseKeepingPlugin;
import org.wso2.andes.server.virtualhost.plugins.VirtualHostPluginFactory;

public class VirtualHostImpl
implements VirtualHost {
    private static final Logger log = Logger.getLogger(VirtualHostImpl.class);
    private final String name;
    private ConnectionRegistry connectionRegistry;
    private QueueRegistry queueRegistry;
    private ExchangeRegistry exchangeRegistry;
    private ExchangeFactory exchangeFactory;
    private MessageStore messageStore;
    protected VirtualHostMBean virtualHostMBean;
    private AMQBrokerManagerMBean brokerMBean;
    private QueueManagementInformationMBean queueManagementInformationMBean;
    private final AuthenticationManager authenticationManager;
    private SecurityManager securityManager;
    private final ScheduledThreadPoolExecutor houseKeepingTasks;
    private final IApplicationRegistry appRegistry;
    private VirtualHostConfiguration configuration;
    private DurableConfigurationStore durableConfigurationStore;
    private BindingFactory bindingFactory;
    private BrokerConfig broker;
    private UUID id;
    private boolean statisticsEnabled = false;
    private StatisticsCounter messagesDelivered;
    private StatisticsCounter dataDelivered;
    private StatisticsCounter messagesReceived;
    private StatisticsCounter dataReceived;
    private final long createTime = System.currentTimeMillis();
    private final ConcurrentHashMap<BrokerLink, BrokerLink> links = new ConcurrentHashMap();
    private static final int HOUSEKEEPING_SHUTDOWN_TIMEOUT = 5;

    @Override
    public IConnectionRegistry getConnectionRegistry() {
        return this.connectionRegistry;
    }

    @Override
    public VirtualHostConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public VirtualHostConfigType getConfigType() {
        return VirtualHostConfigType.getInstance();
    }

    @Override
    public ConfiguredObject getParent() {
        return this.getBroker();
    }

    @Override
    public boolean isDurable() {
        return false;
    }

    public VirtualHostImpl(IApplicationRegistry appRegistry, VirtualHostConfiguration hostConfig) throws Exception {
        this(appRegistry, hostConfig, null);
    }

    public VirtualHostImpl(VirtualHostConfiguration hostConfig, MessageStore store) throws Exception {
        this(ApplicationRegistry.getInstance(), hostConfig, store);
    }

    private VirtualHostImpl(IApplicationRegistry appRegistry, VirtualHostConfiguration hostConfig, MessageStore store) throws Exception {
        if (hostConfig == null) {
            throw new IllegalAccessException("HostConfig and MessageStore cannot be null");
        }
        this.appRegistry = appRegistry;
        this.broker = this.appRegistry.getBroker();
        this.configuration = hostConfig;
        this.name = this.configuration.getName();
        this.id = this.appRegistry.getConfigStore().createId();
        CurrentActor.get().message(VirtualHostMessages.CREATED(this.name));
        if (this.name == null || this.name.length() == 0) {
            throw new IllegalArgumentException("Illegal name (" + this.name + ") for virtualhost.");
        }
        this.securityManager = new SecurityManager(this.appRegistry.getSecurityManager());
        this.securityManager.configureHostPlugins(this.configuration);
        this.virtualHostMBean = new VirtualHostMBean();
        this.connectionRegistry = new ConnectionRegistry();
        this.houseKeepingTasks = new ScheduledThreadPoolExecutor(this.configuration.getHouseKeepingThreadCount());
        this.queueRegistry = new DefaultQueueRegistry(this);
        this.exchangeFactory = new DefaultExchangeFactory(this);
        this.exchangeFactory.initialise(this.configuration);
        StartupRoutingTable configFileRT = new StartupRoutingTable();
        this.durableConfigurationStore = configFileRT;
        if (store != null) {
            this.messageStore = store;
            this.durableConfigurationStore = store;
        } else {
            this.initialiseAndesStores(hostConfig);
        }
        AndesKernelBoot.startAndesCluster();
        this.exchangeRegistry = new DefaultExchangeRegistry(this);
        this.bindingFactory = new BindingFactory(this);
        this.initialiseModel(this.configuration);
        this.exchangeRegistry.initialise();
        this.authenticationManager = ApplicationRegistry.getInstance().getAuthenticationManager();
        this.brokerMBean = new AMQBrokerManagerMBean(this.virtualHostMBean);
        this.brokerMBean.register();
        this.queueManagementInformationMBean = new QueueManagementInformationMBean(this.virtualHostMBean);
        this.queueManagementInformationMBean.register();
        this.initialiseHouseKeeping(hostConfig.getHousekeepingExpiredMessageCheckPeriod());
        this.initialiseStatistics();
    }

    private void initialiseHouseKeeping(long period) {
        if (period != 0L) {
            class ExpiredMessagesTask
            extends HouseKeepingTask {
                public ExpiredMessagesTask(VirtualHost vhost) {
                    super(vhost);
                }

                @Override
                public void execute() {
                    for (AMQQueue q : VirtualHostImpl.this.queueRegistry.getQueues()) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Checking message status for queue: " + q.getName()));
                        }
                        try {
                            q.checkMessageStatus();
                        }
                        catch (Exception e) {
                            log.error((Object)("Exception in housekeeping for queue: " + q.getNameShortString().toString()), (Throwable)e);
                        }
                    }
                    for (AMQConnectionModel connection : VirtualHostImpl.this.getConnectionRegistry().getConnections()) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Checking for long running open transactions on connection " + connection));
                        }
                        for (AMQSessionModel session : connection.getSessionModels()) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Checking for long running open transactions on session " + session));
                            }
                            try {
                                session.checkTransactionStatus(VirtualHostImpl.this.configuration.getTransactionTimeoutOpenWarn(), VirtualHostImpl.this.configuration.getTransactionTimeoutOpenClose(), VirtualHostImpl.this.configuration.getTransactionTimeoutIdleWarn(), VirtualHostImpl.this.configuration.getTransactionTimeoutIdleClose());
                            }
                            catch (Exception e) {
                                log.error((Object)("Exception in housekeeping for connection: " + connection.toString()), (Throwable)e);
                            }
                        }
                    }
                }
            }
            this.scheduleHouseKeepingTask(period, new ExpiredMessagesTask(this));
            Map<String, VirtualHostPluginFactory> plugins = ApplicationRegistry.getInstance().getPluginManager().getVirtualHostPlugins();
            if (plugins != null) {
                for (Map.Entry<String, VirtualHostPluginFactory> entry : plugins.entrySet()) {
                    String pluginName = entry.getKey();
                    VirtualHostPluginFactory factory = entry.getValue();
                    try {
                        VirtualHostHouseKeepingPlugin plugin = factory.newInstance(this);
                        if (plugin == null) continue;
                        this.houseKeepingTasks.scheduleAtFixedRate(plugin, plugin.getDelay() / 2L, plugin.getDelay(), plugin.getTimeUnit());
                        log.info((Object)("Loaded VirtualHostPlugin:" + plugin));
                    }
                    catch (RuntimeException e) {
                        log.error((Object)("Unable to load VirtualHostPlugin:" + pluginName + " due to:" + e.getMessage()), (Throwable)e);
                    }
                }
            }
        }
    }

    @Override
    public void scheduleHouseKeepingTask(long period, HouseKeepingTask task) {
        this.houseKeepingTasks.scheduleAtFixedRate(task, period / 2L, period, TimeUnit.MILLISECONDS);
    }

    @Override
    public long getHouseKeepingTaskCount() {
        return this.houseKeepingTasks.getTaskCount();
    }

    @Override
    public long getHouseKeepingCompletedTaskCount() {
        return this.houseKeepingTasks.getCompletedTaskCount();
    }

    @Override
    public int getHouseKeepingPoolSize() {
        return this.houseKeepingTasks.getCorePoolSize();
    }

    @Override
    public void setHouseKeepingPoolSize(int newSize) {
        this.houseKeepingTasks.setCorePoolSize(newSize);
    }

    @Override
    public int getHouseKeepingActiveCount() {
        return this.houseKeepingTasks.getActiveCount();
    }

    private void initialiseAndesStores(VirtualHostConfiguration hostConfig) throws Exception {
        AndesKernelBoot.initVirtualHostConfigSynchronizer(this);
        AndesKernelBoot.startAndesStores();
        QpidDeprecatedMessageStore messageStore = new QpidDeprecatedMessageStore();
        VirtualHostConfigRecoveryHandler recoveryHandler = new VirtualHostConfigRecoveryHandler(this);
        MessageStoreLogSubject storeLogSubject = new MessageStoreLogSubject(this, messageStore);
        messageStore.configureConfigStore(this.getName(), recoveryHandler, hostConfig.getStoreConfiguration(), storeLogSubject);
        messageStore.configureMessageStore(this.getName(), recoveryHandler, hostConfig.getStoreConfiguration(), storeLogSubject);
        messageStore.configureTransactionLog(this.getName(), recoveryHandler, hostConfig.getStoreConfiguration(), storeLogSubject);
        this.messageStore = messageStore;
        this.durableConfigurationStore = messageStore;
    }

    private void initialiseModel(VirtualHostConfiguration config) throws ConfigurationException, AMQException {
        String[] queueNames;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Loading configuration for virtualhost: " + config.getName()));
        }
        List exchangeNames = config.getExchanges();
        for (Object exchangeNameObj : exchangeNames) {
            String exchangeName = String.valueOf(exchangeNameObj);
            this.configureExchange(config.getExchangeConfiguration(exchangeName));
        }
        for (String queueNameObj : queueNames = config.getQueueNames()) {
            String queueName = String.valueOf(queueNameObj);
            this.configureQueue(config.getQueueConfiguration(queueName));
        }
    }

    private void configureExchange(ExchangeConfiguration exchangeConfiguration) throws AMQException {
        AMQShortString exchangeName = new AMQShortString(exchangeConfiguration.getName());
        Exchange exchange = this.exchangeRegistry.getExchange(exchangeName);
        if (exchange == null) {
            AMQShortString type = new AMQShortString(exchangeConfiguration.getType());
            boolean durable = exchangeConfiguration.getDurable();
            boolean autodelete = exchangeConfiguration.getAutoDelete();
            Exchange newExchange = this.exchangeFactory.createExchange(exchangeName, type, durable, autodelete, 0);
            this.exchangeRegistry.registerExchange(newExchange);
            if (newExchange.isDurable()) {
                this.durableConfigurationStore.createExchange(newExchange);
                QpidAndesBridge.createExchange(newExchange);
            }
        }
    }

    private void configureQueue(QueueConfiguration queueConfiguration) throws AMQException, ConfigurationException {
        AMQQueue queue = AMQQueueFactory.createAMQQueueImpl(queueConfiguration, this);
        if (queue.isDurable()) {
            this.getDurableConfigurationStore().createQueue(queue);
        }
        QpidAndesBridge.createQueue(queue);
        String exchangeName = queueConfiguration.getExchange();
        Exchange exchange = this.exchangeRegistry.getExchange(exchangeName == null ? null : new AMQShortString(exchangeName));
        if (exchange == null) {
            exchange = this.exchangeRegistry.getDefaultExchange();
        }
        if (exchange == null) {
            throw new ConfigurationException("Attempt to bind queue to unknown exchange:" + exchangeName);
        }
        List<AMQShortString> routingKeys = queueConfiguration.getRoutingKeys();
        if (routingKeys == null || routingKeys.isEmpty()) {
            routingKeys = Collections.singletonList(queue.getNameShortString());
        }
        for (AMQShortString routingKeyNameObj : routingKeys) {
            AMQShortString routingKey = new AMQShortString(String.valueOf(routingKeyNameObj));
            if (log.isInfoEnabled()) {
                log.info((Object)("Binding queue:" + queue + " with routing key '" + routingKey + "' to exchange:" + this));
            }
            this.bindingFactory.addBinding(routingKey.toString(), queue, exchange, null);
        }
        if (exchange != this.exchangeRegistry.getDefaultExchange()) {
            this.bindingFactory.addBinding(queue.getNameShortString().toString(), queue, exchange, null);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public BrokerConfig getBroker() {
        return this.broker;
    }

    @Override
    public String getFederationTag() {
        return this.broker.getFederationTag();
    }

    @Override
    public void setBroker(BrokerConfig broker) {
        this.broker = broker;
    }

    @Override
    public long getCreateTime() {
        return this.createTime;
    }

    @Override
    public QueueRegistry getQueueRegistry() {
        return this.queueRegistry;
    }

    @Override
    public ExchangeRegistry getExchangeRegistry() {
        return this.exchangeRegistry;
    }

    @Override
    public ExchangeFactory getExchangeFactory() {
        return this.exchangeFactory;
    }

    @Override
    public MessageStore getMessageStore() {
        return this.messageStore;
    }

    @Override
    public TransactionLog getTransactionLog() {
        return this.messageStore;
    }

    @Override
    public DurableConfigurationStore getDurableConfigurationStore() {
        return this.durableConfigurationStore;
    }

    @Override
    public AuthenticationManager getAuthenticationManager() {
        return this.authenticationManager;
    }

    @Override
    public SecurityManager getSecurityManager() {
        return this.securityManager;
    }

    @Override
    public void close() {
        this.connectionRegistry.close();
        if (this.queueRegistry != null) {
            for (AMQQueue queue : this.queueRegistry.getQueues()) {
                queue.stop();
            }
        }
        if (this.houseKeepingTasks != null) {
            this.houseKeepingTasks.shutdown();
            try {
                if (!this.houseKeepingTasks.awaitTermination(5L, TimeUnit.SECONDS)) {
                    this.houseKeepingTasks.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                log.warn((Object)("Interrupted during Housekeeping shutdown:" + e.getMessage()));
            }
        }
        if (this.messageStore != null) {
            try {
                this.messageStore.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        CurrentActor.get().message(VirtualHostMessages.CLOSED());
    }

    public ManagedObject getBrokerMBean() {
        return this.brokerMBean;
    }

    @Override
    public ManagedObject getManagedObject() {
        return this.virtualHostMBean;
    }

    @Override
    public UUID getBrokerId() {
        return this.appRegistry.getBrokerId();
    }

    @Override
    public IApplicationRegistry getApplicationRegistry() {
        return this.appRegistry;
    }

    @Override
    public BindingFactory getBindingFactory() {
        return this.bindingFactory;
    }

    @Override
    public void registerMessageDelivered(long messageSize) {
        if (this.isStatisticsEnabled()) {
            this.messagesDelivered.registerEvent(1L);
            this.dataDelivered.registerEvent(messageSize);
        }
        this.appRegistry.registerMessageDelivered(messageSize);
    }

    @Override
    public void registerMessageReceived(long messageSize, long timestamp) {
        if (this.isStatisticsEnabled()) {
            this.messagesReceived.registerEvent(1L, timestamp);
            this.dataReceived.registerEvent(messageSize, timestamp);
        }
        this.appRegistry.registerMessageReceived(messageSize, timestamp);
    }

    @Override
    public StatisticsCounter getMessageReceiptStatistics() {
        return this.messagesReceived;
    }

    @Override
    public StatisticsCounter getDataReceiptStatistics() {
        return this.dataReceived;
    }

    @Override
    public StatisticsCounter getMessageDeliveryStatistics() {
        return this.messagesDelivered;
    }

    @Override
    public StatisticsCounter getDataDeliveryStatistics() {
        return this.dataDelivered;
    }

    @Override
    public void resetStatistics() {
        this.messagesDelivered.reset();
        this.dataDelivered.reset();
        this.messagesReceived.reset();
        this.dataReceived.reset();
        for (AMQConnectionModel connection : this.connectionRegistry.getConnections()) {
            connection.resetStatistics();
        }
    }

    @Override
    public void initialiseStatistics() {
        this.setStatisticsEnabled(!StatisticsCounter.DISABLE_STATISTICS && this.appRegistry.getConfiguration().isStatisticsGenerationVirtualhostsEnabled());
        this.messagesDelivered = new StatisticsCounter("messages-delivered-" + this.getName());
        this.dataDelivered = new StatisticsCounter("bytes-delivered-" + this.getName());
        this.messagesReceived = new StatisticsCounter("messages-received-" + this.getName());
        this.dataReceived = new StatisticsCounter("bytes-received-" + this.getName());
    }

    @Override
    public boolean isStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    @Override
    public void setStatisticsEnabled(boolean enabled) {
        this.statisticsEnabled = enabled;
    }

    @Override
    public void createBrokerConnection(String transport, String host, int port, String vhost, boolean durable, String authMechanism, String username, String password) {
        BrokerLink blink = new BrokerLink(this, transport, host, port, vhost, durable, authMechanism, username, password);
        if (this.links.putIfAbsent(blink, blink) != null) {
            this.getConfigStore().addConfiguredObject(blink);
        }
    }

    public void removeBrokerConnection(String transport, String host, int port, String vhost) {
        this.removeBrokerConnection(new BrokerLink(this, transport, host, port, vhost, false, null, null, null));
    }

    @Override
    public void removeBrokerConnection(BrokerLink blink) {
        if ((blink = this.links.get(blink)) != null) {
            blink.close();
            this.getConfigStore().removeConfiguredObject(blink);
        }
    }

    @Override
    public ConfigStore getConfigStore() {
        return this.getApplicationRegistry().getConfigStore();
    }

    public String toString() {
        return this.name;
    }

    private static class StartupRoutingTable
    implements DurableConfigurationStore {
        public List<Exchange> exchange = new LinkedList<Exchange>();
        public List<CreateQueueTuple> queue = new LinkedList<CreateQueueTuple>();
        public List<CreateBindingTuple> bindings = new LinkedList<CreateBindingTuple>();

        private StartupRoutingTable() {
        }

        public void configure(VirtualHost virtualHost, String base, VirtualHostConfiguration config) throws Exception {
        }

        public void close() throws Exception {
        }

        public void removeMessage(Long messageId) throws AMQException {
        }

        @Override
        public void configureConfigStore(String name, ConfigurationRecoveryHandler recoveryHandler, Configuration config, LogSubject logSubject) throws Exception {
        }

        @Override
        public void createExchange(Exchange exchange) throws AMQStoreException {
            if (exchange.isDurable()) {
                this.exchange.add(exchange);
            }
        }

        @Override
        public void removeExchange(Exchange exchange) throws AMQStoreException {
        }

        @Override
        public void bindQueue(Exchange exchange, AMQShortString routingKey, AMQQueue queue, FieldTable args) throws AMQStoreException {
            if (exchange.isDurable() && queue.isDurable()) {
                this.bindings.add(new CreateBindingTuple(exchange, routingKey, queue, args));
            }
        }

        @Override
        public void unbindQueue(Exchange exchange, AMQShortString routingKey, AMQQueue queue, FieldTable args) throws AMQStoreException {
        }

        @Override
        public void createQueue(AMQQueue queue) throws AMQStoreException {
            this.createQueue(queue, null);
        }

        @Override
        public void createQueue(AMQQueue queue, FieldTable arguments) throws AMQStoreException {
            if (queue.isDurable()) {
                this.queue.add(new CreateQueueTuple(queue, arguments));
            }
        }

        @Override
        public void removeQueue(AMQQueue queue) throws AMQStoreException {
        }

        @Override
        public void updateQueue(AMQQueue queue) throws AMQStoreException {
        }

        private static class CreateBindingTuple {
            public AMQQueue queue;
            public FieldTable arguments;
            public Exchange exchange;
            public AMQShortString routingKey;

            public CreateBindingTuple(Exchange exchange, AMQShortString routingKey, AMQQueue queue, FieldTable args) {
                this.exchange = exchange;
                this.routingKey = routingKey;
                this.queue = queue;
                this.arguments = args;
            }
        }

        private static class CreateQueueTuple {
            public AMQQueue queue;
            public FieldTable arguments;

            public CreateQueueTuple(AMQQueue queue, FieldTable arguments) {
                this.queue = queue;
                this.arguments = arguments;
            }
        }
    }

    public class VirtualHostMBean
    extends AMQManagedObject
    implements ManagedVirtualHost {
        public VirtualHostMBean() throws NotCompliantMBeanException {
            super(ManagedVirtualHost.class, "VirtualHost");
        }

        @Override
        public String getObjectInstanceName() {
            return ObjectName.quote(VirtualHostImpl.this.name);
        }

        @Override
        public String getName() {
            return VirtualHostImpl.this.name;
        }

        public VirtualHostImpl getVirtualHost() {
            return VirtualHostImpl.this;
        }
    }
}

