/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.virtualhost;

import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Logger;
import org.wso2.andes.AMQException;
import org.wso2.andes.AMQInternalException;
import org.wso2.andes.AMQSecurityException;
import org.wso2.andes.amqp.AMQPUtils;
import org.wso2.andes.framing.AMQShortString;
import org.wso2.andes.framing.FieldTable;
import org.wso2.andes.kernel.AndesBinding;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.router.AndesMessageRouter;
import org.wso2.andes.kernel.subscription.StorageQueue;
import org.wso2.andes.server.binding.BindingFactory;
import org.wso2.andes.server.exchange.Exchange;
import org.wso2.andes.server.queue.AMQQueue;
import org.wso2.andes.server.queue.AMQQueueFactory;
import org.wso2.andes.server.queue.DLCQueueUtils;
import org.wso2.andes.server.store.ConfigurationRecoveryHandler;
import org.wso2.andes.server.virtualhost.VirtualHost;

public class VirtualHostConfigSynchronizer
implements ConfigurationRecoveryHandler.QueueRecoveryHandler,
ConfigurationRecoveryHandler.ExchangeRecoveryHandler,
ConfigurationRecoveryHandler.BindingRecoveryHandler {
    private final VirtualHost _virtualHost;
    private static final Logger _logger = Logger.getLogger(VirtualHostConfigSynchronizer.class);
    private static Log log = LogFactory.getLog(VirtualHostConfigSynchronizer.class);

    public VirtualHostConfigSynchronizer(VirtualHost _virtualHost) {
        this._virtualHost = _virtualHost;
    }

    @Override
    public ConfigurationRecoveryHandler.BindingRecoveryHandler completeExchangeRecovery() {
        return null;
    }

    @Override
    public ConfigurationRecoveryHandler.ExchangeRecoveryHandler completeQueueRecovery() {
        return null;
    }

    @Override
    public void completeBindingRecovery() {
    }

    public void clusterExchangeAdded(AndesMessageRouter messageRouter) throws AndesException {
        try {
            if (!"mqtt.topic".equals(messageRouter.getName()) && !AMQPUtils.DLC_EXCHANGE_NAME.equals(messageRouter.getName())) {
                this.exchange(messageRouter.getName(), messageRouter.getType(), messageRouter.isAutoDelete());
            }
        }
        catch (Exception e) {
            log.error((Object)"could not add cluster messageRouter", (Throwable)e);
            throw new AndesException("could not add cluster messageRouter", e);
        }
    }

    public void clusterExchangeRemoved(String exchangeName) throws AndesException {
        try {
            if (!"mqtt.topic".equals(exchangeName) && !AMQPUtils.DLC_EXCHANGE_NAME.equals(exchangeName)) {
                this.removeExchange(exchangeName);
            }
        }
        catch (Exception e) {
            throw new AndesException("could not remove cluster exchange from Internal Qpid registry", e);
        }
    }

    public void clusterQueueAdded(StorageQueue queue) throws AndesException {
        try {
            if (!queue.getName().contains("MQTT_Topic")) {
                this.queue(queue.getName(), queue.getQueueOwner(), queue.isExclusive(), null);
            }
        }
        catch (Exception e) {
            log.error((Object)"could not add cluster queue", (Throwable)e);
            throw new AndesException("could not add cluster queue : " + queue.toString(), e);
        }
    }

    public void clusterQueueRemoved(StorageQueue queue) throws AndesException {
        try {
            log.info((Object)("Queue removal request received queue= " + queue.getName()));
            if (!queue.getName().contains("MQTT_Topic")) {
                this.removeQueue(queue.getName());
            }
        }
        catch (Exception e) {
            log.error((Object)"could not remove cluster queue", (Throwable)e);
            throw new AndesException("could not remove cluster queue : " + queue.toString(), e);
        }
    }

    public void clusterBindingAdded(AndesBinding binding) throws AndesException {
        try {
            String boundQueueName = binding.getBoundQueue().getName();
            if (!boundQueueName.contains("MQTT_Topic") && !DLCQueueUtils.isDeadLetterQueue(boundQueueName)) {
                this.binding(binding.getMessageRouterName(), binding.getBoundQueue().getName(), binding.getBindingKey(), null);
            }
        }
        catch (Exception e) {
            log.error((Object)("could not add cluster binding + " + binding.toString()), (Throwable)e);
            throw new AndesException("could not add cluster binding : " + binding.toString(), e);
        }
    }

    public void clusterBindingRemoved(AndesBinding binding) throws AndesException {
        try {
            String boundQueueName = binding.getBoundQueue().getName();
            if (!boundQueueName.contains("MQTT_Topic") && !DLCQueueUtils.isDeadLetterQueue(boundQueueName)) {
                this.removeBinding(binding.getMessageRouterName(), binding.getBoundQueue().getName(), binding.getBindingKey(), null);
            }
        }
        catch (Exception e) {
            log.error((Object)("could not remove cluster binding + " + binding.toString()), (Throwable)e);
            throw new AndesException("could not remove cluster binding : " + binding.toString(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exchange(String exchangeName, String type, boolean autoDelete) {
        VirtualHostConfigSynchronizer virtualHostConfigSynchronizer = this;
        synchronized (virtualHostConfigSynchronizer) {
            try {
                AMQShortString exchangeNameSS = new AMQShortString(exchangeName);
                Exchange exchange = this._virtualHost.getExchangeRegistry().getExchange(exchangeNameSS);
                if (exchange == null) {
                    exchange = this._virtualHost.getExchangeFactory().createExchange(exchangeNameSS, new AMQShortString(type), true, autoDelete, 0);
                    this._virtualHost.getExchangeRegistry().registerExchange(exchange);
                    if (_logger.isDebugEnabled()) {
                        _logger.debug((Object)("Added Exchange: " + exchangeName + ", Type: " + type + ", autoDelete: " + autoDelete));
                    }
                }
            }
            catch (AMQException e) {
                log.error((Object)"Error while creating Exchanges", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void queue(String queueName, String owner, boolean exclusive, FieldTable arguments) {
        VirtualHostConfigSynchronizer virtualHostConfigSynchronizer = this;
        synchronized (virtualHostConfigSynchronizer) {
            try {
                AMQShortString queueNameShortString = new AMQShortString(queueName);
                AMQQueue q = this._virtualHost.getQueueRegistry().getQueue(queueNameShortString);
                if (q == null) {
                    q = AMQQueueFactory.createAMQQueueImpl(queueNameShortString, true, owner == null ? null : new AMQShortString(owner), false, exclusive, this._virtualHost, arguments);
                    this._virtualHost.getQueueRegistry().registerQueue(q);
                    if (_logger.isDebugEnabled()) {
                        _logger.debug((Object)("Queue sync - Added Queue: " + queueName + ", Owner: " + owner + ", IsExclusive: " + exclusive + ", Arguments: " + arguments));
                    }
                }
            }
            catch (AMQException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void binding(String exchangeName, String queueName, String bindingKey, ByteBuffer buf) {
        VirtualHostConfigSynchronizer virtualHostConfigSynchronizer = this;
        synchronized (virtualHostConfigSynchronizer) {
            try {
                Exchange exchange = this._virtualHost.getExchangeRegistry().getExchange(exchangeName);
                if (exchange == null) {
                    _logger.error((Object)("Unknown exchange: " + exchangeName + ", cannot bind queue : " + queueName));
                    return;
                }
                AMQQueue queue = this._virtualHost.getQueueRegistry().getQueue(new AMQShortString(queueName));
                if (queue == null) {
                    _logger.error((Object)("Unknown queue: " + queueName + ", cannot be bound to exchange: " + exchangeName));
                } else {
                    FieldTable argumentsFT = null;
                    if (buf != null) {
                        argumentsFT = new FieldTable(org.wso2.org.apache.mina.common.ByteBuffer.wrap(buf), buf.limit());
                    }
                    BindingFactory bf = this._virtualHost.getBindingFactory();
                    Map<String, Object> argumentMap = FieldTable.convertToMap(argumentsFT);
                    boolean isBindingAlreadyPresent = true;
                    if (bf.getBinding(bindingKey, queue, exchange, argumentMap) == null) {
                        if (exchange.getName().equals(AMQPUtils.DIRECT_EXCHANGE_NAME)) {
                            Exchange testExchange = this._virtualHost.getExchangeRegistry().getExchange(AMQPUtils.DEFAULT_EXCHANGE_NAME);
                            if (bf.getBinding(bindingKey, queue, testExchange, argumentMap) == null) {
                                isBindingAlreadyPresent = false;
                            }
                        } else {
                            isBindingAlreadyPresent = false;
                        }
                    }
                    if (!isBindingAlreadyPresent) {
                        if (_logger.isDebugEnabled()) {
                            _logger.debug((Object)("Binding Sync - Added  Binding: (Exchange: " + exchange.getNameShortString() + ", Queue: " + queueName + ", Routing Key: " + bindingKey + ", Arguments: " + argumentsFT + ")"));
                        }
                        bf.restoreBinding(bindingKey, queue, exchange, argumentMap);
                    }
                }
            }
            catch (AMQException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeBinding(String exchangeName, String queueName, String bindingKey, ByteBuffer buf) throws AMQSecurityException, AMQInternalException {
        VirtualHostConfigSynchronizer virtualHostConfigSynchronizer = this;
        synchronized (virtualHostConfigSynchronizer) {
            Exchange exchange = this._virtualHost.getExchangeRegistry().getExchange(exchangeName);
            if (exchange == null) {
                return;
            }
            AMQQueue queue = this._virtualHost.getQueueRegistry().getQueue(new AMQShortString(queueName));
            if (queue != null) {
                Map<String, Object> argumentMap;
                BindingFactory bf;
                FieldTable argumentsFT = null;
                if (buf != null) {
                    argumentsFT = new FieldTable(org.wso2.org.apache.mina.common.ByteBuffer.wrap(buf), buf.limit());
                }
                if ((bf = this._virtualHost.getBindingFactory()).getBinding(bindingKey, queue, exchange, argumentMap = FieldTable.convertToMap(argumentsFT)) != null) {
                    if (_logger.isDebugEnabled()) {
                        _logger.debug((Object)("Binding Sync - Removed binding: (Exchange: " + exchange.getNameShortString() + ", Queue: " + queueName + ", Routing Key: " + bindingKey + ", Arguments: " + argumentsFT + ")"));
                    }
                    bf.removeBinding(bindingKey, queue, exchange, argumentMap, false);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeQueue(String queueName) throws AndesException {
        VirtualHostConfigSynchronizer virtualHostConfigSynchronizer = this;
        synchronized (virtualHostConfigSynchronizer) {
            AMQShortString queueNameShortString = new AMQShortString(queueName);
            AMQQueue q = this._virtualHost.getQueueRegistry().getQueue(queueNameShortString);
            if (q != null) {
                try {
                    q.remoteDelete();
                }
                catch (AMQException e) {
                    _logger.error((Object)("Error while removing the queue " + queueName));
                    throw new AndesException(e);
                }
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)("Queue sync - Removed Queue: " + queueName));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeExchange(String exchangeName) throws AMQException {
        VirtualHostConfigSynchronizer virtualHostConfigSynchronizer = this;
        synchronized (virtualHostConfigSynchronizer) {
            this._virtualHost.getExchangeRegistry().unregisterExchange(exchangeName, true);
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("Exchange sync - Removed Exchange: " + exchangeName));
            }
        }
    }
}

