/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.txn;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.transaction.xa.Xid;
import org.apache.commons.lang.NotImplementedException;
import org.apache.log4j.Logger;
import org.wso2.andes.AMQException;
import org.wso2.andes.amqp.QpidAndesBridge;
import org.wso2.andes.kernel.Andes;
import org.wso2.andes.kernel.AndesAckData;
import org.wso2.andes.kernel.AndesChannel;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.AndesMessage;
import org.wso2.andes.kernel.disruptor.DisruptorEventCallback;
import org.wso2.andes.kernel.dtx.AlreadyKnownDtxException;
import org.wso2.andes.kernel.dtx.DistributedTransaction;
import org.wso2.andes.kernel.dtx.JoinAndResumeDtxException;
import org.wso2.andes.kernel.dtx.NotAssociatedDtxException;
import org.wso2.andes.kernel.dtx.SuspendAndFailDtxException;
import org.wso2.andes.kernel.dtx.UnknownDtxBranchException;
import org.wso2.andes.server.message.EnqueableMessage;
import org.wso2.andes.server.queue.BaseQueue;
import org.wso2.andes.server.queue.IncomingMessage;
import org.wso2.andes.server.queue.QueueEntry;
import org.wso2.andes.server.txn.IncorrectDtxStateException;
import org.wso2.andes.server.txn.RollbackOnlyDtxException;
import org.wso2.andes.server.txn.ServerTransaction;
import org.wso2.andes.server.txn.TimeoutDtxException;

public class QpidDistributedTransaction
implements ServerTransaction {
    private static final Logger LOGGER = Logger.getLogger(QpidDistributedTransaction.class);
    private final DistributedTransaction distributedTransaction;
    private final Andes andes;
    private final ConcurrentLinkedQueue<ServerTransaction.Action> postTransactionActions = new ConcurrentLinkedQueue();

    public QpidDistributedTransaction(AndesChannel channel, UUID sessionID) throws AndesException {
        this.andes = Andes.getInstance();
        this.distributedTransaction = this.andes.createDistributedTransaction(channel, sessionID);
    }

    @Override
    public long getTransactionStartTime() {
        return 0L;
    }

    @Override
    public void addPostTransactionAction(ServerTransaction.Action postTransactionAction) {
        this.postTransactionActions.add(postTransactionAction);
    }

    @Override
    public void dequeue(BaseQueue queue, EnqueableMessage message, ServerTransaction.Action postTransactionAction) {
        throw new NotImplementedException();
    }

    @Override
    public void dequeue(Collection<QueueEntry> messages, ServerTransaction.Action postTransactionAction) {
        throw new NotImplementedException();
    }

    @Override
    public void dequeue(UUID channelID, Collection<QueueEntry> messages, ServerTransaction.Action postTransactionAction) throws AMQException {
        ArrayList<AndesAckData> ackList = new ArrayList<AndesAckData>(messages.size());
        try {
            for (QueueEntry entry : messages) {
                ackList.add(new AndesAckData(channelID, entry.getMessage().getMessageNumber()));
            }
            this.distributedTransaction.dequeue(ackList);
        }
        catch (AndesException e) {
            throw new AMQException("Error occurred while creating a AndesAckEvent ", e);
        }
    }

    @Override
    public void enqueue(BaseQueue queue, EnqueableMessage message, ServerTransaction.Action postTransactionAction) {
        throw new NotImplementedException();
    }

    @Override
    public void enqueue(List<? extends BaseQueue> queues, EnqueableMessage message, ServerTransaction.Action postTransactionAction) {
        throw new NotImplementedException();
    }

    @Override
    public void commit() {
        throw new IllegalStateException("Cannot call tx.commit() on a distributed transaction");
    }

    @Override
    public void rollback() {
        throw new IllegalStateException("Cannot call tx.rollback() on a distributed transaction");
    }

    public void start(UUID sessionID, Xid xid, boolean join, boolean resume) throws JoinAndResumeDtxException, UnknownDtxBranchException, AlreadyKnownDtxException, AndesException {
        this.distributedTransaction.start(sessionID, xid, join, resume);
    }

    public void end(UUID sessionID, Xid xid, boolean fail, boolean suspend) throws UnknownDtxBranchException, SuspendAndFailDtxException, NotAssociatedDtxException, TimeoutDtxException, AndesException {
        this.distributedTransaction.end(sessionID, xid, fail, suspend);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare(Xid xid, DisruptorEventCallback callback) throws TimeoutDtxException, UnknownDtxBranchException, IncorrectDtxStateException, AndesException, RollbackOnlyDtxException {
        try {
            this.distributedTransaction.prepare(xid, callback);
        }
        finally {
            for (ServerTransaction.Action action : this.postTransactionActions) {
                action.postCommit();
            }
        }
    }

    public void commit(Xid xid, boolean onePhase, DisruptorEventCallback callback) throws UnknownDtxBranchException, IncorrectDtxStateException, AndesException, TimeoutDtxException, RollbackOnlyDtxException {
        this.distributedTransaction.commit(xid, onePhase, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(Xid xid, DisruptorEventCallback callback) throws UnknownDtxBranchException, AndesException, TimeoutDtxException, IncorrectDtxStateException {
        try {
            this.distributedTransaction.rollback(xid, callback);
        }
        finally {
            for (ServerTransaction.Action action : this.postTransactionActions) {
                action.onRollback();
            }
        }
    }

    public void enqueueMessage(IncomingMessage incomingMessage, AndesChannel andesChannel) {
        try {
            AndesMessage andesMessage = QpidAndesBridge.convertToAndesMessage(incomingMessage);
            this.distributedTransaction.enqueueMessage(andesMessage, andesChannel);
        }
        catch (AndesException e) {
            LOGGER.warn((Object)"Converting incoming message to Andes message failed", (Throwable)e);
            this.failTransaction(e.getMessage());
        }
    }

    public void close(UUID sessionId) {
        try {
            this.distributedTransaction.close(sessionId);
        }
        finally {
            this.andes.releaseDistributedTransaction(sessionId);
        }
    }

    public void failTransaction(String reason) {
        this.distributedTransaction.failTransaction(reason);
    }

    public void forget(Xid xid) throws UnknownDtxBranchException, IncorrectDtxStateException, AndesException {
        this.distributedTransaction.forget(xid);
    }

    public void setTimeout(Xid xid, long timeout) throws UnknownDtxBranchException, AndesException {
        this.distributedTransaction.setTimeout(xid, timeout);
    }
}

