/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.txn;

import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.commons.lang.NotImplementedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.andes.AMQException;
import org.wso2.andes.server.message.EnqueableMessage;
import org.wso2.andes.server.message.ServerMessage;
import org.wso2.andes.server.queue.AMQQueue;
import org.wso2.andes.server.queue.BaseQueue;
import org.wso2.andes.server.queue.QueueEntry;
import org.wso2.andes.server.store.TransactionLog;
import org.wso2.andes.server.txn.ServerTransaction;

public class LocalTransaction
implements ServerTransaction {
    protected static final Logger _logger = LoggerFactory.getLogger(LocalTransaction.class);
    private final ConcurrentLinkedQueue<ServerTransaction.Action> _postTransactionActions = new ConcurrentLinkedQueue();
    private volatile TransactionLog.Transaction _transaction;
    private TransactionLog _transactionLog;
    private long _txnStartTime = 0L;

    public LocalTransaction(TransactionLog transactionLog) {
        this._transactionLog = transactionLog;
    }

    public boolean inTransaction() {
        return this._transaction != null;
    }

    @Override
    public long getTransactionStartTime() {
        return this._txnStartTime;
    }

    @Override
    public void addPostTransactionAction(ServerTransaction.Action postTransactionAction) {
        this._postTransactionActions.add(postTransactionAction);
    }

    @Override
    public void dequeue(BaseQueue queue, EnqueableMessage message, ServerTransaction.Action postTransactionAction) {
        this._postTransactionActions.add(postTransactionAction);
        if (message.isPersistent() && queue.isDurable()) {
            try {
                if (_logger.isDebugEnabled()) {
                    _logger.debug("Dequeue of message number " + message.getMessageNumber() + " from transaction log. Queue : " + queue.getNameShortString());
                }
                this.beginTranIfNecessary();
                this._transaction.dequeueMessage(queue, message.getMessageNumber());
            }
            catch (AMQException e) {
                _logger.error("Error during message dequeues", (Throwable)e);
                this.tidyUpOnError(e);
            }
        }
    }

    @Override
    public void dequeue(Collection<QueueEntry> queueEntries, ServerTransaction.Action postTransactionAction) {
        this._postTransactionActions.add(postTransactionAction);
        try {
            for (QueueEntry entry : queueEntries) {
                ServerMessage message = entry.getMessage();
                AMQQueue queue = entry.getQueue();
                if (!message.isPersistent() || !queue.isDurable()) continue;
                if (_logger.isDebugEnabled()) {
                    _logger.debug("Dequeue of message number " + message.getMessageNumber() + " from transaction log. Queue : " + queue.getNameShortString());
                }
                this.beginTranIfNecessary();
                this._transaction.dequeueMessage(queue, message.getMessageNumber());
            }
        }
        catch (AMQException e) {
            _logger.error("Error during message dequeues", (Throwable)e);
            this.tidyUpOnError(e);
        }
    }

    @Override
    public void dequeue(UUID channelID, Collection<QueueEntry> queueEntries, ServerTransaction.Action postTransactionAction) {
        throw new NotImplementedException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tidyUpOnError(Exception e) {
        try {
            for (ServerTransaction.Action action : this._postTransactionActions) {
                action.onRollback();
            }
        }
        finally {
            try {
                if (this._transaction != null) {
                    this._transaction.abortTran();
                }
            }
            catch (Exception abortException) {
                _logger.error("Abort transaction failed while trying to handle previous error", (Throwable)abortException);
            }
            finally {
                this.resetDetails();
            }
        }
        throw new RuntimeException(e);
    }

    private void beginTranIfNecessary() {
        if (this._transaction == null) {
            try {
                this._transaction = this._transactionLog.newTransaction();
            }
            catch (Exception e) {
                this.tidyUpOnError(e);
            }
        }
    }

    @Override
    public void enqueue(BaseQueue queue, EnqueableMessage message, ServerTransaction.Action postTransactionAction) {
        this._postTransactionActions.add(postTransactionAction);
        if (message.isPersistent() && queue.isDurable()) {
            try {
                if (_logger.isDebugEnabled()) {
                    _logger.debug("Enqueue of message number " + message.getMessageNumber() + " to transaction log. Queue : " + queue.getNameShortString());
                }
                this.beginTranIfNecessary();
                this._transaction.enqueueMessage(queue, message.getMessageNumber());
            }
            catch (Exception e) {
                _logger.error("Error during message enqueue", (Throwable)e);
                this.tidyUpOnError(e);
            }
        }
    }

    @Override
    public void enqueue(List<? extends BaseQueue> queues, EnqueableMessage message, ServerTransaction.Action postTransactionAction) {
        this._postTransactionActions.add(postTransactionAction);
        if (this._txnStartTime == 0L) {
            this._txnStartTime = System.currentTimeMillis();
        }
        if (message.isPersistent()) {
            try {
                for (BaseQueue baseQueue : queues) {
                    if (!baseQueue.isDurable()) continue;
                    if (_logger.isDebugEnabled()) {
                        _logger.debug("Enqueue of message number " + message.getMessageNumber() + " to transaction log. Queue : " + baseQueue.getNameShortString());
                    }
                    this.beginTranIfNecessary();
                    this._transaction.enqueueMessage(baseQueue, message.getMessageNumber());
                }
            }
            catch (Exception e) {
                _logger.error("Error during message enqueue", (Throwable)e);
                this.tidyUpOnError(e);
            }
        }
    }

    @Override
    public void commit() {
        try {
            if (this._transaction != null) {
                this._transaction.commitTran();
            }
            for (ServerTransaction.Action action : this._postTransactionActions) {
                action.postCommit();
            }
        }
        catch (Exception e) {
            _logger.error("Failed to commit transaction", (Throwable)e);
            for (ServerTransaction.Action action : this._postTransactionActions) {
                action.onRollback();
            }
            throw new RuntimeException("Failed to commit transaction", e);
        }
        finally {
            this.resetDetails();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() {
        try {
            if (this._transaction != null) {
                this._transaction.abortTran();
            }
        }
        catch (AMQException e) {
            _logger.error("Failed to rollback transaction", (Throwable)e);
            throw new RuntimeException("Failed to rollback transaction", e);
        }
        finally {
            try {
                for (ServerTransaction.Action action : this._postTransactionActions) {
                    action.onRollback();
                }
            }
            finally {
                this.resetDetails();
            }
        }
    }

    private void resetDetails() {
        this._transaction = null;
        this._postTransactionActions.clear();
        this._txnStartTime = 0L;
    }
}

