/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.transport;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.wso2.andes.AMQException;
import org.wso2.andes.AMQUnknownExchangeType;
import org.wso2.andes.amqp.AMQPUtils;
import org.wso2.andes.amqp.QpidAndesBridge;
import org.wso2.andes.framing.AMQShortString;
import org.wso2.andes.framing.FieldTable;
import org.wso2.andes.kernel.Andes;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.server.exchange.Exchange;
import org.wso2.andes.server.exchange.ExchangeFactory;
import org.wso2.andes.server.exchange.ExchangeInUseException;
import org.wso2.andes.server.exchange.ExchangeRegistry;
import org.wso2.andes.server.exchange.ExchangeType;
import org.wso2.andes.server.exchange.HeadersExchange;
import org.wso2.andes.server.filter.FilterManager;
import org.wso2.andes.server.filter.FilterManagerFactory;
import org.wso2.andes.server.flow.WindowCreditManager;
import org.wso2.andes.server.message.MessageMetaData_0_10;
import org.wso2.andes.server.message.MessageTransferMessage;
import org.wso2.andes.server.queue.AMQQueue;
import org.wso2.andes.server.queue.AMQQueueFactory;
import org.wso2.andes.server.queue.BaseQueue;
import org.wso2.andes.server.queue.QueueRegistry;
import org.wso2.andes.server.registry.ApplicationRegistry;
import org.wso2.andes.server.registry.IApplicationRegistry;
import org.wso2.andes.server.security.SecurityManager;
import org.wso2.andes.server.store.DurableConfigurationStore;
import org.wso2.andes.server.store.MessageStore;
import org.wso2.andes.server.store.StoredMessage;
import org.wso2.andes.server.subscription.Subscription_0_10;
import org.wso2.andes.server.transport.ServerConnection;
import org.wso2.andes.server.transport.ServerSession;
import org.wso2.andes.server.virtualhost.VirtualHost;
import org.wso2.andes.transport.Acquired;
import org.wso2.andes.transport.DeliveryProperties;
import org.wso2.andes.transport.ExchangeBind;
import org.wso2.andes.transport.ExchangeBound;
import org.wso2.andes.transport.ExchangeBoundResult;
import org.wso2.andes.transport.ExchangeDeclare;
import org.wso2.andes.transport.ExchangeDelete;
import org.wso2.andes.transport.ExchangeQuery;
import org.wso2.andes.transport.ExchangeQueryResult;
import org.wso2.andes.transport.ExchangeUnbind;
import org.wso2.andes.transport.ExecutionErrorCode;
import org.wso2.andes.transport.ExecutionException;
import org.wso2.andes.transport.MessageAccept;
import org.wso2.andes.transport.MessageAcceptMode;
import org.wso2.andes.transport.MessageAcquire;
import org.wso2.andes.transport.MessageAcquireMode;
import org.wso2.andes.transport.MessageCancel;
import org.wso2.andes.transport.MessageFlow;
import org.wso2.andes.transport.MessageFlowMode;
import org.wso2.andes.transport.MessageFlush;
import org.wso2.andes.transport.MessageReject;
import org.wso2.andes.transport.MessageRelease;
import org.wso2.andes.transport.MessageResume;
import org.wso2.andes.transport.MessageSetFlowMode;
import org.wso2.andes.transport.MessageStop;
import org.wso2.andes.transport.MessageSubscribe;
import org.wso2.andes.transport.MessageTransfer;
import org.wso2.andes.transport.Method;
import org.wso2.andes.transport.Option;
import org.wso2.andes.transport.QueueDeclare;
import org.wso2.andes.transport.QueueDelete;
import org.wso2.andes.transport.QueuePurge;
import org.wso2.andes.transport.QueueQuery;
import org.wso2.andes.transport.QueueQueryResult;
import org.wso2.andes.transport.RangeSet;
import org.wso2.andes.transport.Session;
import org.wso2.andes.transport.SessionDelegate;
import org.wso2.andes.transport.TxCommit;
import org.wso2.andes.transport.TxRollback;
import org.wso2.andes.transport.TxSelect;

public class ServerSessionDelegate
extends SessionDelegate {
    private final IApplicationRegistry _appRegistry;

    public ServerSessionDelegate(IApplicationRegistry appRegistry) {
        this._appRegistry = appRegistry;
    }

    @Override
    public void command(Session session, Method method) {
        ServerConnection scon = (ServerConnection)session.getConnection();
        SecurityManager.setThreadSubject(scon.getAuthorizedSubject());
        if (!session.isClosing()) {
            super.command(session, method);
            if (method.isSync()) {
                session.flushProcessed(new Option[0]);
            }
        }
    }

    @Override
    public void messageAccept(Session session, MessageAccept method) {
        ((ServerSession)session).accept(method.getTransfers());
    }

    @Override
    public void messageReject(Session session, MessageReject method) {
        ((ServerSession)session).reject(method.getTransfers());
    }

    @Override
    public void messageRelease(Session session, MessageRelease method) {
        ((ServerSession)session).release(method.getTransfers());
    }

    @Override
    public void messageAcquire(Session session, MessageAcquire method) {
        RangeSet acquiredRanges = ((ServerSession)session).acquire(method.getTransfers());
        Acquired result = new Acquired(acquiredRanges);
        session.executionResult(method.getId(), result, new Option[0]);
    }

    @Override
    public void messageResume(Session session, MessageResume method) {
        super.messageResume(session, method);
    }

    @Override
    public void messageSubscribe(Session session, MessageSubscribe method) {
        if (!method.hasAcceptMode()) {
            method.setAcceptMode(MessageAcceptMode.EXPLICIT);
        }
        if (!method.hasAcquireMode()) {
            method.setAcquireMode(MessageAcquireMode.PRE_ACQUIRED);
        }
        if (!method.hasQueue()) {
            this.exception(session, (Method)method, ExecutionErrorCode.ILLEGAL_ARGUMENT, "queue not supplied");
        } else {
            String destination = method.getDestination();
            if (((ServerSession)session).getSubscription(destination) != null) {
                this.exception(session, (Method)method, ExecutionErrorCode.NOT_ALLOWED, "Subscription already exists with destaination: '" + destination + "'");
            } else {
                String queueName = method.getQueue();
                QueueRegistry queueRegistry = this.getQueueRegistry(session);
                final AMQQueue queue = queueRegistry.getQueue(queueName);
                if (queue == null) {
                    this.exception(session, (Method)method, ExecutionErrorCode.NOT_FOUND, "Queue: " + queueName + " not found");
                } else if (queue.getAuthorizationHolder() != null && queue.getAuthorizationHolder() != session) {
                    this.exception(session, (Method)method, ExecutionErrorCode.RESOURCE_LOCKED, "Exclusive Queue: " + queueName + " owned exclusively by another session");
                } else {
                    if (queue.isExclusive()) {
                        ServerSession s = (ServerSession)session;
                        queue.setExclusiveOwningSession(s);
                        if (queue.getAuthorizationHolder() == null) {
                            queue.setAuthorizationHolder(s);
                            queue.setExclusiveOwningSession(s);
                            ((ServerSession)session).addSessionCloseTask(new ServerSession.Task(){

                                @Override
                                public void doTask(ServerSession session) {
                                    if (queue.getAuthorizationHolder() == session) {
                                        queue.setAuthorizationHolder(null);
                                        queue.setExclusiveOwningSession(null);
                                    }
                                }
                            });
                        }
                    }
                    WindowCreditManager creditManager = new WindowCreditManager(0L, 0L);
                    FilterManager filterManager = null;
                    try {
                        filterManager = FilterManagerFactory.createManager(method.getArguments());
                    }
                    catch (AMQException amqe) {
                        this.exception(session, (Method)method, ExecutionErrorCode.ILLEGAL_ARGUMENT, "Exception Creating FilterManager");
                        return;
                    }
                    Subscription_0_10 sub = new Subscription_0_10((ServerSession)session, destination, method.getAcceptMode(), method.getAcquireMode(), MessageFlowMode.WINDOW, creditManager, filterManager, method.getArguments());
                    ((ServerSession)session).register(destination, sub);
                    try {
                        queue.registerSubscription(sub, method.getExclusive());
                    }
                    catch (AMQQueue.ExistingExclusiveSubscription existing) {
                        this.exception(session, (Method)method, ExecutionErrorCode.RESOURCE_LOCKED, "Queue has an exclusive consumer");
                    }
                    catch (AMQQueue.ExistingSubscriptionPreventsExclusive exclusive) {
                        this.exception(session, (Method)method, ExecutionErrorCode.RESOURCE_LOCKED, "Queue has an existing consumer - can't subscribe exclusively");
                    }
                    catch (AMQException e) {
                        this.exception(session, (Method)method, e, "Cannot subscribe to '" + destination);
                    }
                }
            }
        }
    }

    @Override
    public void messageTransfer(Session ssn, MessageTransfer xfr) {
        Exchange exchange;
        ExchangeRegistry exchangeRegistry = this.getExchangeRegistry(ssn);
        if (xfr.hasDestination()) {
            exchange = exchangeRegistry.getExchange(xfr.getDestination());
            if (exchange == null) {
                exchange = exchangeRegistry.getDefaultExchange();
            }
        } else {
            exchange = exchangeRegistry.getDefaultExchange();
        }
        DeliveryProperties delvProps = null;
        if (xfr.getHeader() != null && (delvProps = xfr.getHeader().get(DeliveryProperties.class)) != null && delvProps.hasTtl() && !delvProps.hasExpiration()) {
            delvProps.setExpiration(System.currentTimeMillis() + delvProps.getTtl());
        }
        MessageMetaData_0_10 messageMetaData = new MessageMetaData_0_10(xfr);
        if (!this.getVirtualHost(ssn).getSecurityManager().authorisePublish(messageMetaData.isImmediate(), messageMetaData.getRoutingKey(), exchange.getName())) {
            ExecutionErrorCode errorCode = ExecutionErrorCode.UNAUTHORIZED_ACCESS;
            String description = "Permission denied: exchange-name '" + exchange.getName() + "'";
            this.exception(ssn, (Method)xfr, errorCode, description);
            return;
        }
        MessageStore store = this.getVirtualHost(ssn).getMessageStore();
        StoredMessage<MessageMetaData_0_10> storeMessage = store.addMessage(messageMetaData);
        ByteBuffer body = xfr.getBody();
        if (body != null) {
            storeMessage.addContent(0, body);
        }
        storeMessage.flushToStore();
        MessageTransferMessage message = new MessageTransferMessage(storeMessage, ((ServerSession)ssn).getReference());
        ArrayList<? extends BaseQueue> queues = exchange.route(message);
        ssn.processed(xfr);
    }

    @Override
    public void messageCancel(Session session, MessageCancel method) {
        String destination = method.getDestination();
        Subscription_0_10 sub = ((ServerSession)session).getSubscription(destination);
        if (sub == null) {
            this.exception(session, (Method)method, ExecutionErrorCode.NOT_FOUND, "not-found: destination '" + destination + "'");
        } else {
            AMQQueue queue = sub.getQueue();
            ((ServerSession)session).unregister(sub);
            if (!queue.isDeleted() && queue.isExclusive() && queue.getConsumerCount() == 0) {
                queue.setAuthorizationHolder(null);
            }
        }
    }

    @Override
    public void messageFlush(Session session, MessageFlush method) {
        String destination = method.getDestination();
        Subscription_0_10 sub = ((ServerSession)session).getSubscription(destination);
        if (sub == null) {
            this.exception(session, (Method)method, ExecutionErrorCode.NOT_FOUND, "not-found: destination '" + destination + "'");
        } else {
            try {
                sub.flush();
            }
            catch (AMQException e) {
                this.exception(session, (Method)method, e, "Cannot flush subscription '" + destination);
            }
        }
    }

    @Override
    public void txSelect(Session session, TxSelect method) {
        ((ServerSession)session).selectTx();
    }

    @Override
    public void txCommit(Session session, TxCommit method) {
        ((ServerSession)session).commit();
    }

    @Override
    public void txRollback(Session session, TxRollback method) {
        ((ServerSession)session).rollback();
    }

    @Override
    public void exchangeDeclare(Session session, ExchangeDeclare method) {
        String exchangeName = method.getExchange();
        VirtualHost virtualHost = this.getVirtualHost(session);
        Exchange exchange = this.getExchange(session, exchangeName);
        if (method.getPassive()) {
            if (exchange == null) {
                this.exception(session, (Method)method, ExecutionErrorCode.NOT_FOUND, "not-found: exchange-name '" + exchangeName + "'");
            } else if (!exchange.getTypeShortString().toString().equals(method.getType())) {
                this.exception(session, (Method)method, ExecutionErrorCode.NOT_ALLOWED, "Cannot redeclare with a different exchange type");
            }
        } else if (exchange == null) {
            ExchangeRegistry exchangeRegistry = this.getExchangeRegistry(session);
            ExchangeFactory exchangeFactory = virtualHost.getExchangeFactory();
            try {
                exchange = exchangeFactory.createExchange(method.getExchange(), method.getType(), method.getDurable(), method.getAutoDelete());
                String alternateExchangeName = method.getAlternateExchange();
                if (alternateExchangeName != null && alternateExchangeName.length() != 0) {
                    Exchange alternate = this.getExchange(session, alternateExchangeName);
                    exchange.setAlternateExchange(alternate);
                }
                if (exchange.isDurable()) {
                    DurableConfigurationStore store = virtualHost.getDurableConfigurationStore();
                    store.createExchange(exchange);
                    QpidAndesBridge.createExchange(exchange);
                }
                exchangeRegistry.registerExchange(exchange);
            }
            catch (AMQUnknownExchangeType e) {
                this.exception(session, (Method)method, ExecutionErrorCode.NOT_FOUND, "Unknown Exchange Type: " + method.getType());
            }
            catch (AMQException e) {
                this.exception(session, (Method)method, e, "Cannot declare exchange '" + exchangeName);
            }
        } else if (!exchange.getTypeShortString().toString().equals(method.getType())) {
            this.exception(session, (Method)method, ExecutionErrorCode.NOT_ALLOWED, "Cannot redeclare with a different exchange type");
        }
    }

    private void exception(Session session, Method method, AMQException exception, String message) {
        ExecutionErrorCode errorCode = ExecutionErrorCode.INTERNAL_ERROR;
        if (exception.getErrorCode() != null) {
            try {
                errorCode = ExecutionErrorCode.get(exception.getErrorCode().getCode());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        String description = message + "': " + exception.getMessage();
        this.exception(session, method, errorCode, description);
    }

    private void exception(Session session, Method method, ExecutionErrorCode errorCode, String description) {
        ExecutionException ex = new ExecutionException();
        ex.setErrorCode(errorCode);
        ex.setCommandId(method.getId());
        ex.setDescription(description);
        session.invoke(ex);
        session.close();
    }

    private Exchange getExchange(Session session, String exchangeName) {
        ExchangeRegistry exchangeRegistry = this.getExchangeRegistry(session);
        return exchangeRegistry.getExchange(exchangeName);
    }

    private ExchangeRegistry getExchangeRegistry(Session session) {
        VirtualHost virtualHost = this.getVirtualHost(session);
        return virtualHost.getExchangeRegistry();
    }

    private VirtualHost getVirtualHost(Session session) {
        ServerConnection conn = this.getServerConnection(session);
        VirtualHost vhost = conn.getVirtualHost();
        return vhost;
    }

    private ServerConnection getServerConnection(Session session) {
        ServerConnection conn = (ServerConnection)session.getConnection();
        return conn;
    }

    @Override
    public void exchangeDelete(Session session, ExchangeDelete method) {
        VirtualHost virtualHost = this.getVirtualHost(session);
        ExchangeRegistry exchangeRegistry = virtualHost.getExchangeRegistry();
        try {
            Exchange exchange = this.getExchange(session, method.getExchange());
            if (exchange == null) {
                this.exception(session, (Method)method, ExecutionErrorCode.NOT_FOUND, "No such exchange '" + method.getExchange() + "'");
            } else if (exchange.hasReferrers()) {
                this.exception(session, (Method)method, ExecutionErrorCode.NOT_ALLOWED, "Exchange in use as an alternate exchange");
            } else if (this.isStandardExchange(exchange, virtualHost.getExchangeFactory().getRegisteredTypes())) {
                this.exception(session, (Method)method, ExecutionErrorCode.NOT_ALLOWED, "Exchange '" + method.getExchange() + "' cannot be deleted");
            } else {
                exchangeRegistry.unregisterExchange(method.getExchange(), method.getIfUnused());
                if (exchange.isDurable() && !exchange.isAutoDelete()) {
                    DurableConfigurationStore store = virtualHost.getDurableConfigurationStore();
                    store.removeExchange(exchange);
                    QpidAndesBridge.deleteExchange(exchange);
                }
            }
        }
        catch (ExchangeInUseException e) {
            this.exception(session, (Method)method, ExecutionErrorCode.PRECONDITION_FAILED, "Exchange in use");
        }
        catch (AMQException e) {
            this.exception(session, (Method)method, e, "Cannot delete exchange '" + method.getExchange());
        }
    }

    private boolean isStandardExchange(Exchange exchange, Collection<ExchangeType<? extends Exchange>> registeredTypes) {
        for (ExchangeType<? extends Exchange> type : registeredTypes) {
            if (!type.getDefaultExchangeName().toString().equals(exchange.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void exchangeQuery(Session session, ExchangeQuery method) {
        ExchangeQueryResult result = new ExchangeQueryResult();
        Exchange exchange = this.getExchange(session, method.getName());
        if (exchange != null) {
            result.setDurable(exchange.isDurable());
            result.setType(exchange.getTypeShortString().toString());
            result.setNotFound(false);
        } else {
            result.setNotFound(true);
        }
        session.executionResult(method.getId(), result, new Option[0]);
    }

    @Override
    public void exchangeBind(Session session, ExchangeBind method) {
        VirtualHost virtualHost = this.getVirtualHost(session);
        ExchangeRegistry exchangeRegistry = virtualHost.getExchangeRegistry();
        QueueRegistry queueRegistry = virtualHost.getQueueRegistry();
        if (!method.hasQueue()) {
            this.exception(session, (Method)method, ExecutionErrorCode.ILLEGAL_ARGUMENT, "queue not set");
        } else if (!method.hasExchange()) {
            this.exception(session, (Method)method, ExecutionErrorCode.ILLEGAL_ARGUMENT, "exchange not set");
        } else {
            if (!method.hasBindingKey()) {
                method.setBindingKey(method.getQueue());
            }
            AMQQueue queue = queueRegistry.getQueue(method.getQueue());
            Exchange exchange = exchangeRegistry.getExchange(method.getExchange());
            if (queue == null) {
                this.exception(session, (Method)method, ExecutionErrorCode.NOT_FOUND, "Queue: '" + method.getQueue() + "' not found");
            } else if (exchange == null) {
                this.exception(session, (Method)method, ExecutionErrorCode.NOT_FOUND, "Exchange: '" + method.getExchange() + "' not found");
            } else if (!(!exchange.getTypeShortString().equals(HeadersExchange.TYPE.getName()) || method.hasArguments() && method.getArguments() != null && method.getArguments().containsKey("x-match"))) {
                this.exception(session, (Method)method, ExecutionErrorCode.INTERNAL_ERROR, "Bindings to an exchange of type " + HeadersExchange.TYPE.getName() + " require an x-match header");
            } else {
                FieldTable fieldTable;
                AMQShortString routingKey = new AMQShortString(method.getBindingKey());
                if (!exchange.isBound(routingKey, fieldTable = FieldTable.convertToFieldTable(method.getArguments()), queue)) {
                    try {
                        virtualHost.getBindingFactory().addBinding(method.getBindingKey(), queue, exchange, method.getArguments());
                    }
                    catch (AMQException e) {
                        this.exception(session, (Method)method, e, "Cannot add binding '" + method.getBindingKey());
                    }
                }
            }
        }
    }

    @Override
    public void exchangeUnbind(Session session, ExchangeUnbind method) {
        VirtualHost virtualHost = this.getVirtualHost(session);
        ExchangeRegistry exchangeRegistry = virtualHost.getExchangeRegistry();
        QueueRegistry queueRegistry = virtualHost.getQueueRegistry();
        if (!method.hasQueue()) {
            this.exception(session, (Method)method, ExecutionErrorCode.ILLEGAL_ARGUMENT, "queue not set");
        } else if (!method.hasExchange()) {
            this.exception(session, (Method)method, ExecutionErrorCode.ILLEGAL_ARGUMENT, "exchange not set");
        } else if (!method.hasBindingKey()) {
            this.exception(session, (Method)method, ExecutionErrorCode.ILLEGAL_ARGUMENT, "binding-key not set");
        } else {
            AMQQueue queue = queueRegistry.getQueue(method.getQueue());
            Exchange exchange = exchangeRegistry.getExchange(method.getExchange());
            if (queue == null) {
                this.exception(session, (Method)method, ExecutionErrorCode.NOT_FOUND, "Queue: '" + method.getQueue() + "' not found");
            } else if (exchange == null) {
                this.exception(session, (Method)method, ExecutionErrorCode.NOT_FOUND, "Exchange: '" + method.getExchange() + "' not found");
            } else {
                try {
                    virtualHost.getBindingFactory().removeBinding(method.getBindingKey(), queue, exchange, null, true);
                }
                catch (AMQException e) {
                    this.exception(session, (Method)method, e, "Cannot remove binding '" + method.getBindingKey());
                }
            }
        }
        super.exchangeUnbind(session, method);
    }

    @Override
    public void exchangeBound(Session session, ExchangeBound method) {
        Exchange exchange;
        ExchangeBoundResult result = new ExchangeBoundResult();
        if (method.hasExchange()) {
            exchange = this.getExchange(session, method.getExchange());
            if (exchange == null) {
                result.setExchangeNotFound(true);
            }
        } else {
            exchange = this.getExchangeRegistry(session).getDefaultExchange();
        }
        if (method.hasQueue()) {
            AMQQueue queue = this.getQueue(session, method.getQueue());
            if (queue == null) {
                result.setQueueNotFound(true);
            }
            if (exchange != null && queue != null) {
                boolean queueMatched = exchange.isBound(queue);
                result.setQueueNotMatched(!queueMatched);
                if (method.hasBindingKey()) {
                    if (method.hasArguments()) {
                        FieldTable args = FieldTable.convertToFieldTable(method.getArguments());
                        result.setArgsNotMatched(!exchange.isBound(new AMQShortString(method.getBindingKey()), args, queue));
                    }
                    if (queueMatched) {
                        result.setKeyNotMatched(!exchange.isBound(method.getBindingKey(), queue));
                    } else {
                        result.setKeyNotMatched(!exchange.isBound(method.getBindingKey()));
                    }
                } else if (method.hasArguments()) {
                    // empty if block
                }
                result.setQueueNotMatched(!exchange.isBound(queue));
            } else if (exchange != null && method.hasBindingKey()) {
                if (method.hasArguments()) {
                    // empty if block
                }
                result.setKeyNotMatched(!exchange.isBound(method.getBindingKey()));
            }
        } else if (exchange != null && method.hasBindingKey()) {
            if (method.hasArguments()) {
                // empty if block
            }
            result.setKeyNotMatched(!exchange.isBound(method.getBindingKey()));
        }
        session.executionResult(method.getId(), result, new Option[0]);
    }

    private AMQQueue getQueue(Session session, String queue) {
        QueueRegistry queueRegistry = this.getQueueRegistry(session);
        return queueRegistry.getQueue(queue);
    }

    private QueueRegistry getQueueRegistry(Session session) {
        return this.getVirtualHost(session).getQueueRegistry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void queueDeclare(Session session, final QueueDeclare method) {
        QueueRegistry queueRegistry;
        VirtualHost virtualHost = this.getVirtualHost(session);
        DurableConfigurationStore store = virtualHost.getDurableConfigurationStore();
        String queueName = method.getQueue();
        QueueRegistry queueRegistry2 = queueRegistry = this.getQueueRegistry(session);
        synchronized (queueRegistry2) {
            AMQQueue queue = queueRegistry.getQueue(queueName);
            if (queue == null) {
                if (method.getPassive()) {
                    String description = "Queue: " + queueName + " not found on VirtualHost(" + virtualHost + ").";
                    ExecutionErrorCode errorCode = ExecutionErrorCode.NOT_FOUND;
                    this.exception(session, (Method)method, errorCode, description);
                    return;
                }
                try {
                    ServerSession s;
                    AMQQueue q;
                    Object no_local;
                    queue = this.createQueue(queueName, method, virtualHost, (ServerSession)session);
                    if (method.getExclusive()) {
                        queue.setExclusive(true);
                    } else if (method.getAutoDelete()) {
                        queue.setDeleteOnNoConsumers(true);
                    }
                    String alternateExchangeName = method.getAlternateExchange();
                    if (alternateExchangeName != null && alternateExchangeName.length() != 0) {
                        Exchange alternate = this.getExchange(session, alternateExchangeName);
                        queue.setAlternateExchange(alternate);
                    }
                    if (method.hasArguments() && method.getArguments() != null && method.getArguments().containsKey("no-local") && (no_local = method.getArguments().get("no-local")) instanceof Boolean && ((Boolean)no_local).booleanValue()) {
                        queue.setNoLocal(true);
                    }
                    if (queue.isDurable() && !queue.isAutoDelete()) {
                        if (method.hasArguments() && method.getArguments() != null) {
                            Map<String, Object> args = method.getArguments();
                            FieldTable ftArgs = new FieldTable();
                            for (Map.Entry<String, Object> entry : args.entrySet()) {
                                ftArgs.put(new AMQShortString(entry.getKey()), entry.getValue());
                            }
                            store.createQueue(queue, ftArgs);
                        } else {
                            store.createQueue(queue);
                        }
                    }
                    queueRegistry.registerQueue(queue);
                    boolean autoRegister = ApplicationRegistry.getInstance().getConfiguration().getQueueAutoRegister();
                    if (autoRegister) {
                        ExchangeRegistry exchangeRegistry = this.getExchangeRegistry(session);
                        Exchange defaultExchange = exchangeRegistry.getDefaultExchange();
                        virtualHost.getBindingFactory().addBinding(queueName, queue, defaultExchange, null);
                    }
                    if (method.hasAutoDelete() && method.getAutoDelete() && method.hasExclusive() && method.getExclusive()) {
                        q = queue;
                        final ServerSession.Task deleteQueueTask = new ServerSession.Task(){

                            @Override
                            public void doTask(ServerSession session) {
                                try {
                                    q.delete();
                                }
                                catch (AMQException e) {
                                    ServerSessionDelegate.this.exception(session, method, e, "Cannot delete '" + method.getQueue());
                                }
                            }
                        };
                        s = (ServerSession)session;
                        s.addSessionCloseTask(deleteQueueTask);
                        queue.addQueueDeleteTask(new AMQQueue.Task(){

                            @Override
                            public void doTask(AMQQueue queue) throws AMQException {
                                s.removeSessionCloseTask(deleteQueueTask);
                            }
                        });
                    }
                    if (method.hasExclusive() && method.getExclusive()) {
                        q = queue;
                        final ServerSession.Task removeExclusive = new ServerSession.Task(){

                            @Override
                            public void doTask(ServerSession session) {
                                q.setAuthorizationHolder(null);
                                q.setExclusiveOwningSession(null);
                            }
                        };
                        s = (ServerSession)session;
                        q.setExclusiveOwningSession(s);
                        s.addSessionCloseTask(removeExclusive);
                        queue.addQueueDeleteTask(new AMQQueue.Task(){

                            @Override
                            public void doTask(AMQQueue queue) throws AMQException {
                                s.removeSessionCloseTask(removeExclusive);
                            }
                        });
                    }
                }
                catch (AMQException e) {
                    this.exception(session, (Method)method, e, "Cannot declare queue '" + queueName);
                }
            } else if (method.getExclusive() && queue.getExclusiveOwningSession() != null && !queue.getExclusiveOwningSession().equals(session)) {
                String description = "Cannot declare queue('" + queueName + "'), as exclusive queue with same name declared on another session";
                ExecutionErrorCode errorCode = ExecutionErrorCode.RESOURCE_LOCKED;
                this.exception(session, (Method)method, errorCode, description);
                return;
            }
        }
    }

    protected AMQQueue createQueue(String queueName, QueueDeclare body, VirtualHost virtualHost, ServerSession session) throws AMQException {
        String owner = body.getExclusive() ? session.getClientID() : null;
        AMQQueue queue = AMQQueueFactory.createAMQQueueImpl(queueName, body.getDurable(), owner, body.getAutoDelete(), body.getExclusive(), virtualHost, body.getArguments());
        return queue;
    }

    @Override
    public void queueDelete(Session session, QueueDelete method) {
        String queueName = method.getQueue();
        if (queueName == null || queueName.length() == 0) {
            this.exception(session, (Method)method, ExecutionErrorCode.INVALID_ARGUMENT, "No queue name supplied");
        } else {
            AMQQueue queue = this.getQueue(session, queueName);
            if (queue == null) {
                this.exception(session, (Method)method, ExecutionErrorCode.NOT_FOUND, "No queue " + queueName + " found");
            } else if (queue.getAuthorizationHolder() != null && queue.getAuthorizationHolder() != session) {
                this.exception(session, (Method)method, ExecutionErrorCode.RESOURCE_LOCKED, "Exclusive Queue: " + queueName + " owned exclusively by another session");
            } else if (method.getIfEmpty() && !queue.isEmpty()) {
                this.exception(session, (Method)method, ExecutionErrorCode.PRECONDITION_FAILED, "Queue " + queueName + " not empty");
            } else if (method.getIfUnused() && !queue.isUnused()) {
                this.exception(session, (Method)method, ExecutionErrorCode.PRECONDITION_FAILED, "Queue " + queueName + " in use");
            } else {
                VirtualHost virtualHost = this.getVirtualHost(session);
                try {
                    try {
                        boolean isQueueDeletable = Andes.getInstance().checkIfQueueDeletable(AMQPUtils.createInboundQueueEvent(queue));
                        if (isQueueDeletable) {
                            queue.delete();
                            if (queue.isDurable() && !queue.isAutoDelete()) {
                                DurableConfigurationStore store = virtualHost.getDurableConfigurationStore();
                                store.removeQueue(queue);
                            }
                        } else {
                            log.warn("Cannot Delete Queue" + queue.getName() + " It Has Registered Subscriptions.", new Object[0]);
                            throw new AMQException("Cannot Delete Queue" + queueName + " It Has Registered Subscriptions.");
                        }
                        QpidAndesBridge.deleteQueue(queue);
                    }
                    catch (AndesException e) {
                        throw new AMQException("Error while checking if queue is deletable", e);
                    }
                }
                catch (AMQException e) {
                    this.exception(session, (Method)method, e, "Cannot delete queue '" + queueName);
                }
            }
        }
    }

    @Override
    public void queuePurge(Session session, QueuePurge method) {
        String queueName = method.getQueue();
        if (queueName == null || queueName.length() == 0) {
            this.exception(session, (Method)method, ExecutionErrorCode.ILLEGAL_ARGUMENT, "No queue name supplied");
        } else {
            AMQQueue queue = this.getQueue(session, queueName);
            if (queue == null) {
                this.exception(session, (Method)method, ExecutionErrorCode.NOT_FOUND, "No queue " + queueName + " found");
            } else {
                try {
                    queue.clearQueue();
                }
                catch (AMQException e) {
                    this.exception(session, (Method)method, e, "Cannot purge queue '" + queueName);
                }
            }
        }
    }

    @Override
    public void queueQuery(Session session, QueueQuery method) {
        QueueQueryResult result = new QueueQueryResult();
        AMQQueue queue = this.getQueue(session, method.getQueue());
        if (queue != null) {
            result.setQueue(queue.getNameShortString().toString());
            result.setDurable(queue.isDurable());
            result.setExclusive(queue.isExclusive());
            result.setAutoDelete(queue.isAutoDelete());
            result.setArguments(queue.getArguments());
            result.setMessageCount(queue.getMessageCount());
            result.setSubscriberCount(queue.getConsumerCount());
        }
        session.executionResult(method.getId(), result, new Option[0]);
    }

    @Override
    public void messageSetFlowMode(Session session, MessageSetFlowMode sfm) {
        String destination = sfm.getDestination();
        Subscription_0_10 sub = ((ServerSession)session).getSubscription(destination);
        if (sub == null) {
            this.exception(session, (Method)sfm, ExecutionErrorCode.NOT_FOUND, "not-found: destination '" + destination + "'");
        } else if (sub.isStopped()) {
            sub.setFlowMode(sfm.getFlowMode());
        }
    }

    @Override
    public void messageStop(Session session, MessageStop stop) {
        String destination = stop.getDestination();
        Subscription_0_10 sub = ((ServerSession)session).getSubscription(destination);
        if (sub == null) {
            this.exception(session, (Method)stop, ExecutionErrorCode.NOT_FOUND, "not-found: destination '" + destination + "'");
        } else {
            sub.stop();
        }
    }

    @Override
    public void messageFlow(Session session, MessageFlow flow) {
        String destination = flow.getDestination();
        Subscription_0_10 sub = ((ServerSession)session).getSubscription(destination);
        if (sub == null) {
            this.exception(session, (Method)flow, ExecutionErrorCode.NOT_FOUND, "not-found: destination '" + destination + "'");
        } else {
            sub.addCredit(flow.getUnit(), flow.getValue());
        }
    }

    @Override
    public void closed(Session session) {
        for (Subscription_0_10 sub : this.getSubscriptions(session)) {
            ((ServerSession)session).unregister(sub);
        }
        ((ServerSession)session).onClose();
    }

    @Override
    public void detached(Session session) {
        this.closed(session);
    }

    public Collection<Subscription_0_10> getSubscriptions(Session session) {
        return ((ServerSession)session).getSubscriptions();
    }
}

