/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.transport;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.wso2.andes.protocol.ProtocolEngine;
import org.wso2.andes.server.registry.ApplicationRegistry;
import org.wso2.andes.server.registry.IApplicationRegistry;
import org.wso2.andes.server.security.SecurityManager;
import org.wso2.andes.server.security.auth.AuthenticationResult;
import org.wso2.andes.server.transport.ServerConnection;
import org.wso2.andes.server.transport.ServerSession;
import org.wso2.andes.server.transport.ServerSessionDelegate;
import org.wso2.andes.server.virtualhost.VirtualHost;
import org.wso2.andes.transport.Binary;
import org.wso2.andes.transport.Connection;
import org.wso2.andes.transport.ConnectionClose;
import org.wso2.andes.transport.ConnectionCloseCode;
import org.wso2.andes.transport.ConnectionOpen;
import org.wso2.andes.transport.ConnectionOpenOk;
import org.wso2.andes.transport.Option;
import org.wso2.andes.transport.ServerDelegate;
import org.wso2.andes.transport.SessionAttach;

public class ServerConnectionDelegate
extends ServerDelegate {
    private String _localFQDN;
    private final IApplicationRegistry _appRegistry;

    public ServerConnectionDelegate(IApplicationRegistry appRegistry, String localFQDN) {
        this(new HashMap<String, Object>(Collections.singletonMap("qpid.federation_tag", appRegistry.getBroker().getFederationTag())), Collections.singletonList("en_US"), appRegistry, localFQDN);
    }

    public ServerConnectionDelegate(Map<String, Object> properties, List<Object> locales, IApplicationRegistry appRegistry, String localFQDN) {
        super(properties, ServerConnectionDelegate.parseToList(appRegistry.getAuthenticationManager().getMechanisms()), locales);
        this._appRegistry = appRegistry;
        this._localFQDN = localFQDN;
    }

    private static List<Object> parseToList(String mechanisms) {
        ArrayList<Object> list = new ArrayList<Object>();
        StringTokenizer tokenizer = new StringTokenizer(mechanisms, " ");
        while (tokenizer.hasMoreTokens()) {
            list.add(tokenizer.nextToken());
        }
        return list;
    }

    @Override
    public ServerSession getSession(Connection conn, SessionAttach atc) {
        ServerSessionDelegate serverSessionDelegate = new ServerSessionDelegate(this._appRegistry);
        ServerSession ssn = new ServerSession(conn, serverSessionDelegate, new Binary(atc.getName()), 0L);
        return ssn;
    }

    @Override
    protected SaslServer createSaslServer(String mechanism) throws SaslException {
        return this._appRegistry.getAuthenticationManager().createSaslServer(mechanism, this._localFQDN);
    }

    @Override
    protected void secure(SaslServer ss, Connection conn, byte[] response) {
        AuthenticationResult authResult = this._appRegistry.getAuthenticationManager().authenticate(ss, response);
        ServerConnection sconn = (ServerConnection)conn;
        if (AuthenticationResult.AuthenticationStatus.SUCCESS.equals((Object)authResult.getStatus())) {
            this.tuneAuthorizedConnection(sconn);
            sconn.setAuthorizedSubject(authResult.getSubject());
        } else if (AuthenticationResult.AuthenticationStatus.CONTINUE.equals((Object)authResult.getStatus())) {
            this.connectionAuthContinue(sconn, authResult.getChallenge());
        } else {
            this.connectionAuthFailed(sconn, authResult.getCause());
        }
    }

    @Override
    public void connectionClose(Connection conn, ConnectionClose close) {
        try {
            ((ServerConnection)conn).logClosed();
        }
        finally {
            super.connectionClose(conn, close);
        }
    }

    @Override
    public void connectionOpen(Connection conn, ConnectionOpen open) {
        ServerConnection sconn = (ServerConnection)conn;
        String vhostName = open.hasVirtualHost() ? open.getVirtualHost() : "";
        VirtualHost vhost = this._appRegistry.getVirtualHostRegistry().getVirtualHost(vhostName);
        SecurityManager.setThreadSubject(sconn.getAuthorizedSubject());
        if (vhost != null) {
            sconn.setVirtualHost(vhost);
            if (!vhost.getSecurityManager().accessVirtualhost(vhostName, ((ProtocolEngine)((Object)sconn.getConfig())).getRemoteAddress())) {
                sconn.invoke(new ConnectionClose(ConnectionCloseCode.CONNECTION_FORCED, "Permission denied '" + vhostName + "'", new Option[0]));
                sconn.setState(Connection.State.CLOSING);
            } else {
                sconn.invoke(new ConnectionOpenOk(Collections.emptyList(), new Option[0]));
                sconn.setState(Connection.State.OPEN);
            }
        } else {
            sconn.invoke(new ConnectionClose(ConnectionCloseCode.INVALID_PATH, "Unknown virtualhost '" + vhostName + "'", new Option[0]));
            sconn.setState(Connection.State.CLOSING);
        }
    }

    @Override
    protected int getHeartbeatMax() {
        return 0;
    }

    @Override
    protected int getChannelMax() {
        return ApplicationRegistry.getInstance().getConfiguration().getMaxChannelCount();
    }
}

