/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.subscription;

import org.wso2.andes.AMQException;
import org.wso2.andes.common.AMQPFilterTypes;
import org.wso2.andes.framing.AMQShortString;
import org.wso2.andes.framing.FieldTable;
import org.wso2.andes.protocol.AMQConstant;
import org.wso2.andes.server.AMQChannel;
import org.wso2.andes.server.flow.FlowCreditManager;
import org.wso2.andes.server.protocol.AMQProtocolSession;
import org.wso2.andes.server.subscription.ClientDeliveryMethod;
import org.wso2.andes.server.subscription.RecordDeliveryMethod;
import org.wso2.andes.server.subscription.Subscription;
import org.wso2.andes.server.subscription.SubscriptionFactory;
import org.wso2.andes.server.subscription.SubscriptionImpl;

public class SubscriptionFactoryImpl
implements SubscriptionFactory {
    public static final SubscriptionFactoryImpl INSTANCE = new SubscriptionFactoryImpl();

    @Override
    public Subscription createSubscription(int channelId, AMQProtocolSession protocolSession, AMQShortString consumerTag, boolean acks, FieldTable filters, boolean noLocal, FlowCreditManager creditManager) throws AMQException {
        AMQChannel channel = protocolSession.getChannel(channelId);
        if (channel == null) {
            throw new AMQException(AMQConstant.NOT_FOUND, "channel :" + channelId + " not found in protocol session");
        }
        ClientDeliveryMethod clientMethod = channel.getClientDeliveryMethod();
        RecordDeliveryMethod recordMethod = channel.getRecordDeliveryMethod();
        return this.createSubscription(channel, protocolSession, consumerTag, acks, filters, noLocal, creditManager, clientMethod, recordMethod);
    }

    @Override
    public Subscription createSubscription(AMQChannel channel, AMQProtocolSession protocolSession, AMQShortString consumerTag, boolean acks, FieldTable filters, boolean noLocal, FlowCreditManager creditManager, ClientDeliveryMethod clientMethod, RecordDeliveryMethod recordMethod) throws AMQException {
        Boolean isBrowserObj;
        boolean isBrowser = filters != null ? (isBrowserObj = (Boolean)filters.get(AMQPFilterTypes.NO_CONSUME.getValue())) != null && isBrowserObj != false : false;
        if (isBrowser) {
            return new SubscriptionImpl.BrowserSubscription(channel, protocolSession, consumerTag, filters, noLocal, creditManager, clientMethod, recordMethod);
        }
        if (acks) {
            return new SubscriptionImpl.AckSubscription(channel, protocolSession, consumerTag, filters, noLocal, creditManager, clientMethod, recordMethod);
        }
        return new SubscriptionImpl.NoAckSubscription(channel, protocolSession, consumerTag, filters, noLocal, creditManager, clientMethod, recordMethod);
    }
}

