/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.subscription;

import org.apache.log4j.Logger;
import org.wso2.andes.server.queue.QueueEntry;
import org.wso2.andes.server.subscription.Subscription_0_10;
import org.wso2.andes.server.transport.ServerSession;

class ExplicitAcceptDispositionChangeListener
implements ServerSession.MessageDispositionChangeListener {
    private static final Logger _logger = Logger.getLogger(ExplicitAcceptDispositionChangeListener.class);
    private final QueueEntry _entry;
    private final Subscription_0_10 _sub;

    public ExplicitAcceptDispositionChangeListener(QueueEntry entry, Subscription_0_10 subscription_0_10) {
        this._entry = entry;
        this._sub = subscription_0_10;
    }

    @Override
    public void onAccept() {
        Subscription_0_10 subscription = this.getSubscription();
        if (subscription != null && this._entry.isAcquiredBy(this._sub)) {
            subscription.getSession().acknowledge(subscription, this._entry);
        } else {
            _logger.warn((Object)"MessageAccept received for message which has not been acquired (likely client error)");
        }
    }

    @Override
    public void onRelease() {
        Subscription_0_10 subscription = this.getSubscription();
        if (subscription != null && this._entry.isAcquiredBy(this._sub)) {
            subscription.release(this._entry);
        } else {
            _logger.warn((Object)"MessageRelease received for message which has not been acquired (likely client error)");
        }
    }

    @Override
    public void onReject() {
        Subscription_0_10 subscription = this.getSubscription();
        if (subscription != null && this._entry.isAcquiredBy(this._sub)) {
            subscription.reject(this._entry);
        } else {
            _logger.warn((Object)"MessageReject received for message which has not been acquired (likely client error)");
        }
    }

    @Override
    public boolean acquire() {
        return this._entry.acquire(this.getSubscription());
    }

    private Subscription_0_10 getSubscription() {
        return this._sub;
    }
}

