/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.store;

import java.nio.ByteBuffer;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.slot.Slot;
import org.wso2.andes.server.store.MessageStore;
import org.wso2.andes.server.store.StorableMessageMetaData;
import org.wso2.andes.server.store.StoredMessage;
import org.wso2.andes.server.store.TransactionLog;

public class StoredMemoryMessage
implements StoredMessage {
    private final long _messageNumber;
    private final ByteBuffer _content;
    private final StorableMessageMetaData _metaData;

    public StoredMemoryMessage(long messageNumber, StorableMessageMetaData metaData) {
        this._messageNumber = messageNumber;
        this._metaData = metaData;
        this._content = ByteBuffer.allocate(metaData.getContentSize());
    }

    @Override
    public long getMessageNumber() {
        return this._messageNumber;
    }

    @Override
    public void addContent(int offsetInMessage, ByteBuffer src) {
        src = src.duplicate();
        ByteBuffer dst = this._content.duplicate();
        dst.position(offsetInMessage);
        dst.put(src);
    }

    @Override
    public void duplicateMessageContent(long messageId, long messageIdOfClone) throws AndesException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getContent(int offset, ByteBuffer dst) {
        ByteBuffer src = this._content.duplicate();
        src.position(offset);
        src = src.slice();
        if (dst.remaining() < src.limit()) {
            src.limit(dst.remaining());
        }
        dst.put(src);
        return src.limit();
    }

    @Override
    public TransactionLog.StoreFuture flushToStore() {
        return MessageStore.IMMEDIATE_FUTURE;
    }

    public StorableMessageMetaData getMetaData() {
        return this._metaData;
    }

    @Override
    public void remove() {
    }

    @Override
    public void setExchange(String exchange) {
    }

    @Override
    public Slot getSlot() {
        return null;
    }

    @Override
    public void setSlot(Slot slot) {
    }
}

