/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.store;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.configuration.Configuration;
import org.apache.log4j.Logger;
import org.wso2.andes.AMQException;
import org.wso2.andes.AMQStoreException;
import org.wso2.andes.framing.AMQShortString;
import org.wso2.andes.framing.FieldTable;
import org.wso2.andes.server.exchange.Exchange;
import org.wso2.andes.server.logging.LogSubject;
import org.wso2.andes.server.logging.actors.CurrentActor;
import org.wso2.andes.server.logging.messages.ConfigStoreMessages;
import org.wso2.andes.server.logging.messages.MessageStoreMessages;
import org.wso2.andes.server.queue.AMQQueue;
import org.wso2.andes.server.store.ConfigurationRecoveryHandler;
import org.wso2.andes.server.store.MessageStore;
import org.wso2.andes.server.store.MessageStoreClosedException;
import org.wso2.andes.server.store.MessageStoreRecoveryHandler;
import org.wso2.andes.server.store.StorableMessageMetaData;
import org.wso2.andes.server.store.StoredMemoryMessage;
import org.wso2.andes.server.store.StoredMessage;
import org.wso2.andes.server.store.TransactionLog;
import org.wso2.andes.server.store.TransactionLogRecoveryHandler;
import org.wso2.andes.server.store.TransactionLogResource;

public class MemoryMessageStore
implements MessageStore {
    private static final Logger _log = Logger.getLogger(MemoryMessageStore.class);
    private static final int DEFAULT_HASHTABLE_CAPACITY = 50000;
    private static final String HASHTABLE_CAPACITY_CONFIG = "hashtable-capacity";
    private final AtomicLong _messageId = new AtomicLong(1L);
    private AtomicBoolean _closed = new AtomicBoolean(false);
    private LogSubject _logSubject;
    private static final TransactionLog.Transaction IN_MEMORY_TRANSACTION = new TransactionLog.Transaction(){

        @Override
        public void enqueueMessage(TransactionLogResource queue, Long messageId) throws AMQStoreException {
        }

        @Override
        public void dequeueMessage(TransactionLogResource queue, Long messageId) throws AMQStoreException {
        }

        @Override
        public void commitTran() throws AMQStoreException {
        }

        @Override
        public TransactionLog.StoreFuture commitTranAsync() throws AMQStoreException {
            return MessageStore.IMMEDIATE_FUTURE;
        }

        @Override
        public void abortTran() throws AMQStoreException {
        }
    };

    @Override
    public void configureConfigStore(String name, ConfigurationRecoveryHandler handler, Configuration configuration, LogSubject logSubject) throws Exception {
        this._logSubject = logSubject;
        CurrentActor.get().message(this._logSubject, ConfigStoreMessages.CREATED(this.getClass().getName()));
    }

    @Override
    public void configureMessageStore(String name, MessageStoreRecoveryHandler recoveryHandler, Configuration config, LogSubject logSubject) throws Exception {
        if (this._logSubject == null) {
            this._logSubject = logSubject;
        }
        int hashtableCapacity = config.getInt(name + "." + HASHTABLE_CAPACITY_CONFIG, 50000);
        _log.info((Object)("Using capacity " + hashtableCapacity + " for hash tables"));
        CurrentActor.get().message(this._logSubject, MessageStoreMessages.CREATED(this.getClass().getName()));
    }

    @Override
    public void close() throws Exception {
        this._closed.getAndSet(true);
        CurrentActor.get().message(this._logSubject, MessageStoreMessages.CLOSED());
    }

    public StoredMessage addMessage(StorableMessageMetaData metaData) {
        long id = this._messageId.getAndIncrement();
        StoredMemoryMessage message = new StoredMemoryMessage(id, metaData);
        return message;
    }

    @Override
    public void createExchange(Exchange exchange) throws AMQStoreException {
    }

    @Override
    public void removeExchange(Exchange exchange) throws AMQStoreException {
    }

    @Override
    public void bindQueue(Exchange exchange, AMQShortString routingKey, AMQQueue queue, FieldTable args) throws AMQStoreException {
    }

    @Override
    public void unbindQueue(Exchange exchange, AMQShortString routingKey, AMQQueue queue, FieldTable args) throws AMQStoreException {
    }

    @Override
    public void createQueue(AMQQueue queue) throws AMQStoreException {
    }

    @Override
    public void createQueue(AMQQueue queue, FieldTable arguments) throws AMQStoreException {
    }

    @Override
    public void removeQueue(AMQQueue queue) throws AMQStoreException {
    }

    @Override
    public void updateQueue(AMQQueue queue) throws AMQStoreException {
    }

    @Override
    public void configureTransactionLog(String name, TransactionLogRecoveryHandler recoveryHandler, Configuration storeConfiguration, LogSubject logSubject) throws Exception {
    }

    @Override
    public TransactionLog.Transaction newTransaction() {
        return IN_MEMORY_TRANSACTION;
    }

    public List<AMQQueue> createQueues() throws AMQException {
        return null;
    }

    public Long getNewMessageId() {
        return this._messageId.getAndIncrement();
    }

    @Override
    public boolean isPersistent() {
        return false;
    }

    private void checkNotClosed() throws MessageStoreClosedException {
        if (this._closed.get()) {
            throw new MessageStoreClosedException();
        }
    }
}

