/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.state;

import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.log4j.Logger;
import org.wso2.andes.AMQException;
import org.wso2.andes.framing.AMQMethodBody;
import org.wso2.andes.framing.ChannelCloseBody;
import org.wso2.andes.framing.ChannelCloseOkBody;
import org.wso2.andes.framing.ChannelOpenBody;
import org.wso2.andes.framing.MethodDispatcher;
import org.wso2.andes.protocol.AMQConstant;
import org.wso2.andes.protocol.AMQMethodEvent;
import org.wso2.andes.protocol.AMQMethodListener;
import org.wso2.andes.server.protocol.AMQProtocolSession;
import org.wso2.andes.server.security.SecurityManager;
import org.wso2.andes.server.state.AMQState;
import org.wso2.andes.server.state.StateListener;
import org.wso2.andes.server.virtualhost.VirtualHostRegistry;

public class AMQStateManager
implements AMQMethodListener {
    private static final Logger _logger = Logger.getLogger(AMQStateManager.class);
    private final VirtualHostRegistry _virtualHostRegistry;
    private final AMQProtocolSession _protocolSession;
    private AMQState _currentState;
    private CopyOnWriteArraySet<StateListener> _stateListeners = new CopyOnWriteArraySet();

    public AMQStateManager(VirtualHostRegistry virtualHostRegistry, AMQProtocolSession protocolSession) {
        this._virtualHostRegistry = virtualHostRegistry;
        this._protocolSession = protocolSession;
        this._currentState = AMQState.CONNECTION_NOT_STARTED;
    }

    public AMQState getCurrentState() {
        return this._currentState;
    }

    public void changeState(AMQState newState) throws AMQException {
        _logger.debug((Object)("State changing to " + (Object)((Object)newState) + " from old state " + (Object)((Object)this._currentState)));
        AMQState oldState = this._currentState;
        this._currentState = newState;
        for (StateListener l : this._stateListeners) {
            l.stateChanged(oldState, newState);
        }
    }

    @Override
    public void error(Exception e) {
        _logger.error((Object)("State manager received error notification[Current State:" + (Object)((Object)this._currentState) + "]: " + e), (Throwable)e);
        for (StateListener l : this._stateListeners) {
            l.error(e);
        }
    }

    @Override
    public <B extends AMQMethodBody> boolean methodReceived(AMQMethodEvent<B> evt) throws AMQException {
        MethodDispatcher dispatcher = this._protocolSession.getMethodDispatcher();
        int channelId = evt.getChannelId();
        B body = evt.getMethod();
        if (!(channelId == 0 || this._protocolSession.getChannel(channelId) != null || body instanceof ChannelOpenBody || body instanceof ChannelCloseOkBody || body instanceof ChannelCloseBody)) {
            throw body.getConnectionException(AMQConstant.CHANNEL_ERROR, "channel is closed won't process:" + body);
        }
        return body.execute(dispatcher, channelId);
    }

    private <B extends AMQMethodBody> void checkChannel(AMQMethodEvent<B> evt, AMQProtocolSession protocolSession) throws AMQException {
        if (evt.getChannelId() != 0 && !(evt.getMethod() instanceof ChannelOpenBody) && protocolSession.getChannel(evt.getChannelId()) == null && !protocolSession.channelAwaitingClosure(evt.getChannelId())) {
            throw evt.getMethod().getChannelNotFoundException(evt.getChannelId());
        }
    }

    public void addStateListener(StateListener listener) {
        _logger.debug((Object)"Adding state listener");
        this._stateListeners.add(listener);
    }

    public void removeStateListener(StateListener listener) {
        this._stateListeners.remove(listener);
    }

    public VirtualHostRegistry getVirtualHostRegistry() {
        return this._virtualHostRegistry;
    }

    public AMQProtocolSession getProtocolSession() {
        SecurityManager.setThreadSubject(this._protocolSession.getAuthorizedSubject());
        return this._protocolSession;
    }
}

