/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.security.auth.sasl.plain;

import java.util.Arrays;
import javax.security.auth.callback.PasswordCallback;

public class PlainPasswordCallback
extends PasswordCallback {
    private char[] _plainPassword;
    private boolean _authenticated = false;

    public PlainPasswordCallback(String prompt, boolean echoOn, String plainPassword) {
        super(prompt, echoOn);
        if (plainPassword == null) {
            throw new NullPointerException("Incoming plain text cannot be null");
        }
        this._plainPassword = plainPassword.toCharArray();
    }

    public String getPlainPassword() {
        return new String(this._plainPassword);
    }

    public void setAuthenticated(boolean authenticated) {
        this._authenticated = authenticated;
    }

    public boolean isAuthenticated() {
        char[] storedPassword = this.getPassword();
        return Arrays.equals(this._plainPassword, storedPassword) || this._authenticated;
    }
}

