/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.security.auth.manager;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Security;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.AccountNotFoundException;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.log4j.Logger;
import org.wso2.andes.configuration.PropertyException;
import org.wso2.andes.configuration.PropertyUtils;
import org.wso2.andes.configuration.qpid.plugins.ConfigurationPlugin;
import org.wso2.andes.configuration.qpid.plugins.ConfigurationPluginFactory;
import org.wso2.andes.server.security.auth.AuthenticationResult;
import org.wso2.andes.server.security.auth.database.PrincipalDatabase;
import org.wso2.andes.server.security.auth.management.AMQUserManagementMBean;
import org.wso2.andes.server.security.auth.manager.AuthenticationManager;
import org.wso2.andes.server.security.auth.manager.AuthenticationManagerPluginFactory;
import org.wso2.andes.server.security.auth.sasl.AuthenticationProviderInitialiser;
import org.wso2.andes.server.security.auth.sasl.JCAProvider;
import org.wso2.andes.server.security.auth.sasl.UsernamePrincipal;

public class PrincipalDatabaseAuthenticationManager
implements AuthenticationManager {
    private static final Logger _logger = Logger.getLogger(PrincipalDatabaseAuthenticationManager.class);
    private String _mechanisms;
    private final Map<String, CallbackHandler> _callbackHandlerMap = new HashMap<String, CallbackHandler>();
    private final Map<String, Map<String, ?>> _serverCreationProperties = new HashMap();
    protected PrincipalDatabase _principalDatabase = null;
    protected AMQUserManagementMBean _mbean = null;
    public static final AuthenticationManagerPluginFactory<PrincipalDatabaseAuthenticationManager> FACTORY = new AuthenticationManagerPluginFactory<PrincipalDatabaseAuthenticationManager>(){

        @Override
        public PrincipalDatabaseAuthenticationManager newInstance(ConfigurationPlugin config) throws ConfigurationException {
            PrincipalDatabaseAuthenticationManagerConfiguration configuration = (PrincipalDatabaseAuthenticationManagerConfiguration)config.getConfiguration(PrincipalDatabaseAuthenticationManagerConfiguration.class.getName());
            if (configuration == null) {
                _logger.info((Object)"No authentication-manager configuration found for PrincipalDatabaseAuthenticationManager");
                return null;
            }
            PrincipalDatabaseAuthenticationManager pdam = new PrincipalDatabaseAuthenticationManager();
            pdam.configure(configuration);
            pdam.initialise();
            return pdam;
        }

        @Override
        public Class<PrincipalDatabaseAuthenticationManager> getPluginClass() {
            return PrincipalDatabaseAuthenticationManager.class;
        }

        @Override
        public String getPluginName() {
            return PrincipalDatabaseAuthenticationManager.class.getName();
        }
    };

    protected PrincipalDatabaseAuthenticationManager() {
    }

    @Override
    public void initialise() {
        TreeMap<String, Class<? extends SaslServerFactory>> providerMap = new TreeMap<String, Class<? extends SaslServerFactory>>();
        this.initialiseAuthenticationMechanisms(providerMap, this._principalDatabase);
        if (providerMap.size() > 0) {
            if (Security.insertProviderAt(new JCAProvider("AMQSASLProvider-Server", providerMap), 1) == -1) {
                _logger.error((Object)"Unable to load custom SASL providers. Qpid custom SASL authenticators unavailable.");
            } else {
                _logger.info((Object)"Additional SASL providers successfully registered.");
            }
        } else {
            _logger.warn((Object)"No additional SASL providers registered.");
        }
        this.registerManagement();
    }

    private void initialiseAuthenticationMechanisms(Map<String, Class<? extends SaslServerFactory>> providerMap, PrincipalDatabase database) {
        if (database == null || database.getMechanisms().size() == 0) {
            _logger.warn((Object)"No Database or no mechanisms to initialise authentication");
            return;
        }
        for (Map.Entry<String, AuthenticationProviderInitialiser> mechanism : database.getMechanisms().entrySet()) {
            this.initialiseAuthenticationMechanism(mechanism.getKey(), mechanism.getValue(), providerMap);
        }
    }

    private void initialiseAuthenticationMechanism(String mechanism, AuthenticationProviderInitialiser initialiser, Map<String, Class<? extends SaslServerFactory>> providerMap) {
        this._mechanisms = this._mechanisms == null ? mechanism : this._mechanisms + " " + mechanism;
        this._callbackHandlerMap.put(mechanism, initialiser.getCallbackHandler());
        this._serverCreationProperties.put(mechanism, initialiser.getProperties());
        Class<? extends SaslServerFactory> factory = initialiser.getServerFactoryClassForJCARegistration();
        if (factory != null) {
            providerMap.put(mechanism, factory);
        }
        _logger.info((Object)("Initialised " + mechanism + " SASL provider successfully"));
    }

    @Override
    public void configure(ConfigurationPlugin config) throws ConfigurationException {
        PrincipalDatabaseAuthenticationManagerConfiguration pdamConfig = (PrincipalDatabaseAuthenticationManagerConfiguration)config;
        String pdClazz = pdamConfig.getPrincipalDatabaseClass();
        _logger.info((Object)("PrincipalDatabase concrete implementation : " + pdClazz));
        this._principalDatabase = this.createPrincipalDatabaseImpl(pdClazz);
        this.configPrincipalDatabase(this._principalDatabase, pdamConfig);
    }

    @Override
    public String getMechanisms() {
        return this._mechanisms;
    }

    @Override
    public SaslServer createSaslServer(String mechanism, String localFQDN) throws SaslException {
        return Sasl.createSaslServer(mechanism, "AMQP", localFQDN, this._serverCreationProperties.get(mechanism), this._callbackHandlerMap.get(mechanism));
    }

    @Override
    public AuthenticationResult authenticate(SaslServer server, byte[] response) {
        try {
            byte[] challenge = server.evaluateResponse(response != null ? response : new byte[]{});
            if (server.isComplete()) {
                Subject subject = new Subject();
                subject.getPrincipals().add(new UsernamePrincipal(server.getAuthorizationID()));
                return new AuthenticationResult(subject);
            }
            return new AuthenticationResult(challenge, AuthenticationResult.AuthenticationStatus.CONTINUE);
        }
        catch (SaslException e) {
            return new AuthenticationResult(AuthenticationResult.AuthenticationStatus.ERROR, e);
        }
    }

    @Override
    public AuthenticationResult authenticate(String username, String password) {
        try {
            if (this._principalDatabase.verifyPassword(username, password.toCharArray())) {
                Subject subject = new Subject();
                subject.getPrincipals().add(new UsernamePrincipal(username));
                return new AuthenticationResult(subject);
            }
            return new AuthenticationResult(AuthenticationResult.AuthenticationStatus.CONTINUE);
        }
        catch (AccountNotFoundException e) {
            return new AuthenticationResult(AuthenticationResult.AuthenticationStatus.CONTINUE);
        }
    }

    @Override
    public void close() {
        this._mechanisms = null;
        Security.removeProvider("AMQSASLProvider-Server");
        this.unregisterManagement();
    }

    private PrincipalDatabase createPrincipalDatabaseImpl(String pdClazz) throws ConfigurationException {
        try {
            return (PrincipalDatabase)Class.forName(pdClazz).newInstance();
        }
        catch (InstantiationException ie) {
            throw new ConfigurationException("Cannot instantiate " + pdClazz, ie);
        }
        catch (IllegalAccessException iae) {
            throw new ConfigurationException("Cannot access " + pdClazz, iae);
        }
        catch (ClassNotFoundException cnfe) {
            throw new ConfigurationException("Cannot load " + pdClazz + " implementation", cnfe);
        }
        catch (ClassCastException cce) {
            throw new ConfigurationException("Expecting a " + PrincipalDatabase.class + " implementation", cce);
        }
    }

    private void configPrincipalDatabase(PrincipalDatabase principalDatabase, PrincipalDatabaseAuthenticationManagerConfiguration config) throws ConfigurationException {
        Map<String, String> attributes = config.getPdClassAttributeMap();
        for (Map.Entry<String, String> nameValuePair : attributes.entrySet()) {
            Method method;
            String methodName = this.generateSetterName(nameValuePair.getKey());
            try {
                method = principalDatabase.getClass().getMethod(methodName, String.class);
            }
            catch (Exception e) {
                throw new ConfigurationException("No method " + methodName + " found in class " + principalDatabase.getClass() + " hence unable to configure principal database. The method must be public and have a single String argument with a void return type", e);
            }
            try {
                method.invoke((Object)principalDatabase, PropertyUtils.replaceProperties(nameValuePair.getValue()));
            }
            catch (IllegalArgumentException e) {
                throw new ConfigurationException(e.getMessage(), e);
            }
            catch (PropertyException e) {
                throw new ConfigurationException(e.getMessage(), e);
            }
            catch (IllegalAccessException e) {
                throw new ConfigurationException(e.getMessage(), e);
            }
            catch (InvocationTargetException e) {
                throw new ConfigurationException(e.getCause().getMessage(), e.getCause());
            }
        }
    }

    private String generateSetterName(String argName) throws ConfigurationException {
        if (argName == null || argName.length() == 0) {
            throw new ConfigurationException("Argument names must have length >= 1 character");
        }
        if (Character.isLowerCase(argName.charAt(0))) {
            argName = Character.toUpperCase(argName.charAt(0)) + argName.substring(1);
        }
        String methodName = "set" + argName;
        return methodName;
    }

    protected void setPrincipalDatabase(PrincipalDatabase principalDatabase) {
        this._principalDatabase = principalDatabase;
    }

    protected void registerManagement() {
        try {
            _logger.info((Object)"Registering UserManagementMBean");
            this._mbean = new AMQUserManagementMBean();
            this._mbean.setPrincipalDatabase(this._principalDatabase);
            this._mbean.register();
        }
        catch (Exception e) {
            _logger.warn((Object)"User management disabled as unable to create MBean:", (Throwable)e);
            this._mbean = null;
        }
    }

    protected void unregisterManagement() {
        try {
            if (this._mbean != null) {
                _logger.info((Object)"Unregistering UserManagementMBean");
                this._mbean.unregister();
            }
        }
        catch (Exception e) {
            _logger.warn((Object)"Failed to unregister User management MBean:", (Throwable)e);
        }
        finally {
            this._mbean = null;
        }
    }

    public static class PrincipalDatabaseAuthenticationManagerConfiguration
    extends ConfigurationPlugin {
        public static final ConfigurationPluginFactory FACTORY = new ConfigurationPluginFactory(){

            @Override
            public List<String> getParentPaths() {
                return Arrays.asList("security.pd-auth-manager");
            }

            @Override
            public ConfigurationPlugin newInstance(String path, Configuration config) throws ConfigurationException {
                PrincipalDatabaseAuthenticationManagerConfiguration instance = new PrincipalDatabaseAuthenticationManagerConfiguration();
                instance.setConfiguration(path, config);
                return instance;
            }
        };

        @Override
        public String[] getElementsProcessed() {
            return new String[]{"principal-database.class", "principal-database.attributes.attribute.name", "principal-database.attributes.attribute.value"};
        }

        @Override
        public void validateConfiguration() throws ConfigurationException {
        }

        public String getPrincipalDatabaseClass() {
            return this._configuration.getString("principal-database.class");
        }

        public Map<String, String> getPdClassAttributeMap() throws ConfigurationException {
            String[] argumentNames = this._configuration.getStringArray("principal-database.attributes.attribute.name");
            String[] argumentValues = this._configuration.getStringArray("principal-database.attributes.attribute.value");
            HashMap<String, String> attributes = new HashMap<String, String>(argumentNames.length);
            for (int i = 0; i < argumentNames.length; ++i) {
                String argName = argumentNames[i];
                String argValue = argumentValues[i];
                attributes.put(argName, argValue);
            }
            return Collections.unmodifiableMap(attributes);
        }
    }
}

