/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.security.auth.database;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.security.Principal;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.AccountNotFoundException;
import org.apache.log4j.Logger;
import org.wso2.andes.server.security.auth.database.HashedUser;
import org.wso2.andes.server.security.auth.database.PrincipalDatabase;
import org.wso2.andes.server.security.auth.management.AMQUserManagementMBean;
import org.wso2.andes.server.security.auth.sasl.AuthenticationProviderInitialiser;
import org.wso2.andes.server.security.auth.sasl.UsernamePrincipal;
import org.wso2.andes.server.security.auth.sasl.crammd5.CRAMMD5HashedInitialiser;
import org.wso2.andes.server.security.auth.sasl.crammd5.CRAMMD5HexInitialiser;

public class Base64MD5PasswordFilePrincipalDatabase
implements PrincipalDatabase {
    private static final Logger _logger = Logger.getLogger(Base64MD5PasswordFilePrincipalDatabase.class);
    private File _passwordFile;
    private Pattern _regexp = Pattern.compile(":");
    private Map<String, AuthenticationProviderInitialiser> _saslServers;
    AMQUserManagementMBean _mbean;
    public static final String DEFAULT_ENCODING = "utf-8";
    private Map<String, HashedUser> _users = new HashMap<String, HashedUser>();
    private ReentrantLock _userUpdate = new ReentrantLock();

    public Base64MD5PasswordFilePrincipalDatabase() {
        this._saslServers = new HashMap<String, AuthenticationProviderInitialiser>();
        CRAMMD5HashedInitialiser cram = new CRAMMD5HashedInitialiser();
        cram.initialise(this);
        this._saslServers.put(cram.getMechanismName(), cram);
        CRAMMD5HexInitialiser cramHex = new CRAMMD5HexInitialiser();
        cramHex.initialise(this);
        this._saslServers.put(cramHex.getMechanismName(), cramHex);
    }

    public void setPasswordFile(String passwordFile) throws IOException {
        File f = new File(passwordFile);
        _logger.info((Object)("PasswordFilePrincipalDatabase using file " + f.getAbsolutePath()));
        this._passwordFile = f;
        if (!f.exists()) {
            throw new FileNotFoundException("Cannot find password file " + f);
        }
        if (!f.canRead()) {
            throw new FileNotFoundException("Cannot read password file " + f + ". Check permissions.");
        }
        this.loadPasswordFile();
    }

    @Override
    public void setPassword(Principal principal, PasswordCallback callback) throws AccountNotFoundException {
        if (this._passwordFile == null) {
            throw new AccountNotFoundException("Unable to locate principal since no password file was specified during initialisation");
        }
        if (principal == null) {
            throw new IllegalArgumentException("principal must not be null");
        }
        char[] pwd = this.lookupPassword(principal.getName());
        if (pwd == null) {
            throw new AccountNotFoundException("No account found for principal " + principal);
        }
        callback.setPassword(pwd);
    }

    @Override
    public boolean verifyPassword(String principal, char[] password) throws AccountNotFoundException {
        byte[] MD5byteArray;
        char[] pwd = this.lookupPassword(principal);
        if (pwd == null) {
            throw new AccountNotFoundException("Unable to lookup the specfied users password");
        }
        byte[] byteArray = new byte[password.length];
        int index = 0;
        for (char c : password) {
            byteArray[index++] = (byte)c;
        }
        try {
            MD5byteArray = HashedUser.getMD5(byteArray);
        }
        catch (Exception e1) {
            _logger.warn((Object)("Unable to hash password for user '" + principal + "' for comparison"));
            return false;
        }
        char[] hashedPassword = new char[MD5byteArray.length];
        index = 0;
        for (byte c : MD5byteArray) {
            hashedPassword[index++] = (char)c;
        }
        return this.compareCharArray(pwd, hashedPassword);
    }

    private boolean compareCharArray(char[] a, char[] b) {
        boolean equal = false;
        if (a.length == b.length) {
            equal = true;
            for (int index = 0; equal && index < a.length; ++index) {
                equal = a[index] == b[index];
            }
        }
        return equal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean updatePassword(Principal principal, char[] password) throws AccountNotFoundException {
        HashedUser user = this._users.get(principal.getName());
        if (user == null) {
            throw new AccountNotFoundException(principal.getName());
        }
        try {
            try {
                this._userUpdate.lock();
                char[] orig = user.getPassword();
                user.setPassword(password, false);
                try {
                    this.savePasswordFile();
                }
                catch (IOException e) {
                    _logger.error((Object)("Unable to save password file, password change for user'" + principal + "' will revert at restart"));
                    user.setPassword(orig, true);
                    boolean bl = false;
                    this._userUpdate.unlock();
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            finally {
                this._userUpdate.unlock();
            }
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean createPrincipal(Principal principal, char[] password) {
        HashedUser user;
        if (this._users.get(principal.getName()) != null) {
            return false;
        }
        try {
            user = new HashedUser(principal.getName(), password);
        }
        catch (Exception e1) {
            _logger.warn((Object)("Unable to create new user '" + principal.getName() + "'"));
            return false;
        }
        try {
            this._userUpdate.lock();
            this._users.put(user.getName(), user);
            try {
                this.savePasswordFile();
                boolean e1 = true;
                return e1;
            }
            catch (IOException e) {
                this._users.remove(user.getName());
                boolean bl = false;
                this._userUpdate.unlock();
                return bl;
            }
        }
        finally {
            this._userUpdate.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deletePrincipal(Principal principal) throws AccountNotFoundException {
        HashedUser user = this._users.get(principal.getName());
        if (user == null) {
            throw new AccountNotFoundException(principal.getName());
        }
        try {
            this._userUpdate.lock();
            user.delete();
            try {
                this.savePasswordFile();
            }
            catch (IOException e) {
                _logger.warn((Object)("Unable to remove user '" + user.getName() + "' from password file."));
                boolean bl = false;
                this._userUpdate.unlock();
                return bl;
            }
            this._users.remove(user.getName());
        }
        finally {
            this._userUpdate.unlock();
        }
        return true;
    }

    @Override
    public Map<String, AuthenticationProviderInitialiser> getMechanisms() {
        return this._saslServers;
    }

    @Override
    public List<Principal> getUsers() {
        return new LinkedList<Principal>(this._users.values());
    }

    @Override
    public Principal getUser(String username) {
        if (this._users.containsKey(username)) {
            return new UsernamePrincipal(username);
        }
        return null;
    }

    private char[] lookupPassword(String name) {
        HashedUser user = this._users.get(name);
        if (user == null) {
            return null;
        }
        return user.getPassword();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPasswordFile() throws IOException {
        try {
            this._userUpdate.lock();
            this._users.clear();
            try (BufferedReader reader = null;){
                String line;
                reader = new BufferedReader(new FileReader(this._passwordFile));
                while ((line = reader.readLine()) != null) {
                    String[] result = this._regexp.split(line);
                    if (result == null || result.length < 2 || result[0].startsWith("#")) continue;
                    HashedUser user = new HashedUser(result);
                    _logger.info((Object)("Created user:" + user));
                    this._users.put(user.getName(), user);
                }
            }
        }
        finally {
            this._userUpdate.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void savePasswordFile() throws IOException {
        try {
            File tmp;
            this._userUpdate.lock();
            BufferedReader reader = null;
            PrintStream writer = null;
            SecureRandom r = new SecureRandom();
            while ((tmp = new File(this._passwordFile.getPath() + r.nextInt() + ".tmp")).exists()) {
            }
            tmp.deleteOnExit();
            try {
                byte[] encodedPassword;
                String line;
                writer = new PrintStream(tmp);
                reader = new BufferedReader(new FileReader(this._passwordFile));
                while ((line = reader.readLine()) != null) {
                    String[] result = this._regexp.split(line);
                    if (result == null || result.length < 2 || result[0].startsWith("#")) {
                        writer.write(line.getBytes(DEFAULT_ENCODING));
                        writer.println();
                        continue;
                    }
                    HashedUser user = this._users.get(result[0]);
                    if (user == null) {
                        writer.write(line.getBytes(DEFAULT_ENCODING));
                        writer.println();
                        continue;
                    }
                    if (user.isDeleted()) continue;
                    if (!user.isModified()) {
                        writer.write(line.getBytes(DEFAULT_ENCODING));
                        writer.println();
                        continue;
                    }
                    try {
                        encodedPassword = user.getEncodedPassword();
                        writer.write((user.getName() + ":").getBytes(DEFAULT_ENCODING));
                        writer.write(encodedPassword);
                        writer.println();
                        user.saved();
                    }
                    catch (Exception e) {
                        _logger.warn((Object)"Unable to encode new password reverting to old password.");
                        writer.write(line.getBytes(DEFAULT_ENCODING));
                        writer.println();
                    }
                }
                for (HashedUser user : this._users.values()) {
                    if (!user.isModified()) continue;
                    try {
                        encodedPassword = user.getEncodedPassword();
                        writer.write((user.getName() + ":").getBytes(DEFAULT_ENCODING));
                        writer.write(encodedPassword);
                        writer.println();
                        user.saved();
                    }
                    catch (Exception e) {
                        _logger.warn((Object)("Unable to get Encoded password for user'" + user.getName() + "' password not saved"));
                    }
                }
            }
            catch (IOException e) {
                _logger.error((Object)("Unable to create the new password file: " + e));
                throw new IOException("Unable to create the new password file" + e);
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
                if (writer != null) {
                    writer.close();
                }
            }
            File old = new File(this._passwordFile.getAbsoluteFile() + ".old");
            if (old.exists()) {
                old.delete();
            }
            if (!this._passwordFile.renameTo(old)) {
                _logger.error((Object)"Could not backup the existing password file");
                throw new IOException("Could not backup the existing password file");
            }
            if (!tmp.renameTo(this._passwordFile)) {
                if (!old.renameTo(this._passwordFile)) {
                    _logger.error((Object)"Could not rename the new password file into place, and unable to restore original file");
                    throw new IOException("Could not rename the new password file into place, and unable to restore original file");
                }
                _logger.error((Object)"Could not rename the new password file into place");
                throw new IOException("Could not rename the new password file into place");
            }
        }
        finally {
            this._userUpdate.unlock();
        }
    }

    @Override
    public void reload() throws IOException {
        this.loadPasswordFile();
    }
}

