/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.security.access;

import java.util.EnumSet;
import java.util.Set;
import org.wso2.andes.server.security.access.Operation;

public enum ObjectType {
    ALL(Operation.ALL),
    VIRTUALHOST(Operation.ACCESS),
    QUEUE(Operation.CREATE, Operation.DELETE, Operation.PURGE, Operation.CONSUME),
    TOPIC(Operation.CREATE, Operation.DELETE, Operation.PURGE, Operation.CONSUME),
    EXCHANGE(Operation.ACCESS, Operation.CREATE, Operation.DELETE, Operation.BIND, Operation.UNBIND, Operation.PUBLISH),
    LINK,
    ROUTE,
    METHOD(Operation.ALL, Operation.ACCESS, Operation.UPDATE, Operation.EXECUTE),
    OBJECT(Operation.ACCESS);

    private EnumSet<Operation> _actions;

    private ObjectType() {
        this._actions = EnumSet.noneOf(Operation.class);
    }

    private ObjectType(Operation operation) {
        this._actions = operation == Operation.ALL ? EnumSet.allOf(Operation.class) : EnumSet.of(operation);
    }

    private ObjectType(Operation first, Operation ... rest) {
        this._actions = EnumSet.of(first, rest);
    }

    public Set<Operation> getActions() {
        return this._actions;
    }

    public boolean isAllowed(Operation operation) {
        return this._actions.contains((Object)operation);
    }

    public static ObjectType parse(String text) {
        for (ObjectType object : ObjectType.values()) {
            if (!object.name().equalsIgnoreCase(text)) continue;
            return object;
        }
        throw new IllegalArgumentException("Not a valid object type: " + text);
    }

    public String toString() {
        String name = this.name();
        return name.charAt(0) + name.substring(1).toLowerCase();
    }
}

