/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.registry;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.wso2.andes.common.QpidProperties;
import org.wso2.andes.configuration.qpid.BrokerConfig;
import org.wso2.andes.configuration.qpid.BrokerConfigType;
import org.wso2.andes.configuration.qpid.ConfigStore;
import org.wso2.andes.configuration.qpid.ConfiguredObject;
import org.wso2.andes.configuration.qpid.SystemConfig;
import org.wso2.andes.configuration.qpid.VirtualHostConfig;
import org.wso2.andes.server.registry.IApplicationRegistry;
import org.wso2.andes.server.virtualhost.VirtualHost;

public class BrokerConfigAdapter
implements BrokerConfig {
    private final IApplicationRegistry _instance;
    private SystemConfig _system;
    private final Map<UUID, VirtualHostConfig> _vhosts = new ConcurrentHashMap<UUID, VirtualHostConfig>();
    private final long _createTime = System.currentTimeMillis();
    private UUID _id;
    private String _federationTag;

    public BrokerConfigAdapter(IApplicationRegistry instance) {
        this._instance = instance;
        this._id = instance.getConfigStore().createId();
        this._federationTag = UUID.randomUUID().toString();
    }

    @Override
    public void setSystem(SystemConfig system) {
        this._system = system;
    }

    @Override
    public SystemConfig getSystem() {
        return this._system;
    }

    @Override
    public Integer getPort() {
        List ports = this._instance.getConfiguration().getPorts();
        if (ports.size() > 0) {
            return Integer.valueOf(ports.get(0).toString());
        }
        return 0;
    }

    @Override
    public Integer getWorkerThreads() {
        return this._instance.getConfiguration().getConnectorProcessors();
    }

    @Override
    public Integer getMaxConnections() {
        return 0;
    }

    @Override
    public Integer getConnectionBacklogLimit() {
        return 0;
    }

    @Override
    public Long getStagingThreshold() {
        return 0L;
    }

    @Override
    public Integer getManagementPublishInterval() {
        return 10000;
    }

    @Override
    public String getVersion() {
        return QpidProperties.getReleaseVersion() + " [Build: " + QpidProperties.getBuildVersion() + "]";
    }

    @Override
    public String getDataDirectory() {
        return this._instance.getConfiguration().getQpidWork();
    }

    @Override
    public void addVirtualHost(VirtualHostConfig virtualHost) {
        virtualHost.setBroker(this);
        this._vhosts.put(virtualHost.getId(), virtualHost);
        this.getConfigStore().addConfiguredObject(virtualHost);
    }

    private ConfigStore getConfigStore() {
        return this._instance.getConfigStore();
    }

    @Override
    public long getCreateTime() {
        return this._createTime;
    }

    @Override
    public void createBrokerConnection(String transport, String host, int port, boolean durable, String authMechanism, String username, String password) {
        VirtualHost vhost = this._instance.getVirtualHostRegistry().getDefaultVirtualHost();
        vhost.createBrokerConnection(transport, host, port, "", durable, authMechanism, username, password);
    }

    @Override
    public UUID getId() {
        return this._id;
    }

    @Override
    public BrokerConfigType getConfigType() {
        return BrokerConfigType.getInstance();
    }

    @Override
    public ConfiguredObject getParent() {
        return this._system;
    }

    @Override
    public boolean isDurable() {
        return false;
    }

    @Override
    public String getFederationTag() {
        return this._federationTag;
    }
}

