/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.queue;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.apache.log4j.Logger;
import org.wso2.andes.AMQException;
import org.wso2.andes.kernel.AndesContext;
import org.wso2.andes.server.exchange.Exchange;
import org.wso2.andes.server.message.AMQMessageHeader;
import org.wso2.andes.server.message.EnqueableMessage;
import org.wso2.andes.server.message.MessageReference;
import org.wso2.andes.server.message.ServerMessage;
import org.wso2.andes.server.queue.AMQQueue;
import org.wso2.andes.server.queue.BaseQueue;
import org.wso2.andes.server.queue.InboundMessageAdapter;
import org.wso2.andes.server.queue.QueueEntry;
import org.wso2.andes.server.queue.QueueEntryList;
import org.wso2.andes.server.queue.SimpleQueueEntryList;
import org.wso2.andes.server.subscription.Subscription;
import org.wso2.andes.server.txn.AutoCommitTransaction;
import org.wso2.andes.server.txn.ServerTransaction;

public class QueueEntryImpl
implements QueueEntry {
    private static final Logger _log = Logger.getLogger(QueueEntryImpl.class);
    private final SimpleQueueEntryList _queueEntryList;
    private MessageReference _message;
    private Set<Subscription> _rejectedBy = null;
    private volatile QueueEntry.EntryState _state = AVAILABLE_STATE;
    private long creationTime;
    private static final AtomicReferenceFieldUpdater<QueueEntryImpl, QueueEntry.EntryState> _stateUpdater = AtomicReferenceFieldUpdater.newUpdater(QueueEntryImpl.class, QueueEntry.EntryState.class, "_state");
    private volatile Set<QueueEntry.StateChangeListener> _stateChangeListeners;
    private static final AtomicReferenceFieldUpdater<QueueEntryImpl, Set> _listenersUpdater = AtomicReferenceFieldUpdater.newUpdater(QueueEntryImpl.class, Set.class, "_stateChangeListeners");
    private static final AtomicLongFieldUpdater<QueueEntryImpl> _entryIdUpdater = AtomicLongFieldUpdater.newUpdater(QueueEntryImpl.class, "_entryId");
    private volatile long _entryId;
    volatile QueueEntryImpl _next;
    private static final int DELIVERED_TO_CONSUMER = 1;
    private static final int REDELIVERED = 2;
    private volatile int _deliveryState;

    QueueEntryImpl(SimpleQueueEntryList queueEntryList) {
        this(queueEntryList, null, Long.MIN_VALUE);
        this._state = DELETED_STATE;
    }

    public QueueEntryImpl(SimpleQueueEntryList queueEntryList, ServerMessage message, long entryId) {
        this._queueEntryList = queueEntryList;
        this.creationTime = System.currentTimeMillis();
        this._message = message == null ? null : message.newReference();
        _entryIdUpdater.set(this, entryId);
    }

    public QueueEntryImpl(SimpleQueueEntryList queueEntryList, ServerMessage message) {
        this._queueEntryList = queueEntryList;
        this.creationTime = System.currentTimeMillis();
        this._message = message == null ? null : message.newReference();
    }

    protected void setEntryId(long entryId) {
        _entryIdUpdater.set(this, entryId);
    }

    protected long getEntryId() {
        return this._entryId;
    }

    @Override
    public AMQQueue getQueue() {
        return this._queueEntryList.getQueue();
    }

    @Override
    public ServerMessage getMessage() {
        return this._message == null ? null : (ServerMessage)this._message.getMessage();
    }

    @Override
    public long getSize() {
        return this.getMessage() == null ? 0L : this.getMessage().getSize();
    }

    @Override
    public boolean getDeliveredToConsumer() {
        return (this._deliveryState & 1) != 0;
    }

    @Override
    public boolean expired() throws AMQException {
        long expiration;
        ServerMessage message = this.getMessage();
        if (message != null && (expiration = message.getExpiration()) != 0L) {
            long now = System.currentTimeMillis();
            return now > expiration;
        }
        return false;
    }

    @Override
    public boolean isAvailable() {
        return this._state == AVAILABLE_STATE;
    }

    @Override
    public boolean isTimelyDisposable() {
        int deliveryTimeoutInSec = AndesContext.getInstance().getDeliveryTimeoutForMessage();
        return System.currentTimeMillis() - this.creationTime > (long)(deliveryTimeoutInSec * 1000);
    }

    @Override
    public boolean isAcquired() {
        return this._state.getState() == QueueEntry.State.ACQUIRED;
    }

    @Override
    public boolean acquire() {
        return this.acquire(NON_SUBSCRIPTION_ACQUIRED_STATE);
    }

    private boolean acquire(QueueEntry.EntryState state) {
        QueueEntry.EntryState currentState;
        boolean acquired = _stateUpdater.compareAndSet(this, AVAILABLE_STATE, state);
        if (!acquired && state != NON_SUBSCRIPTION_ACQUIRED_STATE && (currentState = this._state).getState() == QueueEntry.State.AVAILABLE && (currentState == AVAILABLE_STATE || ((QueueEntry.SubscriptionAcquiredState)state).getSubscription() == ((QueueEntry.SubscriptionAssignedState)currentState).getSubscription() || ((QueueEntry.SubscriptionAssignedState)currentState).getSubscription().isClosed())) {
            acquired = _stateUpdater.compareAndSet(this, currentState, state);
        }
        if (acquired && this._stateChangeListeners != null) {
            this.notifyStateChange(QueueEntry.State.AVAILABLE, QueueEntry.State.ACQUIRED);
        }
        return acquired;
    }

    @Override
    public boolean acquire(Subscription sub) {
        boolean acquired = this.acquire(sub.getOwningState());
        if (acquired) {
            this._deliveryState |= 1;
        }
        return acquired;
    }

    @Override
    public boolean acquiredBySubscription() {
        return this._state instanceof QueueEntry.SubscriptionAcquiredState;
    }

    @Override
    public boolean isAcquiredBy(Subscription subscription) {
        QueueEntry.EntryState state = this._state;
        return state instanceof QueueEntry.SubscriptionAcquiredState && ((QueueEntry.SubscriptionAcquiredState)state).getSubscription() == subscription;
    }

    @Override
    public void release() {
        QueueEntry.EntryState state = this._state;
        if (state.getState() == QueueEntry.State.ACQUIRED && _stateUpdater.compareAndSet(this, state, AVAILABLE_STATE)) {
            if (state instanceof QueueEntry.SubscriptionAcquiredState) {
                this.getQueue().decrementUnackedMsgCount();
            }
            if (!this.getQueue().isDeleted()) {
                this.getQueue().requeue(this);
                if (this._stateChangeListeners != null) {
                    this.notifyStateChange(QueueEntry.State.ACQUIRED, QueueEntry.State.AVAILABLE);
                }
            } else if (this.acquire()) {
                this.routeToAlternate();
            }
        }
    }

    @Override
    public boolean releaseButRetain() {
        Subscription sub;
        QueueEntry.EntryState state = this._state;
        boolean stateUpdated = false;
        if (state instanceof QueueEntry.SubscriptionAcquiredState && _stateUpdater.compareAndSet(this, state, (sub = ((QueueEntry.SubscriptionAcquiredState)state).getSubscription()).getAssignedState())) {
            System.err.println("Message released (and retained)" + this.getMessage().getMessageNumber());
            this.getQueue().requeue(this);
            if (this._stateChangeListeners != null) {
                this.notifyStateChange(QueueEntry.State.ACQUIRED, QueueEntry.State.AVAILABLE);
            }
            stateUpdated = true;
        }
        return stateUpdated;
    }

    @Override
    public boolean immediateAndNotDelivered() {
        return !this.getDeliveredToConsumer() && this.isImmediate();
    }

    private boolean isImmediate() {
        ServerMessage message = this.getMessage();
        return message != null && message.isImmediate();
    }

    @Override
    public void setRedelivered() {
        this._deliveryState |= 2;
    }

    @Override
    public AMQMessageHeader getMessageHeader() {
        ServerMessage message = this.getMessage();
        return message == null ? null : message.getMessageHeader();
    }

    @Override
    public boolean isPersistent() {
        ServerMessage message = this.getMessage();
        return message != null && message.isPersistent();
    }

    @Override
    public boolean isRedelivered() {
        return (this._deliveryState & 2) != 0;
    }

    @Override
    public Subscription getDeliveredSubscription() {
        QueueEntry.EntryState state = this._state;
        if (state instanceof QueueEntry.SubscriptionAcquiredState) {
            return ((QueueEntry.SubscriptionAcquiredState)state).getSubscription();
        }
        return null;
    }

    @Override
    public void reject() {
        this.reject(this.getDeliveredSubscription());
    }

    @Override
    public void reject(Subscription subscription) {
        if (subscription != null) {
            if (this._rejectedBy == null) {
                this._rejectedBy = new HashSet<Subscription>();
            }
            this._rejectedBy.add(subscription);
        } else {
            _log.warn((Object)("Requesting rejection by null subscriber:" + this));
        }
    }

    @Override
    public boolean isRejectedBy(Subscription subscription) {
        if (this._rejectedBy != null) {
            return this._rejectedBy.contains(subscription);
        }
        return false;
    }

    @Override
    public void dequeue() {
        QueueEntry.EntryState state = this._state;
        if (state.getState() == QueueEntry.State.ACQUIRED && _stateUpdater.compareAndSet(this, state, DEQUEUED_STATE)) {
            Subscription s = null;
            if (state instanceof QueueEntry.SubscriptionAcquiredState) {
                this.getQueue().decrementUnackedMsgCount();
                s = ((QueueEntry.SubscriptionAcquiredState)state).getSubscription();
                s.onDequeue(this);
            }
            this.getQueue().dequeue(this, s);
            if (this._stateChangeListeners != null) {
                this.notifyStateChange(state.getState(), QueueEntry.State.DEQUEUED);
            }
        }
    }

    private void notifyStateChange(QueueEntry.State oldState, QueueEntry.State newState) {
        for (QueueEntry.StateChangeListener l : this._stateChangeListeners) {
            l.stateChanged(this, oldState, newState);
        }
    }

    @Override
    public void dispose() {
        if (this.delete()) {
            this._message.release();
        }
    }

    @Override
    public void discard() {
        if (this.getQueue() != null) {
            this.dequeue();
        }
        this.dispose();
    }

    @Override
    public void routeToAlternate() {
        AMQQueue currentQueue = this.getQueue();
        Exchange alternateExchange = currentQueue.getAlternateExchange();
        if (alternateExchange != null) {
            final ArrayList<? extends BaseQueue> rerouteQueues = alternateExchange.route(new InboundMessageAdapter(this));
            final ServerMessage message = this.getMessage();
            if (rerouteQueues != null && rerouteQueues.size() != 0) {
                AutoCommitTransaction txn = new AutoCommitTransaction(this.getQueue().getVirtualHost().getTransactionLog());
                txn.enqueue(rerouteQueues, (EnqueableMessage)message, new ServerTransaction.Action(){

                    @Override
                    public void postCommit() {
                        try {
                            for (BaseQueue queue : rerouteQueues) {
                                queue.enqueue(message);
                            }
                        }
                        catch (AMQException e) {
                            throw new RuntimeException(e);
                        }
                    }

                    @Override
                    public void onRollback() {
                    }
                });
                txn.dequeue(currentQueue, message, new ServerTransaction.Action(){

                    @Override
                    public void postCommit() {
                        QueueEntryImpl.this.discard();
                    }

                    @Override
                    public void onRollback() {
                    }
                });
            }
        }
    }

    @Override
    public boolean isQueueDeleted() {
        return this.getQueue().isDeleted();
    }

    @Override
    public void addStateChangeListener(QueueEntry.StateChangeListener listener) {
        Set<QueueEntry.StateChangeListener> listeners = this._stateChangeListeners;
        if (listeners == null) {
            _listenersUpdater.compareAndSet(this, null, new CopyOnWriteArraySet());
            listeners = this._stateChangeListeners;
        }
        listeners.add(listener);
    }

    @Override
    public boolean removeStateChangeListener(QueueEntry.StateChangeListener listener) {
        Set<QueueEntry.StateChangeListener> listeners = this._stateChangeListeners;
        if (listeners != null) {
            return listeners.remove(listener);
        }
        return false;
    }

    @Override
    public int compareTo(QueueEntry o) {
        QueueEntryImpl other = (QueueEntryImpl)o;
        return this.getEntryId() > other.getEntryId() ? 1 : (this.getEntryId() < other.getEntryId() ? -1 : 0);
    }

    public QueueEntryImpl getNext() {
        QueueEntryImpl next = this.nextNode();
        while (next != null && next.isDispensed()) {
            QueueEntryImpl newNext = next.nextNode();
            if (newNext != null) {
                SimpleQueueEntryList._nextUpdater.compareAndSet(this, next, newNext);
                next = this.nextNode();
                continue;
            }
            next = null;
        }
        return next;
    }

    QueueEntryImpl nextNode() {
        return this._next;
    }

    @Override
    public boolean isDeleted() {
        return this._state == DELETED_STATE;
    }

    @Override
    public boolean delete() {
        QueueEntry.EntryState state = this._state;
        if (state != DELETED_STATE && _stateUpdater.compareAndSet(this, state, DELETED_STATE)) {
            this._queueEntryList.advanceHead();
            return true;
        }
        return false;
    }

    public QueueEntryList getQueueEntryList() {
        return this._queueEntryList;
    }

    @Override
    public boolean isDequeued() {
        return this._state == DEQUEUED_STATE;
    }

    @Override
    public boolean isDispensed() {
        return this._state.isDispensed();
    }
}

