/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.queue;

import org.wso2.andes.server.message.ServerMessage;
import org.wso2.andes.server.queue.AMQQueue;
import org.wso2.andes.server.queue.QueueEntry;
import org.wso2.andes.server.queue.QueueEntryImpl;
import org.wso2.andes.server.queue.QueueEntryIterator;
import org.wso2.andes.server.queue.QueueEntryList;
import org.wso2.andes.server.queue.QueueEntryListFactory;
import org.wso2.andes.server.queue.SimpleQueueEntryList;

public class PriorityQueueList
implements QueueEntryList {
    private final AMQQueue _queue;
    private final QueueEntryList[] _priorityLists;
    private final int _priorities;
    private final int _priorityOffset;

    public PriorityQueueList(AMQQueue queue, int priorities) {
        this._queue = queue;
        this._priorityLists = new QueueEntryList[priorities];
        this._priorities = priorities;
        this._priorityOffset = 5 - (priorities + 1) / 2;
        for (int i = 0; i < priorities; ++i) {
            this._priorityLists[i] = new SimpleQueueEntryList(queue);
        }
    }

    public int getPriorities() {
        return this._priorities;
    }

    @Override
    public AMQQueue getQueue() {
        return this._queue;
    }

    @Override
    public QueueEntry add(ServerMessage message) {
        int index = message.getMessageHeader().getPriority() - this._priorityOffset;
        if (index >= this._priorities) {
            index = this._priorities - 1;
        } else if (index < 0) {
            index = 0;
        }
        return this._priorityLists[index].add(message);
    }

    @Override
    public QueueEntry next(QueueEntry node) {
        QueueEntryImpl nodeImpl = (QueueEntryImpl)node;
        QueueEntryImpl next = nodeImpl.getNext();
        if (next == null) {
            QueueEntryList nodeEntryList = nodeImpl.getQueueEntryList();
            int index = this._priorityLists.length - 1;
            while (this._priorityLists[index] != nodeEntryList) {
                --index;
            }
            while (next == null && index != 0) {
                next = ((QueueEntryImpl)this._priorityLists[--index].getHead()).getNext();
            }
        }
        return next;
    }

    @Override
    public QueueEntryIterator iterator() {
        return new PriorityQueueEntryListIterator();
    }

    @Override
    public QueueEntry getHead() {
        return this._priorityLists[this._priorities - 1].getHead();
    }

    static class Factory
    implements QueueEntryListFactory {
        private final int _priorities;

        Factory(int priorities) {
            this._priorities = priorities;
        }

        @Override
        public QueueEntryList createQueueEntryList(AMQQueue queue) {
            return new PriorityQueueList(queue, this._priorities);
        }
    }

    private final class PriorityQueueEntryListIterator
    implements QueueEntryIterator {
        private final QueueEntryIterator[] _iterators;
        private QueueEntry _lastNode;

        PriorityQueueEntryListIterator() {
            this._iterators = new QueueEntryIterator[PriorityQueueList.this._priorityLists.length];
            for (int i = 0; i < PriorityQueueList.this._priorityLists.length; ++i) {
                this._iterators[i] = PriorityQueueList.this._priorityLists[i].iterator();
            }
            this._lastNode = this._iterators[this._iterators.length - 1].getNode();
        }

        @Override
        public boolean atTail() {
            for (int i = 0; i < this._iterators.length; ++i) {
                if (this._iterators[i].atTail()) continue;
                return false;
            }
            return true;
        }

        @Override
        public QueueEntry getNode() {
            return this._lastNode;
        }

        @Override
        public boolean advance() {
            for (int i = this._iterators.length - 1; i >= 0; --i) {
                if (!this._iterators[i].advance()) continue;
                this._lastNode = this._iterators[i].getNode();
                return true;
            }
            return false;
        }
    }
}

