/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.queue;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.wso2.andes.AMQException;
import org.wso2.andes.framing.AMQShortString;
import org.wso2.andes.framing.BasicContentHeaderProperties;
import org.wso2.andes.framing.ContentHeaderBody;
import org.wso2.andes.framing.abstraction.ContentChunk;
import org.wso2.andes.framing.abstraction.MessagePublishInfo;
import org.wso2.andes.server.exchange.Exchange;
import org.wso2.andes.server.message.AMQMessageHeader;
import org.wso2.andes.server.message.EnqueableMessage;
import org.wso2.andes.server.message.InboundMessage;
import org.wso2.andes.server.message.MessageContentSource;
import org.wso2.andes.server.message.MessageMetaData;
import org.wso2.andes.server.queue.BaseQueue;
import org.wso2.andes.server.queue.Filterable;
import org.wso2.andes.server.registry.ApplicationRegistry;
import org.wso2.andes.server.store.StoredMessage;

public class IncomingMessage
implements Filterable,
InboundMessage,
EnqueableMessage,
MessageContentSource {
    private static final boolean SYNCED_CLOCKS = ApplicationRegistry.getInstance().getConfiguration().getSynchedClocks();
    private final MessagePublishInfo _messagePublishInfo;
    private ContentHeaderBody _contentHeaderBody;
    private long publisherSessionID;
    private long _bodyLengthReceived = 0L;
    private ArrayList<? extends BaseQueue> _destinationQueues;
    private long _expiration;
    private long _arrivalTime;
    private Exchange _exchange;
    private int _receivedChunkCount = 0;
    private List<ContentChunk> _contentChunks = new ArrayList<ContentChunk>();
    private MessageMetaData _messageMetaData;
    private StoredMessage<MessageMetaData> _storedMessageHandle;
    private StoredMessage<MessageMetaData> _storedCassandraMessageHandle;

    public IncomingMessage(MessagePublishInfo info) {
        this._messagePublishInfo = info;
    }

    public void setContentHeaderBody(ContentHeaderBody contentHeaderBody) throws AMQException {
        this._contentHeaderBody = contentHeaderBody;
    }

    public void setExpiration() {
        this._expiration = ((BasicContentHeaderProperties)this._contentHeaderBody.getProperties()).getExpiration();
    }

    public long getPublisherSessionID() {
        return this.publisherSessionID;
    }

    public void setPublisherSessionID(long uniquePublisherSessionID) {
        this.publisherSessionID = uniquePublisherSessionID;
    }

    public void setArrivalTime() {
        this._arrivalTime = ((BasicContentHeaderProperties)this._contentHeaderBody.getProperties()).getTimestamp();
    }

    public MessageMetaData headersReceived() {
        this._messageMetaData = new MessageMetaData(this._messagePublishInfo, this._contentHeaderBody, 0);
        return this._messageMetaData;
    }

    public ArrayList<? extends BaseQueue> getDestinationQueues() {
        return this._destinationQueues;
    }

    public int addContentBodyFrame(ContentChunk contentChunk) throws AMQException {
        this._bodyLengthReceived += (long)contentChunk.getSize();
        this._contentChunks.add(contentChunk);
        return this._receivedChunkCount++;
    }

    public long getBodyLengthReceived() {
        return this._bodyLengthReceived;
    }

    public boolean allContentReceived() {
        return this._bodyLengthReceived == this.getContentHeader().bodySize;
    }

    public AMQShortString getExchange() {
        return this._messagePublishInfo.getExchange();
    }

    @Override
    public String getRoutingKey() {
        return this._messagePublishInfo.getRoutingKey() == null ? null : this._messagePublishInfo.getRoutingKey().toString();
    }

    public String getBinding() {
        return this._messagePublishInfo.getRoutingKey() == null ? null : this._messagePublishInfo.getRoutingKey().toString();
    }

    public boolean isMandatory() {
        return this._messagePublishInfo.isMandatory();
    }

    public boolean isImmediate() {
        return this._messagePublishInfo.isImmediate();
    }

    public ContentHeaderBody getContentHeader() {
        return this._contentHeaderBody;
    }

    @Override
    public AMQMessageHeader getMessageHeader() {
        return this._messageMetaData.getMessageHeader();
    }

    @Override
    public boolean isPersistent() {
        return this.getContentHeader().getProperties() instanceof BasicContentHeaderProperties && ((BasicContentHeaderProperties)this.getContentHeader().getProperties()).getDeliveryMode() == 2;
    }

    @Override
    public boolean isRedelivered() {
        return false;
    }

    @Override
    public long getSize() {
        return this.getContentHeader().bodySize;
    }

    @Override
    public Long getMessageNumber() {
        return this._storedMessageHandle.getMessageNumber();
    }

    public void setExchange(Exchange e) {
        this._exchange = e;
    }

    public void route() {
        this.enqueue(this._exchange.route(this));
    }

    public void enqueue(ArrayList<? extends BaseQueue> queues) {
        this._destinationQueues = queues;
    }

    public MessagePublishInfo getMessagePublishInfo() {
        return this._messagePublishInfo;
    }

    public long getExpiration() {
        return this._expiration;
    }

    public long getArrivalTime() {
        return this._arrivalTime;
    }

    public int getReceivedChunkCount() {
        return this._receivedChunkCount;
    }

    public int getBodyCount() {
        return this._contentChunks.size();
    }

    public ContentChunk getContentChunk(int index) {
        return this._contentChunks.get(index);
    }

    @Override
    public int getContent(ByteBuffer buf, int offset) {
        int pos = 0;
        int written = 0;
        for (ContentChunk cb : this._contentChunks) {
            ByteBuffer data = cb.getData().buf();
            if (offset + written >= pos && offset < pos + data.limit()) {
                ByteBuffer src = data.duplicate();
                src.position(offset + written - pos);
                src = src.slice();
                if (buf.remaining() < src.limit()) {
                    src.limit(buf.remaining());
                }
                int count = src.limit();
                buf.put(src);
                written += count;
                if (buf.remaining() == 0) break;
            }
            pos += data.limit();
        }
        return written;
    }

    public void setStoredMessage(StoredMessage<MessageMetaData> storedMessageHandle) {
        this._storedMessageHandle = storedMessageHandle;
        this._storedMessageHandle.setExchange(this.getExchange().toString());
    }

    public StoredMessage<MessageMetaData> getStoredMessage() {
        return this._storedMessageHandle;
    }

    public StoredMessage<MessageMetaData> get_storedCassandraMessageHandle() {
        return this._storedCassandraMessageHandle;
    }

    public void set_storedCassandraMessageHandle(StoredMessage<MessageMetaData> _storedCassandraMessageHandle) {
        this._storedCassandraMessageHandle = _storedCassandraMessageHandle;
    }
}

