/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.queue;

import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.wso2.andes.framing.AMQShortString;
import org.wso2.andes.server.queue.AMQQueue;
import org.wso2.andes.server.queue.QueueRegistry;
import org.wso2.andes.server.virtualhost.VirtualHost;

public class DefaultQueueRegistry
implements QueueRegistry {
    private ConcurrentMap<AMQShortString, AMQQueue> _queueMap = new ConcurrentHashMap<AMQShortString, AMQQueue>();
    private final VirtualHost _virtualHost;

    public DefaultQueueRegistry(VirtualHost virtualHost) {
        this._virtualHost = virtualHost;
    }

    @Override
    public VirtualHost getVirtualHost() {
        return this._virtualHost;
    }

    @Override
    public void registerQueue(AMQQueue queue) {
        this._queueMap.put(queue.getNameShortString(), queue);
    }

    @Override
    public void unregisterQueue(AMQShortString name) {
        this._queueMap.remove(name);
    }

    @Override
    public AMQQueue getQueue(AMQShortString name) {
        return (AMQQueue)this._queueMap.get(name);
    }

    @Override
    public Collection<AMQShortString> getQueueNames() {
        return this._queueMap.keySet();
    }

    @Override
    public Collection<AMQQueue> getQueues() {
        return this._queueMap.values();
    }

    @Override
    public AMQQueue getQueue(String queue) {
        return this.getQueue(new AMQShortString(queue));
    }
}

