/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.queue;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.wso2.andes.amqp.AMQPUtils;
import org.wso2.andes.framing.AMQShortString;
import org.wso2.andes.kernel.Andes;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.AndesMessageMetadata;
import org.wso2.andes.kernel.disruptor.inbound.InboundBindingEvent;
import org.wso2.andes.kernel.disruptor.inbound.InboundExchangeEvent;
import org.wso2.andes.kernel.disruptor.inbound.InboundQueueEvent;
import org.wso2.andes.kernel.disruptor.inbound.QueueInfo;
import org.wso2.andes.server.ClusterResourceHolder;
import org.wso2.andes.server.message.AMQMessage;
import org.wso2.andes.server.queue.AMQQueue;
import org.wso2.andes.server.queue.QueueEntry;
import org.wso2.andes.server.queue.QueueRegistry;
import org.wso2.andes.server.registry.ApplicationRegistry;
import org.wso2.andes.server.registry.IApplicationRegistry;
import org.wso2.andes.server.virtualhost.VirtualHost;

public class DLCQueueUtils {
    private static final Logger log = Logger.getLogger(DLCQueueUtils.class);

    public static String identifyTenantInformationAndGenerateDLCString(String queueName) {
        String destinationString;
        if (queueName.contains("/")) {
            if (queueName.contains("carbon:")) {
                queueName = queueName.split(":")[1];
            }
            destinationString = queueName.split("/", 2)[0] + "/" + "deadletterchannel";
        } else {
            destinationString = "deadletterchannel";
        }
        return destinationString;
    }

    public static String generateDLCQueueNameFromTenant(String tenantDomain) {
        if (null != tenantDomain && !"carbon.super".equals(tenantDomain)) {
            return tenantDomain + "/" + "deadletterchannel";
        }
        return "deadletterchannel";
    }

    public static boolean isDeadLetterQueue(String queueName) {
        boolean isDeadLetterQueue = false;
        if (queueName.contains("/")) {
            if ("deadletterchannel".equals(queueName.split("/", 2)[1])) {
                isDeadLetterQueue = true;
            }
        } else if ("deadletterchannel".equals(queueName)) {
            isDeadLetterQueue = true;
        }
        return isDeadLetterQueue;
    }

    public static synchronized void createDLCQueue(String tenantName, String tenantOwner) throws AndesException {
        String dlcQueueName;
        IApplicationRegistry applicationRegistry = ApplicationRegistry.getInstance();
        VirtualHost virtualHost = applicationRegistry.getVirtualHostRegistry().getDefaultVirtualHost();
        QueueRegistry queueRegistry = virtualHost.getQueueRegistry();
        AMQQueue queue = queueRegistry.getQueue(new AMQShortString(dlcQueueName = "carbon.super".equals(tenantName) ? "deadletterchannel" : tenantName + "/" + "deadletterchannel"));
        if (null == queue) {
            Andes.getInstance().createExchange(new InboundExchangeEvent(AMQPUtils.DLC_EXCHANGE_NAME, "DLC", false));
            Andes.getInstance().createQueue(new InboundQueueEvent(dlcQueueName, true, false, tenantOwner, false));
            QueueInfo DLCQueueInfo = new QueueInfo(dlcQueueName, true, false, tenantOwner, false);
            Andes.getInstance().addBinding(new InboundBindingEvent(DLCQueueInfo, AMQPUtils.DLC_EXCHANGE_NAME, dlcQueueName));
            ClusterResourceHolder.getInstance().getVirtualHostConfigSynchronizer().queue(dlcQueueName, tenantOwner, false, null);
            log.info((Object)(dlcQueueName + " Queue Created as Dead Letter Channel"));
        }
    }

    public static void addToDeadLetterChannel(QueueEntry message) {
        try {
            AMQMessage amqMessage = (AMQMessage)message.getMessage();
            Long messageID = amqMessage.getMessageNumber();
            String storageQueue = amqMessage.getRoutingKey();
            AndesMessageMetadata messageToMove = AMQPUtils.convertAMQMessageToAndesMetadata(amqMessage);
            messageToMove.setStorageQueueName(storageQueue);
            ArrayList<AndesMessageMetadata> messageToMoveToDLC = new ArrayList<AndesMessageMetadata>();
            messageToMoveToDLC.add(messageToMove);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Moving message to Dead Letter Channel. Message ID " + messageID));
            }
            Andes.getInstance().deleteMessages((Collection<AndesMessageMetadata>)messageToMoveToDLC, true);
        }
        catch (AndesException dlcException) {
            log.error((Object)("Error moving message " + message.getMessage().getMessageNumber() + " to dead letter channel."), (Throwable)dlcException);
        }
    }
}

