/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.queue;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.wso2.andes.server.message.ServerMessage;
import org.wso2.andes.server.queue.AMQQueue;
import org.wso2.andes.server.queue.QueueEntry;
import org.wso2.andes.server.queue.QueueEntryImpl;
import org.wso2.andes.server.queue.QueueEntryList;
import org.wso2.andes.server.queue.QueueEntryListFactory;
import org.wso2.andes.server.queue.SimpleQueueEntryList;
import org.wso2.andes.server.txn.AutoCommitTransaction;
import org.wso2.andes.server.txn.ServerTransaction;

public class ConflationQueueList
extends SimpleQueueEntryList {
    private final String _conflationKey;
    private final ConcurrentHashMap<Object, AtomicReference<QueueEntry>> _latestValuesMap = new ConcurrentHashMap();

    public ConflationQueueList(AMQQueue queue, String conflationKey) {
        super(queue);
        this._conflationKey = conflationKey;
    }

    public String getConflationKey() {
        return this._conflationKey;
    }

    @Override
    protected ConflationQueueEntry createQueueEntry(ServerMessage message) {
        return new ConflationQueueEntry(this, message);
    }

    @Override
    public QueueEntry add(ServerMessage message) {
        ConflationQueueEntry entry = (ConflationQueueEntry)super.add(message);
        AtomicReference<QueueEntry> latestValueReference = null;
        Object value = message.getMessageHeader().getHeader(this._conflationKey);
        if (value != null) {
            QueueEntry oldEntry;
            latestValueReference = this._latestValuesMap.get(value);
            if (latestValueReference == null) {
                this._latestValuesMap.putIfAbsent(value, new AtomicReference<ConflationQueueEntry>(entry));
                latestValueReference = this._latestValuesMap.get(value);
            }
            while ((oldEntry = latestValueReference.get()).compareTo(entry) < 0 && !latestValueReference.compareAndSet(oldEntry, entry)) {
            }
            if (oldEntry.compareTo(entry) < 0) {
                if (oldEntry.acquire()) {
                    this.discardEntry(oldEntry);
                }
            } else if (oldEntry.compareTo(entry) > 0) {
                this.discardEntry(entry);
            }
        }
        entry.setLatestValueReference(latestValueReference);
        return entry;
    }

    private void discardEntry(final QueueEntry entry) {
        if (entry.acquire()) {
            AutoCommitTransaction txn = new AutoCommitTransaction(this.getQueue().getVirtualHost().getTransactionLog());
            txn.dequeue(entry.getQueue(), entry.getMessage(), new ServerTransaction.Action(){

                @Override
                public void postCommit() {
                    entry.discard();
                }

                @Override
                public void onRollback() {
                }
            });
        }
    }

    static class Factory
    implements QueueEntryListFactory {
        private final String _conflationKey;

        Factory(String conflationKey) {
            this._conflationKey = conflationKey;
        }

        @Override
        public QueueEntryList createQueueEntryList(AMQQueue queue) {
            return new ConflationQueueList(queue, this._conflationKey);
        }
    }

    private final class ConflationQueueEntry
    extends QueueEntryImpl {
        private AtomicReference<QueueEntry> _latestValueReference;

        public ConflationQueueEntry(SimpleQueueEntryList queueEntryList, ServerMessage message) {
            super(queueEntryList, message);
        }

        @Override
        public void release() {
            super.release();
            if (this._latestValueReference != null && this._latestValueReference.get() != this) {
                ConflationQueueList.this.discardEntry(this);
            }
        }

        public void setLatestValueReference(AtomicReference<QueueEntry> latestValueReference) {
            this._latestValueReference = latestValueReference;
        }
    }
}

