/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.queue;

import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.monitor.MonitorNotification;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.log4j.Logger;
import org.wso2.andes.AMQException;
import org.wso2.andes.framing.BasicContentHeaderProperties;
import org.wso2.andes.framing.ContentHeaderBody;
import org.wso2.andes.management.common.mbeans.ManagedQueue;
import org.wso2.andes.management.common.mbeans.annotations.MBeanConstructor;
import org.wso2.andes.management.common.mbeans.annotations.MBeanDescription;
import org.wso2.andes.server.management.AMQManagedObject;
import org.wso2.andes.server.management.ManagedObject;
import org.wso2.andes.server.message.AMQMessage;
import org.wso2.andes.server.message.AMQMessageHeader;
import org.wso2.andes.server.message.MessageTransferMessage;
import org.wso2.andes.server.message.ServerMessage;
import org.wso2.andes.server.queue.AMQQueue;
import org.wso2.andes.server.queue.NotificationCheck;
import org.wso2.andes.server.queue.QueueEntry;
import org.wso2.andes.server.queue.QueueNotificationListener;
import org.wso2.andes.server.txn.LocalTransaction;
import org.wso2.andes.transport.MessageProperties;

@MBeanDescription(value="Management Interface for AMQQueue")
public class AMQQueueMBean
extends AMQManagedObject
implements ManagedQueue,
QueueNotificationListener {
    private static final Logger _logger = Logger.getLogger(AMQQueueMBean.class);
    private static final SimpleDateFormat _dateFormat = new SimpleDateFormat("MM-dd-yy HH:mm:ss.SSS z");
    private AMQQueue _queue = null;
    private String _queueName = null;
    private static OpenType[] _msgAttributeTypes = new OpenType[5];
    private static CompositeType _messageDataType = null;
    private static TabularType _messagelistDataType = null;
    private static CompositeType _msgContentType = null;
    private static OpenType[] _msgContentAttributeTypes = new OpenType[4];
    private final long[] _lastNotificationTimes = new long[NotificationCheck.values().length];
    private Notification _lastNotification = null;

    @MBeanConstructor(value="Creates an MBean exposing an AMQQueue")
    public AMQQueueMBean(AMQQueue queue) throws JMException {
        super(ManagedQueue.class, "Queue");
        this._queue = queue;
        this._queueName = queue.getName();
    }

    @Override
    public ManagedObject getParentObject() {
        return this._queue.getVirtualHost().getManagedObject();
    }

    private static void init() throws OpenDataException {
        AMQQueueMBean._msgContentAttributeTypes[0] = SimpleType.LONG;
        AMQQueueMBean._msgContentAttributeTypes[1] = SimpleType.STRING;
        AMQQueueMBean._msgContentAttributeTypes[2] = SimpleType.STRING;
        AMQQueueMBean._msgContentAttributeTypes[3] = new ArrayType(1, SimpleType.BYTE);
        _msgContentType = new CompositeType("Message Content", "AMQ Message Content", VIEW_MSG_CONTENT_COMPOSITE_ITEM_NAMES_DESC.toArray(new String[VIEW_MSG_CONTENT_COMPOSITE_ITEM_NAMES_DESC.size()]), VIEW_MSG_CONTENT_COMPOSITE_ITEM_NAMES_DESC.toArray(new String[VIEW_MSG_CONTENT_COMPOSITE_ITEM_NAMES_DESC.size()]), _msgContentAttributeTypes);
        AMQQueueMBean._msgAttributeTypes[0] = SimpleType.LONG;
        AMQQueueMBean._msgAttributeTypes[1] = new ArrayType(1, SimpleType.STRING);
        AMQQueueMBean._msgAttributeTypes[2] = SimpleType.LONG;
        AMQQueueMBean._msgAttributeTypes[3] = SimpleType.BOOLEAN;
        AMQQueueMBean._msgAttributeTypes[4] = SimpleType.LONG;
        _messageDataType = new CompositeType("Message", "AMQ Message", VIEW_MSGS_COMPOSITE_ITEM_NAMES_DESC.toArray(new String[VIEW_MSGS_COMPOSITE_ITEM_NAMES_DESC.size()]), VIEW_MSGS_COMPOSITE_ITEM_NAMES_DESC.toArray(new String[VIEW_MSGS_COMPOSITE_ITEM_NAMES_DESC.size()]), _msgAttributeTypes);
        _messagelistDataType = new TabularType("Messages", "List of messages", _messageDataType, VIEW_MSGS_TABULAR_UNIQUE_INDEX.toArray(new String[VIEW_MSGS_TABULAR_UNIQUE_INDEX.size()]));
    }

    @Override
    public String getObjectInstanceName() {
        return ObjectName.quote(this._queueName);
    }

    @Override
    public String getName() {
        return this._queueName;
    }

    @Override
    public boolean isDurable() {
        return this._queue.isDurable();
    }

    @Override
    public String getOwner() {
        return String.valueOf(this._queue.getOwner());
    }

    @Override
    public boolean isAutoDelete() {
        return this._queue.isAutoDelete();
    }

    @Override
    public Integer getMessageCount() {
        return this._queue.getMessageCount();
    }

    @Override
    public Long getMaximumMessageSize() {
        return this._queue.getMaximumMessageSize();
    }

    @Override
    public Long getMaximumMessageAge() {
        return this._queue.getMaximumMessageAge();
    }

    @Override
    public void setMaximumMessageAge(Long maximumMessageAge) {
        this._queue.setMaximumMessageAge(maximumMessageAge);
    }

    @Override
    public void setMaximumMessageSize(Long value) {
        this._queue.setMaximumMessageSize(value);
    }

    @Override
    public Integer getConsumerCount() {
        return this._queue.getConsumerCount();
    }

    @Override
    public Integer getActiveConsumerCount() {
        return this._queue.getActiveConsumerCount();
    }

    @Override
    public Long getReceivedMessageCount() {
        return this._queue.getReceivedMessageCount();
    }

    @Override
    public Long getMaximumMessageCount() {
        return this._queue.getMaximumMessageCount();
    }

    @Override
    public void setMaximumMessageCount(Long value) {
        this._queue.setMaximumMessageCount(value);
    }

    @Override
    public Long getMaximumQueueDepth() {
        return this._queue.getMaximumQueueDepth();
    }

    @Override
    public void setMaximumQueueDepth(Long value) {
        this._queue.setMaximumQueueDepth(value);
    }

    @Override
    public Long getQueueDepth() throws JMException {
        return this._queue.getQueueDepth();
    }

    @Override
    public Long getCapacity() {
        return this._queue.getCapacity();
    }

    @Override
    public void setCapacity(Long capacity) throws IllegalArgumentException {
        if (this._queue.getFlowResumeCapacity() > capacity) {
            throw new IllegalArgumentException("Capacity must not be less than FlowResumeCapacity");
        }
        this._queue.setCapacity(capacity);
    }

    @Override
    public Long getFlowResumeCapacity() {
        return this._queue.getFlowResumeCapacity();
    }

    @Override
    public void setFlowResumeCapacity(Long flowResumeCapacity) throws IllegalArgumentException {
        if (this._queue.getCapacity() < flowResumeCapacity) {
            throw new IllegalArgumentException("FlowResumeCapacity must not exceed Capacity");
        }
        this._queue.setFlowResumeCapacity(flowResumeCapacity);
    }

    @Override
    public boolean isFlowOverfull() {
        return this._queue.isOverfull();
    }

    @Override
    public boolean isExclusive() {
        return this._queue.isExclusive();
    }

    @Override
    public void setExclusive(boolean exclusive) throws JMException {
        try {
            this._queue.setExclusive(exclusive);
        }
        catch (AMQException e) {
            throw new JMException(e.toString());
        }
    }

    public void checkForNotification(ServerMessage msg) throws AMQException {
        Set<NotificationCheck> notificationChecks = this._queue.getNotificationChecks();
        if (!notificationChecks.isEmpty()) {
            long currentTime = System.currentTimeMillis();
            long thresholdTime = currentTime - this._queue.getMinimumAlertRepeatGap();
            for (NotificationCheck check : notificationChecks) {
                if (!check.isMessageSpecific() && this._lastNotificationTimes[check.ordinal()] >= thresholdTime || !check.notifyIfNecessary(msg, this._queue, this)) continue;
                this._lastNotificationTimes[check.ordinal()] = currentTime;
            }
        }
    }

    @Override
    public void notifyClients(NotificationCheck notification, AMQQueue queue, String notificationMsg) {
        _logger.info((Object)(notification.name() + " On Queue " + queue.getNameShortString() + " - " + notificationMsg));
        notificationMsg = notification.name() + " " + notificationMsg;
        this._lastNotification = new Notification("jmx.monitor.counter.threshold", this, ++this._notificationSequenceNumber, System.currentTimeMillis(), notificationMsg);
        this._broadcaster.sendNotification(this._lastNotification);
    }

    public Notification getLastNotification() {
        return this._lastNotification;
    }

    @Override
    public void deleteMessageFromTop() throws JMException {
        this._queue.deleteMessageFromTop();
    }

    @Override
    public Long clearQueue() throws JMException {
        try {
            return this._queue.clearQueue();
        }
        catch (AMQException ex) {
            throw new MBeanException(ex, "Error clearing queue " + this._queueName);
        }
    }

    @Override
    public CompositeData viewMessageContent(long msgId) throws JMException {
        QueueEntry entry = this._queue.getMessageOnTheQueue(msgId);
        if (entry == null) {
            throw new OperationsException("AMQMessage with message id = " + msgId + " is not in the " + this._queueName);
        }
        ServerMessage serverMsg = entry.getMessage();
        int bodySize = (int)serverMsg.getSize();
        ArrayList<Byte> msgContent = new ArrayList<Byte>();
        ByteBuffer buf = ByteBuffer.allocate(bodySize);
        int position = 0;
        while (position < bodySize) {
            position += serverMsg.getContent(buf, position);
            buf.flip();
            for (int i = 0; i < buf.limit(); ++i) {
                msgContent.add(buf.get(i));
            }
            buf.clear();
        }
        AMQMessageHeader header = serverMsg.getMessageHeader();
        String mimeType = null;
        String encoding = null;
        if (header != null) {
            mimeType = header.getMimeType();
            encoding = header.getEncoding();
        }
        Object[] itemValues = new Object[]{msgId, mimeType, encoding, msgContent.toArray(new Byte[0])};
        return new CompositeDataSupport(_msgContentType, VIEW_MSG_CONTENT_COMPOSITE_ITEM_NAMES_DESC.toArray(new String[VIEW_MSG_CONTENT_COMPOSITE_ITEM_NAMES_DESC.size()]), itemValues);
    }

    @Override
    @Deprecated
    public TabularData viewMessages(int beginIndex, int endIndex) throws JMException {
        return this.viewMessages((long)beginIndex, (long)endIndex);
    }

    @Override
    public TabularData viewMessages(long startPosition, long endPosition) throws JMException {
        if (startPosition > endPosition || startPosition < 1L) {
            throw new OperationsException("From Index = " + startPosition + ", To Index = " + endPosition + "\n\"From Index\" should be greater than 0 and less than \"To Index\"");
        }
        if (endPosition - startPosition > Integer.MAX_VALUE) {
            throw new OperationsException("Specified MessageID interval is too large. Intervals must be less than 2^31 in size");
        }
        List<QueueEntry> list = this._queue.getMessagesRangeOnTheQueue(startPosition, endPosition);
        TabularDataSupport _messageList = new TabularDataSupport(_messagelistDataType);
        try {
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                ServerMessage msg;
                long position = startPosition + (long)i;
                QueueEntry queueEntry = list.get(i);
                ServerMessage serverMsg = queueEntry.getMessage();
                String[] headerAttributes = null;
                Object[] itemValues = null;
                if (serverMsg instanceof AMQMessage) {
                    msg = (AMQMessage)serverMsg;
                    ContentHeaderBody headerBody = ((AMQMessage)msg).getContentHeaderBody();
                    headerAttributes = this.getMessageHeaderProperties(headerBody);
                    itemValues = new Object[]{((AMQMessage)msg).getMessageId(), headerAttributes, headerBody.bodySize, queueEntry.isRedelivered(), position};
                } else if (serverMsg instanceof MessageTransferMessage) {
                    msg = (MessageTransferMessage)serverMsg;
                    headerAttributes = this.getMessageTransferMessageHeaderProps((MessageTransferMessage)msg);
                    itemValues = new Object[]{((MessageTransferMessage)msg).getMessageNumber(), headerAttributes, ((MessageTransferMessage)msg).getSize(), queueEntry.isRedelivered(), position};
                } else {
                    headerAttributes = new String[]{"N/A"};
                    itemValues = new Object[]{serverMsg.getMessageNumber(), headerAttributes, serverMsg.getSize(), queueEntry.isRedelivered(), position};
                }
                CompositeDataSupport messageData = new CompositeDataSupport(_messageDataType, VIEW_MSGS_COMPOSITE_ITEM_NAMES_DESC.toArray(new String[VIEW_MSGS_COMPOSITE_ITEM_NAMES_DESC.size()]), itemValues);
                _messageList.put(messageData);
            }
        }
        catch (AMQException e) {
            JMException jme = new JMException("Error creating message contents: " + e);
            jme.initCause(e);
            throw jme;
        }
        return _messageList;
    }

    private String[] getMessageHeaderProperties(ContentHeaderBody headerBody) {
        ArrayList<String> list = new ArrayList<String>();
        BasicContentHeaderProperties headerProperties = (BasicContentHeaderProperties)headerBody.getProperties();
        list.add("reply-to = " + headerProperties.getReplyToAsString());
        list.add("propertyFlags = " + headerProperties.getPropertyFlags());
        list.add("ApplicationID = " + headerProperties.getAppIdAsString());
        list.add("ClusterID = " + headerProperties.getClusterIdAsString());
        list.add("UserId = " + headerProperties.getUserIdAsString());
        list.add("JMSMessageID = " + headerProperties.getMessageIdAsString());
        list.add("JMSCorrelationID = " + headerProperties.getCorrelationIdAsString());
        byte delMode = headerProperties.getDeliveryMode();
        list.add("JMSDeliveryMode = " + (delMode == 2 ? "Persistent" : "Non_Persistent"));
        list.add("JMSPriority = " + headerProperties.getPriority());
        list.add("JMSType = " + headerProperties.getType());
        long longDate = headerProperties.getExpiration();
        String strDate = longDate != 0L ? _dateFormat.format(new Date(longDate)) : null;
        list.add("JMSExpiration = " + strDate);
        longDate = headerProperties.getTimestamp();
        strDate = longDate != 0L ? _dateFormat.format(new Date(longDate)) : null;
        list.add("JMSTimestamp = " + strDate);
        return list.toArray(new String[list.size()]);
    }

    private String[] getMessageTransferMessageHeaderProps(MessageTransferMessage msg) {
        ArrayList<String> list = new ArrayList<String>();
        AMQMessageHeader header = msg.getMessageHeader();
        MessageProperties msgProps = msg.getHeader().get(MessageProperties.class);
        String appID = null;
        String userID = null;
        if (msgProps != null) {
            appID = msgProps.getAppId() == null ? "null" : new String(msgProps.getAppId());
            userID = msgProps.getUserId() == null ? "null" : new String(msgProps.getUserId());
        }
        list.add("reply-to = " + header.getReplyTo());
        list.add("propertyFlags = ");
        list.add("ApplicationID = " + appID);
        list.add("ClusterID = ");
        list.add("UserId = " + userID);
        list.add("JMSMessageID = " + header.getMessageId());
        list.add("JMSCorrelationID = " + header.getCorrelationId());
        list.add("JMSDeliveryMode = " + (msg.isPersistent() ? "Persistent" : "Non_Persistent"));
        list.add("JMSPriority = " + header.getPriority());
        list.add("JMSType = " + header.getType());
        long longDate = header.getExpiration();
        String strDate = longDate != 0L ? _dateFormat.format(new Date(longDate)) : null;
        list.add("JMSExpiration = " + strDate);
        longDate = header.getTimestamp();
        strDate = longDate != 0L ? _dateFormat.format(new Date(longDate)) : null;
        list.add("JMSTimestamp = " + strDate);
        return list.toArray(new String[list.size()]);
    }

    @Override
    public void moveMessages(long fromMessageId, long toMessageId, String toQueueName) throws JMException {
        if (fromMessageId > toMessageId || fromMessageId < 1L) {
            throw new OperationsException("\"From MessageId\" should be greater than 0 and less than \"To MessageId\"");
        }
        LocalTransaction txn = new LocalTransaction(this._queue.getVirtualHost().getTransactionLog());
        this._queue.moveMessagesToAnotherQueue(fromMessageId, toMessageId, toQueueName, txn);
        txn.commit();
    }

    @Override
    public void deleteMessages(long fromMessageId, long toMessageId) throws JMException {
        if (fromMessageId > toMessageId || fromMessageId < 1L) {
            throw new OperationsException("\"From MessageId\" should be greater than 0 and less than \"To MessageId\"");
        }
        this._queue.removeMessagesFromQueue(fromMessageId, toMessageId);
    }

    @Override
    public void copyMessages(long fromMessageId, long toMessageId, String toQueueName) throws JMException {
        if (fromMessageId > toMessageId || fromMessageId < 1L) {
            throw new OperationsException("\"From MessageId\" should be greater than 0 and less than \"To MessageId\"");
        }
        LocalTransaction txn = new LocalTransaction(this._queue.getVirtualHost().getTransactionLog());
        this._queue.copyMessagesToAnotherQueue(fromMessageId, toMessageId, toQueueName, txn);
        txn.commit();
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        String[] notificationTypes = new String[]{"jmx.monitor.counter.threshold"};
        String name = MonitorNotification.class.getName();
        String description = "Either Message count or Queue depth or Message size has reached threshold high value";
        MBeanNotificationInfo info1 = new MBeanNotificationInfo(notificationTypes, name, description);
        return new MBeanNotificationInfo[]{info1};
    }

    static {
        try {
            AMQQueueMBean.init();
        }
        catch (JMException ex) {
            throw new RuntimeException("Got JMException in static initializer.", ex);
        }
    }
}

