/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.queue;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.wso2.andes.AMQException;
import org.wso2.andes.configuration.qpid.QueueConfig;
import org.wso2.andes.configuration.qpid.plugins.ConfigurationPlugin;
import org.wso2.andes.framing.AMQShortString;
import org.wso2.andes.server.AMQChannel;
import org.wso2.andes.server.binding.Binding;
import org.wso2.andes.server.exchange.Exchange;
import org.wso2.andes.server.exchange.ExchangeReferrer;
import org.wso2.andes.server.logging.LogSubject;
import org.wso2.andes.server.management.Managable;
import org.wso2.andes.server.management.ManagedObject;
import org.wso2.andes.server.protocol.AMQSessionModel;
import org.wso2.andes.server.queue.BaseQueue;
import org.wso2.andes.server.queue.NotificationCheck;
import org.wso2.andes.server.queue.QueueEntry;
import org.wso2.andes.server.security.AuthorizationHolder;
import org.wso2.andes.server.store.TransactionLogResource;
import org.wso2.andes.server.subscription.Subscription;
import org.wso2.andes.server.txn.ServerTransaction;
import org.wso2.andes.server.virtualhost.VirtualHost;

public interface AMQQueue
extends Managable,
Comparable<AMQQueue>,
ExchangeReferrer,
TransactionLogResource,
BaseQueue,
QueueConfig {
    public boolean getDeleteOnNoConsumers();

    public void setDeleteOnNoConsumers(boolean var1);

    public void addBinding(Binding var1);

    public void removeBinding(Binding var1);

    public List<Binding> getBindings();

    @Override
    public int getBindingCount();

    public LogSubject getLogSubject();

    public void remoteDelete() throws AMQException;

    public void setNoLocal(boolean var1);

    @Override
    public boolean isAutoDelete();

    public AMQShortString getOwner();

    public AuthorizationHolder getAuthorizationHolder();

    public void setAuthorizationHolder(AuthorizationHolder var1);

    public void setExclusiveOwningSession(AMQSessionModel var1);

    public AMQSessionModel getExclusiveOwningSession();

    @Override
    public VirtualHost getVirtualHost();

    public void registerSubscription(Subscription var1, boolean var2) throws AMQException;

    public void unregisterSubscription(Subscription var1) throws AMQException;

    @Override
    public int getConsumerCount();

    public int getActiveConsumerCount();

    public boolean hasExclusiveSubscriber();

    public boolean isUnused();

    public boolean isEmpty();

    @Override
    public int getMessageCount();

    public int getUndeliveredMessageCount();

    @Override
    public long getQueueDepth();

    @Override
    public long getReceivedMessageCount();

    public long getOldestMessageArrivalTime();

    public boolean isDeleted();

    public boolean checkIfBoundToTopicExchange();

    public int delete() throws AMQException;

    public void requeue(QueueEntry var1);

    public void dequeue(QueueEntry var1, Subscription var2);

    public void decrementUnackedMsgCount();

    public boolean resend(QueueEntry var1, Subscription var2) throws AMQException;

    public void addQueueDeleteTask(Task var1);

    public void removeQueueDeleteTask(Task var1);

    public List<QueueEntry> getMessagesOnTheQueue();

    public List<QueueEntry> getMessagesOnTheQueue(long var1, long var3);

    public List<Long> getMessagesOnTheQueue(int var1);

    public List<Long> getMessagesOnTheQueue(int var1, int var2);

    public QueueEntry getMessageOnTheQueue(long var1);

    public List<QueueEntry> getMessagesRangeOnTheQueue(long var1, long var3);

    public void moveMessagesToAnotherQueue(long var1, long var3, String var5, ServerTransaction var6);

    public void copyMessagesToAnotherQueue(long var1, long var3, String var5, ServerTransaction var6);

    public void removeMessagesFromQueue(long var1, long var3);

    public long getMaximumMessageSize();

    public void setMaximumMessageSize(long var1);

    public long getMaximumMessageCount();

    public void setMaximumMessageCount(long var1);

    public long getMaximumQueueDepth();

    public void setMaximumQueueDepth(long var1);

    public long getMaximumMessageAge();

    public void setMaximumMessageAge(long var1);

    public long getMinimumAlertRepeatGap();

    public void setMinimumAlertRepeatGap(long var1);

    public long getCapacity();

    public void setCapacity(long var1);

    public long getFlowResumeCapacity();

    public void setFlowResumeCapacity(long var1);

    public boolean isOverfull();

    public void deleteMessageFromTop();

    public long clearQueue() throws AMQException;

    public void checkMessageStatus() throws AMQException;

    public Set<NotificationCheck> getNotificationChecks();

    public void flushSubscription(Subscription var1) throws AMQException;

    public void deliverAsync(Subscription var1);

    public void deliverAsync();

    public void stop();

    @Override
    public boolean isExclusive();

    @Override
    public Exchange getAlternateExchange();

    public void setAlternateExchange(Exchange var1);

    @Override
    public Map<String, Object> getArguments();

    public void checkCapacity(AMQChannel var1);

    public void configure(ConfigurationPlugin var1);

    public ConfigurationPlugin getConfiguration();

    @Override
    public ManagedObject getManagedObject();

    public void setExclusive(boolean var1) throws AMQException;

    public static interface Task {
        public void doTask(AMQQueue var1) throws AMQException;
    }

    public static final class ExistingSubscriptionPreventsExclusive
    extends AMQException {
        public ExistingSubscriptionPreventsExclusive() {
            super("");
        }
    }

    public static final class ExistingExclusiveSubscription
    extends AMQException {
        public ExistingExclusiveSubscription() {
            super("");
        }
    }

    public static interface Context {
        public QueueEntry getLastSeenEntry();
    }
}

