/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.protocol;

import java.net.SocketAddress;
import java.util.UUID;
import org.wso2.andes.configuration.qpid.ConfigStore;
import org.wso2.andes.configuration.qpid.ConfiguredObject;
import org.wso2.andes.configuration.qpid.ConnectionConfig;
import org.wso2.andes.configuration.qpid.ConnectionConfigType;
import org.wso2.andes.configuration.qpid.VirtualHostConfig;
import org.wso2.andes.protocol.ProtocolEngine;
import org.wso2.andes.server.logging.messages.ConnectionMessages;
import org.wso2.andes.server.registry.IApplicationRegistry;
import org.wso2.andes.server.transport.ServerConnection;
import org.wso2.andes.transport.network.Assembler;
import org.wso2.andes.transport.network.Disassembler;
import org.wso2.andes.transport.network.InputHandler;
import org.wso2.andes.transport.network.NetworkConnection;

public class ProtocolEngine_0_10
extends InputHandler
implements ProtocolEngine,
ConnectionConfig {
    public static final int MAX_FRAME_SIZE = 65535;
    private NetworkConnection _network;
    private long _readBytes;
    private long _writtenBytes;
    private ServerConnection _connection;
    private final UUID _id;
    private final IApplicationRegistry _appRegistry;
    private long _createTime = System.currentTimeMillis();

    public ProtocolEngine_0_10(ServerConnection conn, NetworkConnection network, IApplicationRegistry appRegistry) {
        super(new Assembler(conn));
        this._connection = conn;
        this._connection.setConnectionConfig(this);
        this._network = network;
        this._id = appRegistry.getConfigStore().createId();
        this._appRegistry = appRegistry;
        this._connection.setSender(new Disassembler(this._network.getSender(), 65535));
        this._connection.onOpen(new Runnable(){

            @Override
            public void run() {
                ProtocolEngine_0_10.this.getConfigStore().addConfiguredObject(ProtocolEngine_0_10.this);
            }
        });
        this._connection.getLogActor().message(ConnectionMessages.OPEN(null, null, false, false));
        this._connection.getLogActor().message(ConnectionMessages.OPEN(null, "0-10", false, true));
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this._network.getRemoteAddress();
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this._network.getLocalAddress();
    }

    @Override
    public long getReadBytes() {
        return this._readBytes;
    }

    @Override
    public long getWrittenBytes() {
        return this._writtenBytes;
    }

    @Override
    public void writerIdle() {
    }

    @Override
    public void readerIdle() {
    }

    @Override
    public VirtualHostConfig getVirtualHost() {
        return this._connection.getVirtualHost();
    }

    @Override
    public String getAddress() {
        return this.getRemoteAddress().toString();
    }

    @Override
    public Boolean isIncoming() {
        return true;
    }

    @Override
    public Boolean isSystemConnection() {
        return false;
    }

    @Override
    public Boolean isFederationLink() {
        return false;
    }

    @Override
    public String getAuthId() {
        return this._connection.getAuthorizedPrincipal() == null ? null : this._connection.getAuthorizedPrincipal().getName();
    }

    @Override
    public String getRemoteProcessName() {
        return null;
    }

    @Override
    public Integer getRemotePID() {
        return null;
    }

    @Override
    public Integer getRemoteParentPID() {
        return null;
    }

    @Override
    public ConfigStore getConfigStore() {
        return this._appRegistry.getConfigStore();
    }

    @Override
    public UUID getId() {
        return this._id;
    }

    @Override
    public ConnectionConfigType getConfigType() {
        return ConnectionConfigType.getInstance();
    }

    @Override
    public ConfiguredObject getParent() {
        return this.getVirtualHost();
    }

    @Override
    public boolean isDurable() {
        return false;
    }

    @Override
    public void closed() {
        super.closed();
        this.getConfigStore().removeConfiguredObject(this);
    }

    @Override
    public long getCreateTime() {
        return this._createTime;
    }

    @Override
    public Boolean isShadow() {
        return false;
    }

    @Override
    public void mgmtClose() {
        this._connection.mgmtClose();
    }
}

