/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.plugins;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.felix.framework.Felix;
import org.apache.felix.framework.util.StringMap;
import org.apache.felix.main.AutoProcessor;
import org.apache.log4j.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.launch.Framework;
import org.osgi.util.tracker.ServiceTracker;
import org.wso2.andes.common.Closeable;
import org.wso2.andes.configuration.qpid.TopicConfiguration;
import org.wso2.andes.configuration.qpid.plugins.ConfigurationPluginFactory;
import org.wso2.andes.configuration.qpid.plugins.SlowConsumerDetectionConfiguration;
import org.wso2.andes.configuration.qpid.plugins.SlowConsumerDetectionPolicyConfiguration;
import org.wso2.andes.configuration.qpid.plugins.SlowConsumerDetectionQueueConfiguration;
import org.wso2.andes.policies.SlowConsumerPolicyPluginFactory;
import org.wso2.andes.server.exchange.ExchangeType;
import org.wso2.andes.server.plugins.Activator;
import org.wso2.andes.server.plugins.Plugin;
import org.wso2.andes.server.plugins.PluginFactory;
import org.wso2.andes.server.security.SecurityManager;
import org.wso2.andes.server.security.SecurityPluginFactory;
import org.wso2.andes.server.security.access.plugins.AllowAll;
import org.wso2.andes.server.security.access.plugins.DenyAll;
import org.wso2.andes.server.security.access.plugins.LegacyAccess;
import org.wso2.andes.server.security.auth.manager.AuthenticationManagerPluginFactory;
import org.wso2.andes.server.security.auth.manager.PrincipalDatabaseAuthenticationManager;
import org.wso2.andes.server.virtualhost.plugins.SlowConsumerDetection;
import org.wso2.andes.server.virtualhost.plugins.VirtualHostPluginFactory;
import org.wso2.andes.server.virtualhost.plugins.policies.TopicDeletePolicy;

public class PluginManager
implements Closeable {
    private static final Logger _logger = Logger.getLogger(PluginManager.class);
    private static final int FELIX_STOP_TIMEOUT = 30000;
    private static final String QPID_VER_SUFFIX = "version=0.13,";
    private static BundleContext _bundleContext = null;
    private Framework _felix;
    private ServiceTracker _exchangeTracker = null;
    private ServiceTracker _securityTracker = null;
    private ServiceTracker _configTracker = null;
    private ServiceTracker _virtualHostTracker = null;
    private ServiceTracker _policyTracker = null;
    private ServiceTracker _authenticationManagerTracker = null;
    private Activator _activator;
    private Map<String, SecurityPluginFactory> _securityPlugins = new HashMap<String, SecurityPluginFactory>();
    private Map<List<String>, ConfigurationPluginFactory> _configPlugins = new IdentityHashMap<List<String>, ConfigurationPluginFactory>();
    private Map<String, VirtualHostPluginFactory> _vhostPlugins = new HashMap<String, VirtualHostPluginFactory>();
    private Map<String, SlowConsumerPolicyPluginFactory> _policyPlugins = new HashMap<String, SlowConsumerPolicyPluginFactory>();
    private Map<String, AuthenticationManagerPluginFactory<? extends Plugin>> _authenticationManagerPlugins = new HashMap<String, AuthenticationManagerPluginFactory<? extends Plugin>>();

    public PluginManager(String pluginPath, String cachePath) throws Exception {
        for (SecurityPluginFactory securityPluginFactory : Arrays.asList(AllowAll.FACTORY, DenyAll.FACTORY, LegacyAccess.FACTORY)) {
            this._securityPlugins.put(securityPluginFactory.getPluginName(), securityPluginFactory);
        }
        for (ConfigurationPluginFactory configurationPluginFactory : Arrays.asList(TopicConfiguration.FACTORY, SecurityManager.SecurityConfiguration.FACTORY, AllowAll.AllowAllConfiguration.FACTORY, DenyAll.DenyAllConfiguration.FACTORY, LegacyAccess.LegacyAccessConfiguration.FACTORY, new SlowConsumerDetectionConfiguration.SlowConsumerDetectionConfigurationFactory(), new SlowConsumerDetectionPolicyConfiguration.SlowConsumerDetectionPolicyConfigurationFactory(), new SlowConsumerDetectionQueueConfiguration.SlowConsumerDetectionQueueConfigurationFactory(), PrincipalDatabaseAuthenticationManager.PrincipalDatabaseAuthenticationManagerConfiguration.FACTORY)) {
            this._configPlugins.put(configurationPluginFactory.getParentPaths(), configurationPluginFactory);
        }
        for (SlowConsumerPolicyPluginFactory slowConsumerPolicyPluginFactory : Arrays.asList(new TopicDeletePolicy.TopicDeletePolicyFactory())) {
            this._policyPlugins.put(slowConsumerPolicyPluginFactory.getPluginName(), slowConsumerPolicyPluginFactory);
        }
        for (VirtualHostPluginFactory virtualHostPluginFactory : Arrays.asList(new SlowConsumerDetection.SlowConsumerFactory())) {
            this._vhostPlugins.put(virtualHostPluginFactory.getClass().getName(), virtualHostPluginFactory);
        }
        for (AuthenticationManagerPluginFactory authenticationManagerPluginFactory : Arrays.asList(PrincipalDatabaseAuthenticationManager.FACTORY)) {
            this._authenticationManagerPlugins.put(authenticationManagerPluginFactory.getPluginName(), authenticationManagerPluginFactory);
        }
        if (_bundleContext == null) {
            if (pluginPath == null) {
                return;
            }
            File pluginDir = new File(pluginPath);
            if (!pluginDir.exists()) {
                return;
            }
            StringMap stringMap = new StringMap(false);
            stringMap.put((Object)"org.osgi.framework.system.packages", (Object)"org.osgi.framework; version=1.3.0,org.osgi.service.packageadmin; version=1.2.0,org.osgi.service.startlevel; version=1.0.0,org.osgi.service.url; version=1.0.0,org.osgi.util.tracker; version=1.0.0,org.wso2.andes.junit.extensions.util; version=0.13,org.wso2.andes; version=0.13,org.wso2.andes.common; version=0.13,org.wso2.andes.exchange; version=0.13,org.wso2.andes.framing; version=0.13,org.wso2.andes.management.common.mbeans.annotations; version=0.13,org.wso2.andes.protocol; version=0.13,org.wso2.andes.server.binding; version=0.13,org.wso2.andes.configuration.qpid; version=0.13,org.wso2.andes.configuration.qpid.plugins; version=0.13,org.wso2.andes.configuration.qpid.management; version=0.13,org.wso2.andes.server.exchange; version=0.13,org.wso2.andes.server.logging; version=0.13,org.wso2.andes.server.logging.actors; version=0.13,org.wso2.andes.server.logging.subjects; version=0.13,org.wso2.andes.server.management; version=0.13,org.wso2.andes.server.persistent; version=0.13,org.wso2.andes.server.plugins; version=0.13,org.wso2.andes.server.protocol; version=0.13,org.wso2.andes.server.queue; version=0.13,org.wso2.andes.server.registry; version=0.13,org.wso2.andes.server.security; version=0.13,org.wso2.andes.server.security.access; version=0.13,org.wso2.andes.server.security.access.plugins; version=0.13,org.wso2.andes.server.virtualhost; version=0.13,org.wso2.andes.server.virtualhost.plugins; version=0.13,org.wso2.andes.util; version=0.13,org.apache.commons.configuration; version=1.0.0,org.apache.commons.lang; version=1.0.0,org.apache.commons.lang.builder; version=1.0.0,org.apache.commons.logging; version=1.0.0,org.apache.log4j; version=1.2.12,javax.management.openmbean; version=1.0.0,javax.management; version=1.0.0,javax.security.auth; version=1.0.0");
            stringMap.put((Object)"felix.shutdown.hook", (Object)"false");
            ArrayList<Activator> activators = new ArrayList<Activator>();
            this._activator = new Activator();
            activators.add(this._activator);
            stringMap.put((Object)"felix.systembundle.activators", activators);
            if (cachePath != null) {
                File cacheDir = new File(cachePath);
                if (!cacheDir.exists() && cacheDir.canWrite()) {
                    _logger.info((Object)("Creating plugin cache directory: " + cachePath));
                    cacheDir.mkdir();
                }
                _logger.info((Object)("Cache bundles in directory " + cachePath));
                stringMap.put((Object)"org.osgi.framework.storage", (Object)cachePath);
            }
            stringMap.put((Object)"org.osgi.framework.storage.clean", (Object)"onFirstInit");
            _logger.info((Object)("Auto deploying bundles from directory " + pluginPath));
            stringMap.put((Object)"felix.auto.deploy.dir", (Object)pluginPath);
            stringMap.put((Object)"felix.auto.deploy.action", (Object)"install,start");
            this._felix = new Felix((Map)stringMap);
            try {
                _logger.info((Object)"Starting plugin manager...");
                this._felix.init();
                AutoProcessor.process((Map)stringMap, (BundleContext)this._felix.getBundleContext());
                this._felix.start();
                _logger.info((Object)"Started plugin manager");
            }
            catch (BundleException e) {
                throw new ConfigurationException("Could not start plugin manager: " + e.getMessage(), e);
            }
            _bundleContext = this._activator.getContext();
        }
        this._exchangeTracker = new ServiceTracker(_bundleContext, ExchangeType.class.getName(), null);
        this._exchangeTracker.open();
        this._securityTracker = new ServiceTracker(_bundleContext, SecurityPluginFactory.class.getName(), null);
        this._securityTracker.open();
        this._configTracker = new ServiceTracker(_bundleContext, ConfigurationPluginFactory.class.getName(), null);
        this._configTracker.open();
        this._virtualHostTracker = new ServiceTracker(_bundleContext, VirtualHostPluginFactory.class.getName(), null);
        this._virtualHostTracker.open();
        this._policyTracker = new ServiceTracker(_bundleContext, SlowConsumerPolicyPluginFactory.class.getName(), null);
        this._policyTracker.open();
        this._authenticationManagerTracker = new ServiceTracker(_bundleContext, AuthenticationManagerPluginFactory.class.getName(), null);
        this._authenticationManagerTracker.open();
        _logger.info((Object)"Opened service trackers");
    }

    public static void setBundleContext(BundleContext ctx) {
        _bundleContext = ctx;
    }

    private static <T> Map<String, T> getServices(ServiceTracker tracker) {
        HashMap<String, Object> services = new HashMap<String, Object>();
        if (tracker != null && tracker.getServices() != null) {
            for (Object service : tracker.getServices()) {
                if (service instanceof PluginFactory) {
                    services.put(((PluginFactory)service).getPluginName(), service);
                    continue;
                }
                services.put(service.getClass().getName(), service);
            }
        }
        return services;
    }

    public static <T> Map<String, T> getServices(ServiceTracker tracker, Map<String, T> plugins) {
        Map<String, T> services = PluginManager.getServices(tracker);
        services.putAll(plugins);
        return services;
    }

    public Map<List<String>, ConfigurationPluginFactory> getConfigurationPlugins() {
        IdentityHashMap<List<String>, ConfigurationPluginFactory> services = new IdentityHashMap<List<String>, ConfigurationPluginFactory>();
        if (this._configTracker != null && this._configTracker.getServices() != null) {
            for (Object service : this._configTracker.getServices()) {
                ConfigurationPluginFactory factory = (ConfigurationPluginFactory)service;
                services.put(factory.getParentPaths(), factory);
            }
        }
        services.putAll(this._configPlugins);
        return services;
    }

    public Map<String, VirtualHostPluginFactory> getVirtualHostPlugins() {
        return PluginManager.getServices(this._virtualHostTracker, this._vhostPlugins);
    }

    public Map<String, SlowConsumerPolicyPluginFactory> getSlowConsumerPlugins() {
        return PluginManager.getServices(this._policyTracker, this._policyPlugins);
    }

    public Map<String, ExchangeType<?>> getExchanges() {
        return PluginManager.getServices(this._exchangeTracker);
    }

    public Map<String, SecurityPluginFactory> getSecurityPlugins() {
        return PluginManager.getServices(this._securityTracker, this._securityPlugins);
    }

    public Map<String, AuthenticationManagerPluginFactory<? extends Plugin>> getAuthenticationManagerPlugins() {
        return PluginManager.getServices(this._authenticationManagerTracker, this._authenticationManagerPlugins);
    }

    @Override
    public void close() {
        if (this._felix != null) {
            try {
                this._exchangeTracker.close();
                this._securityTracker.close();
                this._configTracker.close();
                this._virtualHostTracker.close();
                this._policyTracker.close();
                this._authenticationManagerTracker.close();
            }
            finally {
                _logger.info((Object)"Stopping plugin manager");
                try {
                    this._felix.stop();
                }
                catch (BundleException bundleException) {}
                try {
                    this._felix.waitForStop(30000L);
                }
                catch (InterruptedException interruptedException) {}
                _logger.info((Object)"Stopped plugin manager");
            }
        }
    }
}

