/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.output;

import java.util.HashMap;
import java.util.Map;
import org.wso2.andes.framing.ProtocolVersion;
import org.wso2.andes.server.output.ProtocolOutputConverter;
import org.wso2.andes.server.output.amqp0_9_1.ProtocolOutputConverterImpl;
import org.wso2.andes.server.protocol.AMQProtocolSession;

public class ProtocolOutputConverterRegistry {
    private static final Map<ProtocolVersion, ProtocolOutputConverter.Factory> _registry = new HashMap<ProtocolVersion, ProtocolOutputConverter.Factory>();

    private static void register(ProtocolVersion version, ProtocolOutputConverter.Factory converter) {
        _registry.put(version, converter);
    }

    public static ProtocolOutputConverter getConverter(AMQProtocolSession session) {
        return _registry.get(session.getProtocolVersion()).newInstance(session);
    }

    static {
        ProtocolOutputConverterRegistry.register(ProtocolVersion.v8_0, org.wso2.andes.server.output.amqp0_8.ProtocolOutputConverterImpl.getInstanceFactory());
        ProtocolOutputConverterRegistry.register(ProtocolVersion.v0_9, org.wso2.andes.server.output.amqp0_9.ProtocolOutputConverterImpl.getInstanceFactory());
        ProtocolOutputConverterRegistry.register(ProtocolVersion.v0_91, ProtocolOutputConverterImpl.getInstanceFactory());
    }
}

