/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.message;

import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import org.wso2.andes.configuration.qpid.SessionConfig;
import org.wso2.andes.server.message.AMQMessageHeader;
import org.wso2.andes.server.message.InboundMessage;
import org.wso2.andes.server.message.MessageMetaData_0_10;
import org.wso2.andes.server.message.MessageReference;
import org.wso2.andes.server.message.ServerMessage;
import org.wso2.andes.server.message.TransferMessageReference;
import org.wso2.andes.server.store.StoredMessage;
import org.wso2.andes.server.transport.ServerSession;
import org.wso2.andes.transport.Header;
import org.wso2.andes.transport.Session;

public class MessageTransferMessage
implements InboundMessage,
ServerMessage {
    private StoredMessage<MessageMetaData_0_10> _storeMessage;
    private WeakReference<Session> _sessionRef;

    public MessageTransferMessage(StoredMessage<MessageMetaData_0_10> storeMessage, WeakReference<Session> sessionRef) {
        this._storeMessage = storeMessage;
        this._sessionRef = sessionRef;
    }

    private MessageMetaData_0_10 getMetaData() {
        return this._storeMessage.getMetaData();
    }

    @Override
    public String getRoutingKey() {
        return this.getMetaData().getRoutingKey();
    }

    @Override
    public AMQMessageHeader getMessageHeader() {
        return this.getMetaData().getMessageHeader();
    }

    @Override
    public boolean isPersistent() {
        return this.getMetaData().isPersistent();
    }

    @Override
    public boolean isRedelivered() {
        return false;
    }

    @Override
    public long getSize() {
        return this.getMetaData().getSize();
    }

    @Override
    public boolean isImmediate() {
        return this.getMetaData().isImmediate();
    }

    @Override
    public long getExpiration() {
        return this.getMetaData().getExpiration();
    }

    @Override
    public MessageReference newReference() {
        return new TransferMessageReference(this);
    }

    @Override
    public Long getMessageNumber() {
        return this._storeMessage.getMessageNumber();
    }

    @Override
    public long getArrivalTime() {
        return this.getMetaData().getArrivalTime();
    }

    @Override
    public int getContent(ByteBuffer buf, int offset) {
        return this._storeMessage.getContent(offset, buf);
    }

    public Header getHeader() {
        return this.getMetaData().getHeader();
    }

    public ByteBuffer getBody() {
        ByteBuffer body = this.getMetaData().getBody();
        if (body == null && this.getSize() != 0L) {
            int size = (int)this.getSize();
            body = ByteBuffer.allocate(size);
            for (int pos = 0; pos < size; pos += this.getContent(body, pos)) {
            }
            body.flip();
            this.getMetaData().setBody(body.duplicate());
        }
        return body;
    }

    public Session getSession() {
        return this._sessionRef == null ? null : (Session)this._sessionRef.get();
    }

    @Override
    public SessionConfig getSessionConfig() {
        return this._sessionRef == null ? null : (ServerSession)this._sessionRef.get();
    }
}

