/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.message;

import java.nio.ByteBuffer;
import java.util.Set;
import org.wso2.andes.AMQException;
import org.wso2.andes.framing.AMQShortString;
import org.wso2.andes.framing.BasicContentHeaderProperties;
import org.wso2.andes.framing.ContentHeaderBody;
import org.wso2.andes.framing.EncodingUtils;
import org.wso2.andes.framing.FieldTable;
import org.wso2.andes.framing.abstraction.MessagePublishInfo;
import org.wso2.andes.server.message.AMQMessageHeader;
import org.wso2.andes.server.store.MessageMetaDataType;
import org.wso2.andes.server.store.StorableMessageMetaData;

public class MessageMetaData
implements StorableMessageMetaData {
    private MessagePublishInfo _messagePublishInfo;
    private ContentHeaderBody _contentHeaderBody;
    private int _contentChunkCount;
    private String _clientIP = "";
    private long _arrivalTime;
    private boolean _isCompressed = false;
    private long publisherSessionID;
    private static final byte MANDATORY_FLAG = 1;
    private static final byte IMMEDIATE_FLAG = 2;
    public static final MessageMetaDataType.Factory<MessageMetaData> FACTORY = new MetaDataFactory();

    public MessageMetaData(MessagePublishInfo publishBody, ContentHeaderBody contentHeaderBody, int contentChunkCount) {
        this(publishBody, contentHeaderBody, contentChunkCount, System.currentTimeMillis());
    }

    public MessageMetaData(MessagePublishInfo publishBody, ContentHeaderBody contentHeaderBody, int contentChunkCount, long arrivalTime) {
        this._contentHeaderBody = contentHeaderBody;
        this._messagePublishInfo = publishBody;
        this._contentChunkCount = contentChunkCount;
        this._arrivalTime = arrivalTime;
    }

    public MessageMetaData(MessagePublishInfo publishBody, ContentHeaderBody contentHeaderBody, long sessionID, int contentChunkCount) {
        this(publishBody, contentHeaderBody, sessionID, contentChunkCount, System.currentTimeMillis());
    }

    public MessageMetaData(MessagePublishInfo publishBody, ContentHeaderBody contentHeaderBody, long sessionID, int contentChunkCount, long arrivalTime) {
        this._contentHeaderBody = contentHeaderBody;
        this._messagePublishInfo = publishBody;
        this._contentChunkCount = contentChunkCount;
        this._arrivalTime = arrivalTime;
        this.publisherSessionID = sessionID;
    }

    public MessageMetaData(MessagePublishInfo publishBody, ContentHeaderBody contentHeaderBody, long sessionID, int contentChunkCount, long arrivalTime, boolean isCompressed) {
        this(publishBody, contentHeaderBody, sessionID, contentChunkCount, arrivalTime);
        this._isCompressed = isCompressed;
    }

    public long getPublisherSessionID() {
        return this.publisherSessionID;
    }

    public void setPublisherSessionID(long publisherSessionID) {
        this.publisherSessionID = publisherSessionID;
    }

    public int getContentChunkCount() {
        return this._contentChunkCount;
    }

    public void setContentChunkCount(int contentChunkCount) {
        this._contentChunkCount = contentChunkCount;
    }

    public ContentHeaderBody getContentHeaderBody() {
        return this._contentHeaderBody;
    }

    public void setContentHeaderBody(ContentHeaderBody contentHeaderBody) {
        this._contentHeaderBody = contentHeaderBody;
    }

    public MessagePublishInfo getMessagePublishInfo() {
        return this._messagePublishInfo;
    }

    public void setMessagePublishInfo(MessagePublishInfo messagePublishInfo) {
        this._messagePublishInfo = messagePublishInfo;
    }

    public long getArrivalTime() {
        return this._arrivalTime;
    }

    public void setArrivalTime(long arrivalTime) {
        this._arrivalTime = arrivalTime;
    }

    @Override
    public MessageMetaDataType getType() {
        return MessageMetaDataType.META_DATA_0_8;
    }

    public boolean isCompressed() {
        return this._isCompressed;
    }

    @Override
    public int getStorableSize() {
        int size = this._contentHeaderBody.getSize();
        size += 4;
        size += EncodingUtils.encodedShortStringLength(this._messagePublishInfo.getExchange());
        size += EncodingUtils.encodedShortStringLength(this._messagePublishInfo.getRoutingKey());
        ++size;
        size += EncodingUtils.encodedLongLength();
        size += EncodingUtils.encodedLongLength();
        return size += EncodingUtils.encodedBooleanLength();
    }

    @Override
    public int writeToBuffer(int offset, ByteBuffer dest) {
        ByteBuffer src = ByteBuffer.allocate(this.getStorableSize());
        org.wso2.org.apache.mina.common.ByteBuffer minaSrc = org.wso2.org.apache.mina.common.ByteBuffer.wrap(src);
        EncodingUtils.writeInteger(minaSrc, this._contentHeaderBody.getSize());
        this._contentHeaderBody.writePayload(minaSrc);
        EncodingUtils.writeShortStringBytes(minaSrc, this._messagePublishInfo.getExchange());
        EncodingUtils.writeShortStringBytes(minaSrc, this._messagePublishInfo.getRoutingKey());
        byte flags = 0;
        if (this._messagePublishInfo.isMandatory()) {
            flags = (byte)(flags | 1);
        }
        if (this._messagePublishInfo.isImmediate()) {
            flags = (byte)(flags | 2);
        }
        EncodingUtils.writeByte(minaSrc, flags);
        EncodingUtils.writeLong(minaSrc, this.publisherSessionID);
        EncodingUtils.writeLong(minaSrc, this._arrivalTime);
        EncodingUtils.writeBoolean(minaSrc, this._isCompressed);
        src.position(minaSrc.position());
        src.flip();
        src.position(offset);
        src = src.slice();
        if (dest.remaining() < src.limit()) {
            src.limit(dest.remaining());
        }
        dest.put(src);
        return src.limit();
    }

    @Override
    public int getContentSize() {
        return (int)this._contentHeaderBody.bodySize;
    }

    @Override
    public boolean isPersistent() {
        BasicContentHeaderProperties properties = (BasicContentHeaderProperties)this._contentHeaderBody.getProperties();
        return properties.getDeliveryMode() == 2;
    }

    public String get_clientIP() {
        return this._clientIP;
    }

    public void set_clientIP(String _clientIP) {
        this._clientIP = _clientIP;
    }

    public AMQMessageHeader getMessageHeader() {
        return new MessageHeaderAdapter();
    }

    private final class MessageHeaderAdapter
    implements AMQMessageHeader {
        private MessageHeaderAdapter() {
        }

        private BasicContentHeaderProperties getProperties() {
            return (BasicContentHeaderProperties)MessageMetaData.this.getContentHeaderBody().getProperties();
        }

        @Override
        public String getCorrelationId() {
            return this.getProperties().getCorrelationIdAsString();
        }

        @Override
        public long getExpiration() {
            return this.getProperties().getExpiration();
        }

        @Override
        public String getMessageId() {
            return this.getProperties().getMessageIdAsString();
        }

        @Override
        public String getMimeType() {
            return this.getProperties().getContentTypeAsString();
        }

        @Override
        public String getEncoding() {
            return this.getProperties().getEncodingAsString();
        }

        @Override
        public byte getPriority() {
            return this.getProperties().getPriority();
        }

        @Override
        public long getTimestamp() {
            return this.getProperties().getTimestamp();
        }

        @Override
        public String getType() {
            return this.getProperties().getTypeAsString();
        }

        @Override
        public String getReplyTo() {
            return this.getProperties().getReplyToAsString();
        }

        @Override
        public String getReplyToExchange() {
            return this.getReplyTo();
        }

        @Override
        public String getReplyToRoutingKey() {
            return this.getReplyTo();
        }

        @Override
        public Object getHeader(String name) {
            FieldTable ft = this.getProperties().getHeaders();
            return ft.get(name);
        }

        @Override
        public boolean containsHeaders(Set<String> names) {
            FieldTable ft = this.getProperties().getHeaders();
            for (String name : names) {
                if (ft.containsKey(name)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean containsHeader(String name) {
            FieldTable ft = this.getProperties().getHeaders();
            return ft.containsKey(name);
        }
    }

    private static class MetaDataFactory
    implements MessageMetaDataType.Factory {
        private MetaDataFactory() {
        }

        public MessageMetaData createMetaData(ByteBuffer buf) {
            try {
                org.wso2.org.apache.mina.common.ByteBuffer minaSrc = org.wso2.org.apache.mina.common.ByteBuffer.wrap(buf);
                int size = EncodingUtils.readInteger(minaSrc);
                ContentHeaderBody chb = ContentHeaderBody.createFromBuffer(minaSrc, size);
                final AMQShortString exchange = EncodingUtils.readAMQShortString(minaSrc);
                final AMQShortString routingKey = EncodingUtils.readAMQShortString(minaSrc);
                final byte flags = EncodingUtils.readByte(minaSrc);
                long sessionID = EncodingUtils.readLong(minaSrc);
                long arrivalTime = EncodingUtils.readLong(minaSrc);
                boolean isCompressed = false;
                if (minaSrc.hasRemaining()) {
                    isCompressed = EncodingUtils.readBoolean(minaSrc);
                }
                MessagePublishInfo publishBody = new MessagePublishInfo(){

                    @Override
                    public AMQShortString getExchange() {
                        return exchange;
                    }

                    @Override
                    public void setExchange(AMQShortString exchange2) {
                    }

                    @Override
                    public void setRoutingKey(AMQShortString routingKey2) {
                    }

                    @Override
                    public boolean isImmediate() {
                        return (flags & 2) != 0;
                    }

                    @Override
                    public boolean isMandatory() {
                        return (flags & 1) != 0;
                    }

                    @Override
                    public AMQShortString getRoutingKey() {
                        return routingKey;
                    }
                };
                return new MessageMetaData(publishBody, chb, sessionID, 0, arrivalTime, isCompressed);
            }
            catch (AMQException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

