/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.message;

import java.nio.ByteBuffer;
import org.wso2.andes.AMQException;
import org.wso2.andes.framing.AMQShortString;
import org.wso2.andes.framing.ContentHeaderBody;
import org.wso2.andes.framing.EncodingUtils;
import org.wso2.andes.framing.abstraction.MessagePublishInfo;
import org.wso2.andes.server.message.AMQMessage;
import org.wso2.andes.server.message.MessageMetaData;
import org.wso2.andes.server.store.MessageMetaDataType;
import org.wso2.andes.server.store.StorableMessageMetaData;

public class CustomMessagePublishInfo
implements MessagePublishInfo {
    private org.wso2.org.apache.mina.common.ByteBuffer minaSrc;
    private int size;
    public ContentHeaderBody chb;
    private AMQShortString exchange;
    private AMQShortString routingKey;
    private byte flags;
    public long arrivalTime;
    private static final byte MANDATORY_FLAG = 1;
    private static final byte IMMEDIATE_FLAG = 2;

    public CustomMessagePublishInfo(AMQMessage message) {
        MessageMetaData metaData = message.getMessageMetaData();
        int bodySize = 1 + metaData.getStorableSize();
        byte[] underlying = new byte[bodySize];
        underlying[0] = (byte)metaData.getType().ordinal();
        ByteBuffer buf = ByteBuffer.wrap(underlying);
        buf.position(1);
        buf = buf.slice();
        metaData.writeToBuffer(0, buf);
        ByteBuffer bufNew = ByteBuffer.wrap(underlying);
        bufNew.position(1);
        bufNew = bufNew.slice();
        MessageMetaDataType type = MessageMetaDataType.values()[underlying[0]];
        this.createMetaData(bufNew);
    }

    public CustomMessagePublishInfo(StorableMessageMetaData metaData) {
        int bodySize = 1 + metaData.getStorableSize();
        byte[] underlying = new byte[bodySize];
        underlying[0] = (byte)metaData.getType().ordinal();
        ByteBuffer buf = ByteBuffer.wrap(underlying);
        buf.position(1);
        buf = buf.slice();
        metaData.writeToBuffer(0, buf);
        ByteBuffer bufNew = ByteBuffer.wrap(underlying);
        bufNew.position(1);
        bufNew = bufNew.slice();
        MessageMetaDataType type = MessageMetaDataType.values()[underlying[0]];
        this.createMetaData(bufNew);
    }

    private void createMetaData(ByteBuffer buf) {
        try {
            this.minaSrc = org.wso2.org.apache.mina.common.ByteBuffer.wrap(buf);
            this.size = EncodingUtils.readInteger(this.minaSrc);
            this.chb = ContentHeaderBody.createFromBuffer(this.minaSrc, this.size);
            this.exchange = EncodingUtils.readAMQShortString(this.minaSrc);
            this.routingKey = EncodingUtils.readAMQShortString(this.minaSrc);
            this.flags = EncodingUtils.readByte(this.minaSrc);
            this.arrivalTime = EncodingUtils.readLong(this.minaSrc);
        }
        catch (AMQException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public AMQShortString getExchange() {
        return this.exchange;
    }

    @Override
    public void setExchange(AMQShortString exchange) {
        this.exchange = exchange;
    }

    @Override
    public void setRoutingKey(AMQShortString routingKey) {
        this.routingKey = routingKey;
    }

    @Override
    public boolean isImmediate() {
        return (this.flags & 2) != 0;
    }

    @Override
    public boolean isMandatory() {
        return (this.flags & 1) != 0;
    }

    @Override
    public AMQShortString getRoutingKey() {
        return this.routingKey;
    }
}

