/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.logging.management;

import java.io.File;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.management.JMException;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.Log4jEntityResolver;
import org.apache.log4j.xml.QpidLog4JConfigurator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.wso2.andes.management.common.mbeans.LoggingManagement;
import org.wso2.andes.management.common.mbeans.annotations.MBeanDescription;
import org.wso2.andes.server.management.AMQManagedObject;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

@MBeanDescription(value="Logging Management Interface")
public class LoggingManagementMBean
extends AMQManagedObject
implements LoggingManagement {
    private static final Logger _logger = Logger.getLogger(LoggingManagementMBean.class);
    private String _log4jConfigFileName;
    private int _log4jLogWatchInterval;
    private static final String INHERITED = "INHERITED";
    private static final String[] LEVELS = new String[]{Level.ALL.toString(), Level.TRACE.toString(), Level.DEBUG.toString(), Level.INFO.toString(), Level.WARN.toString(), Level.ERROR.toString(), Level.FATAL.toString(), Level.OFF.toString(), "INHERITED"};
    static TabularType _loggerLevelTabularType;
    static CompositeType _loggerLevelCompositeType;

    public LoggingManagementMBean(String log4jConfigFileName, int log4jLogWatchInterval) throws JMException {
        super(LoggingManagement.class, "LoggingManagement");
        this._log4jConfigFileName = log4jConfigFileName;
        this._log4jLogWatchInterval = log4jLogWatchInterval;
    }

    @Override
    public String getObjectInstanceName() {
        return "LoggingManagement";
    }

    @Override
    public Integer getLog4jLogWatchInterval() {
        return this._log4jLogWatchInterval;
    }

    @Override
    public String[] getAvailableLoggerLevels() {
        return LEVELS;
    }

    @Override
    public synchronized boolean setRuntimeLoggerLevel(String logger, String level) {
        Logger log;
        Level newLevel;
        try {
            newLevel = this.getLevel(level);
        }
        catch (Exception e) {
            return false;
        }
        Enumeration loggers = LogManager.getCurrentLoggers();
        Boolean loggerExists = false;
        while (loggers.hasMoreElements()) {
            log = (Logger)loggers.nextElement();
            if (!log.getName().equals(logger)) continue;
            loggerExists = true;
            break;
        }
        if (!loggerExists.booleanValue()) {
            return false;
        }
        _logger.info((Object)("Setting level to " + level + " for logger: " + logger));
        log = Logger.getLogger((String)logger);
        log.setLevel(newLevel);
        return true;
    }

    @Override
    public synchronized TabularData viewEffectiveRuntimeLoggerLevels() {
        if (_loggerLevelTabularType == null) {
            _logger.warn((Object)"TabluarData type not set up correctly");
            return null;
        }
        _logger.info((Object)"Getting levels for currently active log4j loggers");
        Enumeration loggers = LogManager.getCurrentLoggers();
        TabularDataSupport loggerLevelList = new TabularDataSupport(_loggerLevelTabularType);
        try {
            while (loggers.hasMoreElements()) {
                Logger logger = (Logger)loggers.nextElement();
                String loggerName = logger.getName();
                String level = logger.getEffectiveLevel().toString();
                Object[] itemData = new Object[]{loggerName, level};
                CompositeDataSupport loggerData = new CompositeDataSupport(_loggerLevelCompositeType, COMPOSITE_ITEM_NAMES.toArray(new String[COMPOSITE_ITEM_NAMES.size()]), itemData);
                loggerLevelList.put(loggerData);
            }
        }
        catch (OpenDataException e) {
            _logger.warn((Object)("Unable to create logger level list due to :" + e));
            return null;
        }
        return loggerLevelList;
    }

    @Override
    public synchronized String getRuntimeRootLoggerLevel() {
        Logger rootLogger = Logger.getRootLogger();
        return rootLogger.getLevel().toString();
    }

    @Override
    public synchronized boolean setRuntimeRootLoggerLevel(String level) {
        Level newLevel;
        try {
            newLevel = this.getLevel(level);
        }
        catch (Exception e) {
            return false;
        }
        if (newLevel == null) {
            return false;
        }
        _logger.info((Object)("Setting RootLogger level to " + level));
        Logger log = Logger.getRootLogger();
        log.setLevel(newLevel);
        return true;
    }

    private Level getLevel(String level) throws Exception {
        if ("null".equalsIgnoreCase(level) || INHERITED.equalsIgnoreCase(level)) {
            return null;
        }
        Level newLevel = Level.toLevel((String)level);
        if (newLevel.equals((Object)Level.DEBUG) && !level.equalsIgnoreCase("debug")) {
            throw new Exception("Invalid level name");
        }
        return newLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized Document parseConfigFile(String fileName) throws IOException {
        try {
            Document doc;
            QpidLog4JConfigurator.LOCK.lock();
            if (fileName == null) {
                _logger.warn((Object)"Provided log4j XML configuration filename is null");
                throw new IOException("Provided log4j XML configuration filename is null");
            }
            File configFile = new File(fileName);
            if (!configFile.exists()) {
                _logger.warn((Object)("The log4j XML configuration file could not be found: " + fileName));
                throw new IOException("The log4j XML configuration file could not be found");
            }
            if (!configFile.canRead()) {
                _logger.warn((Object)("The log4j XML configuration file is not readable: " + fileName));
                throw new IOException("The log4j XML configuration file is not readable");
            }
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            QpidLog4JConfigurator.QpidLog4JSaxErrorHandler errHandler = new QpidLog4JConfigurator.QpidLog4JSaxErrorHandler();
            try {
                docFactory.setValidating(true);
                DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
                docBuilder.setErrorHandler((ErrorHandler)errHandler);
                docBuilder.setEntityResolver((EntityResolver)new Log4jEntityResolver());
                doc = docBuilder.parse(fileName);
            }
            catch (ParserConfigurationException e) {
                _logger.warn((Object)("Unable to parse the log4j XML file due to possible configuration error: " + e));
                throw new IOException("Unable to parse the log4j XML file due to possible configuration error: " + e.getMessage());
            }
            catch (SAXException e) {
                _logger.warn((Object)("The specified log4j XML file is invalid: " + e));
                throw new IOException("The specified log4j XML file is invalid: " + e.getMessage());
            }
            catch (IOException e) {
                _logger.warn((Object)("Unable to parse the specified log4j XML file" + e));
                throw new IOException("Unable to parse the specified log4j XML file: " + e.getMessage());
            }
            Document document = doc;
            return document;
        }
        finally {
            QpidLog4JConfigurator.LOCK.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized boolean writeUpdatedConfigFile(String log4jConfigFileName, Document doc) throws IOException {
        try {
            File tmp;
            QpidLog4JConfigurator.LOCK.lock();
            File log4jConfigFile = new File(log4jConfigFileName);
            if (!log4jConfigFile.canWrite()) {
                _logger.warn((Object)("Specified log4j XML configuration file is not writable: " + log4jConfigFile));
                throw new IOException("Specified log4j XML configuration file is not writable");
            }
            Transformer transformer = null;
            try {
                transformer = TransformerFactory.newInstance().newTransformer();
            }
            catch (Exception e) {
                _logger.warn((Object)("Could not create an XML transformer: " + e));
                boolean bl = false;
                QpidLog4JConfigurator.LOCK.unlock();
                return bl;
            }
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("doctype-system", "log4j.dtd");
            DOMSource source = new DOMSource(doc);
            SecureRandom r = new SecureRandom();
            while ((tmp = new File(log4jConfigFile.getPath() + r.nextInt() + ".tmp")).exists()) {
            }
            tmp.deleteOnExit();
            try {
                StreamResult result = new StreamResult(tmp);
                transformer.transform(source, result);
            }
            catch (TransformerException e) {
                _logger.warn((Object)("Could not transform the XML into new file: " + e));
                throw new IOException("Could not transform the XML into new file: " + e);
            }
            File old = new File(log4jConfigFile.getAbsoluteFile() + ".old");
            if (old.exists()) {
                old.delete();
            }
            if (!log4jConfigFile.renameTo(old)) {
                _logger.error((Object)"Could not backup the existing log4j XML file");
                throw new IOException("Could not backup the existing log4j XML file");
            }
            if (!tmp.renameTo(log4jConfigFile)) {
                if (!old.renameTo(log4jConfigFile)) {
                    _logger.error((Object)"Could not rename the new log4j configuration file into place, and unable to restore original file");
                    throw new IOException("Could not rename the new log4j configuration file into place, and unable to restore original file");
                }
                _logger.error((Object)"Could not rename the new log4j configuration file into place");
                throw new IOException("Could not rename the new log4j configuration file into place");
            }
            boolean bl = true;
            return bl;
        }
        finally {
            QpidLog4JConfigurator.LOCK.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Map<String, String> retrieveConfigFileLoggersLevels(String fileName) throws IOException {
        try {
            QpidLog4JConfigurator.LOCK.lock();
            Document doc = LoggingManagementMBean.parseConfigFile(fileName);
            HashMap<String, String> loggerLevelList = new HashMap<String, String>();
            NodeList categoryElements = doc.getElementsByTagName("category");
            String priority = null;
            for (int i = 0; i < categoryElements.getLength(); ++i) {
                Element categoryElement = (Element)categoryElements.item(i);
                String categoryName = categoryElement.getAttribute("name");
                NodeList priorityElements = categoryElement.getElementsByTagName("priority");
                NodeList levelElements = categoryElement.getElementsByTagName("level");
                if (priorityElements.getLength() != 0) {
                    Element priorityElement = (Element)priorityElements.item(0);
                    priority = priorityElement.getAttribute("value");
                } else {
                    if (levelElements.getLength() == 0) continue;
                    Element levelElement = (Element)levelElements.item(0);
                    priority = levelElement.getAttribute("value");
                }
                loggerLevelList.put(categoryName, priority);
            }
            NodeList loggerElements = doc.getElementsByTagName("logger");
            for (int i = 0; i < loggerElements.getLength(); ++i) {
                Element loggerElement = (Element)loggerElements.item(i);
                String loggerName = loggerElement.getAttribute("name");
                NodeList levelElements = loggerElement.getElementsByTagName("level");
                Element levelElement = (Element)levelElements.item(0);
                String level = levelElement.getAttribute("value");
                loggerLevelList.put(loggerName, level);
            }
            HashMap<String, String> hashMap = loggerLevelList;
            return hashMap;
        }
        finally {
            QpidLog4JConfigurator.LOCK.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized TabularData viewConfigFileLoggerLevels() throws IOException {
        try {
            QpidLog4JConfigurator.LOCK.lock();
            if (_loggerLevelTabularType == null) {
                _logger.warn((Object)"TabluarData type not set up correctly");
                TabularData tabularData = null;
                return tabularData;
            }
            _logger.info((Object)"Getting logger levels from log4j configuration file");
            TabularDataSupport loggerLevelList = new TabularDataSupport(_loggerLevelTabularType);
            Map<String, String> levels = LoggingManagementMBean.retrieveConfigFileLoggersLevels(this._log4jConfigFileName);
            for (Map.Entry<String, String> entry : levels.entrySet()) {
                String loggerName = entry.getKey();
                String level = entry.getValue();
                try {
                    Object[] itemData = new Object[]{loggerName, level.toUpperCase()};
                    CompositeDataSupport loggerData = new CompositeDataSupport(_loggerLevelCompositeType, COMPOSITE_ITEM_NAMES.toArray(new String[COMPOSITE_ITEM_NAMES.size()]), itemData);
                    loggerLevelList.put(loggerData);
                }
                catch (OpenDataException e) {
                    _logger.warn((Object)("Unable to create logger level list due to :" + e));
                    TabularData tabularData = null;
                    QpidLog4JConfigurator.LOCK.unlock();
                    return tabularData;
                }
            }
            TabularDataSupport tabularDataSupport = loggerLevelList;
            return tabularDataSupport;
        }
        finally {
            QpidLog4JConfigurator.LOCK.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean setConfigFileLoggerLevel(String logger, String level) throws IOException {
        try {
            int i;
            QpidLog4JConfigurator.LOCK.lock();
            try {
                this.getLevel(level);
            }
            catch (Exception e) {
                boolean bl = false;
                QpidLog4JConfigurator.LOCK.unlock();
                return bl;
            }
            _logger.info((Object)("Setting level to " + level + " for logger '" + logger + "' in log4j xml configuration file: " + this._log4jConfigFileName));
            Document doc = LoggingManagementMBean.parseConfigFile(this._log4jConfigFileName);
            NodeList categoryElements = doc.getElementsByTagName("category");
            NodeList loggerElements = doc.getElementsByTagName("logger");
            ArrayList<Element> logElements = new ArrayList<Element>();
            for (i = 0; i < categoryElements.getLength(); ++i) {
                logElements.add((Element)categoryElements.item(i));
            }
            for (i = 0; i < loggerElements.getLength(); ++i) {
                logElements.add((Element)loggerElements.item(i));
            }
            Element logElement = null;
            for (Element e : logElements) {
                if (!e.getAttribute("name").equals(logger)) continue;
                logElement = e;
                break;
            }
            if (logElement == null) {
                _logger.warn((Object)("Specified logger does not exist in the configuration file: " + logger));
                boolean bl = false;
                return bl;
            }
            NodeList priorityElements = logElement.getElementsByTagName("priority");
            NodeList levelElements = logElement.getElementsByTagName("level");
            Element levelElement = null;
            if (priorityElements.getLength() != 0) {
                levelElement = (Element)priorityElements.item(0);
            } else if (levelElements.getLength() != 0) {
                levelElement = (Element)levelElements.item(0);
            } else {
                boolean bl = false;
                return bl;
            }
            levelElement.setAttribute("value", level.toLowerCase());
            boolean bl = LoggingManagementMBean.writeUpdatedConfigFile(this._log4jConfigFileName, doc);
            return bl;
        }
        finally {
            QpidLog4JConfigurator.LOCK.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized String retrieveConfigFileRootLoggerLevel(String fileName) throws IOException {
        try {
            String string;
            QpidLog4JConfigurator.LOCK.lock();
            Document doc = LoggingManagementMBean.parseConfigFile(fileName);
            NodeList rootElements = doc.getElementsByTagName("root");
            if (rootElements.getLength() == 0) {
                String string2 = "N/A";
                return string2;
            }
            Element rootElement = (Element)rootElements.item(0);
            NodeList priorityElements = rootElement.getElementsByTagName("priority");
            NodeList levelElements = rootElement.getElementsByTagName("level");
            String priority = null;
            if (priorityElements.getLength() != 0) {
                Element priorityElement = (Element)priorityElements.item(0);
                priority = priorityElement.getAttribute("value");
            } else if (levelElements.getLength() != 0) {
                Element levelElement = (Element)levelElements.item(0);
                priority = levelElement.getAttribute("value");
            }
            if (priority != null) {
                string = priority;
                return string;
            }
            string = "N/A";
            return string;
        }
        finally {
            QpidLog4JConfigurator.LOCK.unlock();
        }
    }

    @Override
    public synchronized String getConfigFileRootLoggerLevel() throws IOException {
        return LoggingManagementMBean.retrieveConfigFileRootLoggerLevel(this._log4jConfigFileName).toUpperCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean setConfigFileRootLoggerLevel(String level) throws IOException {
        try {
            QpidLog4JConfigurator.LOCK.lock();
            try {
                Level newLevel = this.getLevel(level);
                if (newLevel == null) {
                    boolean bl = false;
                    return bl;
                }
            }
            catch (Exception e) {
                boolean bl = false;
                return bl;
            }
            _logger.info((Object)("Setting level to " + level + " for the Root logger in log4j xml configuration file: " + this._log4jConfigFileName));
            Document doc = LoggingManagementMBean.parseConfigFile(this._log4jConfigFileName);
            NodeList rootElements = doc.getElementsByTagName("root");
            if (rootElements.getLength() == 0) {
                boolean bl = false;
                return bl;
            }
            Element rootElement = (Element)rootElements.item(0);
            NodeList priorityElements = rootElement.getElementsByTagName("priority");
            NodeList levelElements = rootElement.getElementsByTagName("level");
            Element levelElement = null;
            if (priorityElements.getLength() != 0) {
                levelElement = (Element)priorityElements.item(0);
            } else if (levelElements.getLength() != 0) {
                levelElement = (Element)levelElements.item(0);
            } else {
                boolean bl = false;
                return bl;
            }
            levelElement.setAttribute("value", level);
            boolean bl = LoggingManagementMBean.writeUpdatedConfigFile(this._log4jConfigFileName, doc);
            return bl;
        }
        finally {
            QpidLog4JConfigurator.LOCK.unlock();
        }
    }

    @Override
    public synchronized void reloadConfigFile() throws IOException {
        try {
            QpidLog4JConfigurator.LOCK.lock();
            QpidLog4JConfigurator.configure((String)this._log4jConfigFileName);
            _logger.info((Object)("Applied log4j configuration from: " + this._log4jConfigFileName));
        }
        catch (QpidLog4JConfigurator.IllegalLoggerLevelException e) {
            _logger.warn((Object)("The log4j configuration reload request was aborted: " + (Object)((Object)e)));
            throw new IOException("The log4j configuration reload request was aborted: " + e.getMessage());
        }
        catch (ParserConfigurationException e) {
            _logger.warn((Object)("The log4j configuration reload request was aborted: " + e));
            throw new IOException("The log4j configuration reload request was aborted: " + e.getMessage());
        }
        catch (SAXException e) {
            _logger.warn((Object)("The log4j configuration reload request was aborted: " + e));
            throw new IOException("The log4j configuration reload request was aborted: " + e.getMessage());
        }
        catch (IOException e) {
            _logger.warn((Object)("The log4j configuration reload request was aborted: " + e));
            throw new IOException("The log4j configuration reload request was aborted: " + e.getMessage());
        }
        finally {
            QpidLog4JConfigurator.LOCK.unlock();
        }
    }

    static {
        try {
            OpenType[] loggerLevelItemTypes = new OpenType[]{SimpleType.STRING, SimpleType.STRING};
            _loggerLevelCompositeType = new CompositeType("LoggerLevelList", "Logger Level Data", COMPOSITE_ITEM_NAMES.toArray(new String[COMPOSITE_ITEM_NAMES.size()]), COMPOSITE_ITEM_DESCRIPTIONS.toArray(new String[COMPOSITE_ITEM_DESCRIPTIONS.size()]), loggerLevelItemTypes);
            _loggerLevelTabularType = new TabularType("LoggerLevel", "List of loggers with levels", _loggerLevelCompositeType, TABULAR_UNIQUE_INDEX.toArray(new String[TABULAR_UNIQUE_INDEX.size()]));
        }
        catch (OpenDataException e) {
            _logger.error((Object)"Tabular data setup for viewing logger levels was incorrect.");
            _loggerLevelTabularType = null;
        }
    }
}

