/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.information.management;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import javax.management.MBeanException;
import javax.management.NotCompliantMBeanException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.amqp.AMQPUtils;
import org.wso2.andes.kernel.AndesContext;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.DestinationType;
import org.wso2.andes.kernel.MessagingEngine;
import org.wso2.andes.kernel.ProtocolType;
import org.wso2.andes.kernel.subscription.AndesSubscription;
import org.wso2.andes.kernel.subscription.AndesSubscriptionManager;
import org.wso2.andes.management.common.mbeans.SubscriptionManagementInformation;
import org.wso2.andes.server.management.AMQManagedObject;

public class SubscriptionManagementInformationMBean
extends AMQManagedObject
implements SubscriptionManagementInformation {
    private static Log log = LogFactory.getLog(SubscriptionManagementInformationMBean.class);
    private static final String SEPARATOR = ";";
    private static final String NOT_AVAILABLE = "N/A";
    private AndesSubscriptionManager subscriptionManager = AndesContext.getInstance().getAndesSubscriptionManager();

    public SubscriptionManagementInformationMBean() throws NotCompliantMBeanException {
        super(SubscriptionManagementInformation.class, "SubscriptionManagementInformation");
    }

    @Override
    public String getObjectInstanceName() {
        return "SubscriptionManagementInformation";
    }

    @Override
    public String[] getSubscriptions(String isDurable, String isActive, String protocolType, String destinationType) throws MBeanException {
        try {
            boolean durableSubscriptionsReq = Boolean.parseBoolean(isDurable);
            Set<AndesSubscription> subscriptionsToDisplay = this.getSubscriptionsOfBroker(durableSubscriptionsReq, true, protocolType, destinationType);
            Set<AndesSubscription> inactiveSubscriptions = this.getSubscriptionsOfBroker(durableSubscriptionsReq, false, protocolType, destinationType);
            subscriptionsToDisplay.addAll(inactiveSubscriptions);
            String[] subscriptionArray = new String[subscriptionsToDisplay.size()];
            int index = 0;
            for (AndesSubscription subscription : subscriptionsToDisplay) {
                Long pendingMessageCount = MessagingEngine.getInstance().getApproximateQueueMessageCount(subscription.getStorageQueue().getName());
                subscriptionArray[index] = SubscriptionManagementInformationMBean.renderSubscriptionForUI(subscription.isActive(), destinationType, subscription, pendingMessageCount.intValue());
                ++index;
            }
            return subscriptionArray;
        }
        catch (Exception e) {
            log.error((Object)"Error while invoking MBeans to retrieve subscription information", (Throwable)e);
            throw new MBeanException(e, "Error while invoking MBeans to retrieve subscription information");
        }
    }

    @Override
    public long getPendingMessageCount(String queueName) throws MBeanException {
        try {
            return MessagingEngine.getInstance().getApproximateQueueMessageCount(queueName);
        }
        catch (Exception e) {
            log.error((Object)"Error while invoking MBeans to calculate the pending message count for storage queue", (Throwable)e);
            throw new MBeanException(e, "Error while invoking MBeans to calculate the pending message count for storage queue");
        }
    }

    @Override
    public String[] getFilteredSubscriptions(boolean isDurable, boolean isActive, String protocolType, String destinationType, String filteredNamePattern, boolean isFilteredNameByExactMatch, String identifierPattern, boolean isIdentifierPatternByExactMatch, String ownNodeId, int pageNumber, int maxSubscriptionCount) throws MBeanException {
        try {
            int startingIndex = pageNumber * maxSubscriptionCount;
            int resultSetSize = maxSubscriptionCount;
            int index = 0;
            int subscriptionDetailsIndex = 0;
            AndesSubscriptionManager subscriptionManager = AndesContext.getInstance().getAndesSubscriptionManager();
            Set<AndesSubscription> searchSubscriptionList = subscriptionManager.getFilteredSubscriptions(isDurable, isActive, ProtocolType.valueOf(protocolType), DestinationType.valueOf(destinationType), filteredNamePattern, isFilteredNameByExactMatch, identifierPattern, isIdentifierPatternByExactMatch, ownNodeId);
            int fullListSize = searchSubscriptionList.size() - startingIndex;
            if (fullListSize >= 0 && fullListSize < maxSubscriptionCount) {
                resultSetSize = searchSubscriptionList.size() - startingIndex;
            }
            String[] subscriptionArray = new String[resultSetSize];
            for (AndesSubscription subscription : searchSubscriptionList) {
                if (startingIndex <= index) {
                    Long pendingMessageCount = MessagingEngine.getInstance().getApproximateQueueMessageCount(subscription.getStorageQueue().getName());
                    subscriptionArray[subscriptionDetailsIndex] = SubscriptionManagementInformationMBean.renderSubscriptionForUI(isActive, destinationType, subscription, pendingMessageCount.intValue());
                    if (++subscriptionDetailsIndex == maxSubscriptionCount) break;
                }
                ++index;
            }
            return subscriptionArray;
        }
        catch (Exception e) {
            log.error((Object)("Error while invoking MBeans to retrieve subscription information. The given method parameters are: isDurable- " + isDurable + " isActive- " + isActive + " protocolType- " + protocolType + " destinationType- " + destinationType + " filteredNamePattern- " + filteredNamePattern + " isFilteredNameByExactMatch- " + isFilteredNameByExactMatch + " identifierPattern- " + identifierPattern + " isIdentifierPatternByExactMatch- " + isIdentifierPatternByExactMatch + " ownNodeId- " + ownNodeId + " pageNumber- " + pageNumber + " maxSubscriptionCount- " + maxSubscriptionCount), (Throwable)e);
            throw new MBeanException(e, "Error while invoking MBeans to retrieve subscription information");
        }
    }

    private Pattern createRegEx(String pattern) {
        String regex = pattern.replaceAll("\\*", ".*");
        return Pattern.compile(regex, 2);
    }

    @Override
    public int getTotalSubscriptionCountForSearchResult(boolean isDurable, boolean isActive, String protocolType, String destinationType, String filteredNamePattern, boolean isFilteredNameByExactMatch, String identifierPattern, boolean isIdentifierPatternByExactMatch, String ownNodeId) throws MBeanException {
        try {
            AndesSubscriptionManager subscriptionManager = AndesContext.getInstance().getAndesSubscriptionManager();
            Set<AndesSubscription> searchSubscriptionList = subscriptionManager.getFilteredSubscriptions(isDurable, isActive, ProtocolType.valueOf(protocolType), DestinationType.valueOf(destinationType), filteredNamePattern, isFilteredNameByExactMatch, identifierPattern, isIdentifierPatternByExactMatch, ownNodeId);
            return searchSubscriptionList.size();
        }
        catch (Exception e) {
            log.error((Object)"Error while invoking MBeans to retrieve subscription information", (Throwable)e);
            throw new MBeanException(e, "Error while invoking MBeans to retrieve subscription information");
        }
    }

    private Set<AndesSubscription> getSubscriptionsOfBroker(boolean isDurable, boolean isActive, String protocolType, String destinationType) throws AndesException {
        Iterable<AndesSubscription> matchingSubscriptions;
        AndesSubscriptionManager subscriptionManager = AndesContext.getInstance().getAndesSubscriptionManager();
        HashSet<AndesSubscription> subscriptionsToDisplay = new HashSet<AndesSubscription>(10);
        if (!isDurable && !isActive) {
            return subscriptionsToDisplay;
        }
        ProtocolType protocolTypeArg = ProtocolType.valueOf(protocolType);
        DestinationType destinationTypeArg = DestinationType.valueOf(destinationType);
        if (isActive) {
            String messageRouterName;
            switch (destinationTypeArg) {
                case TOPIC: {
                    if (protocolTypeArg.equals((Object)ProtocolType.AMQP)) {
                        messageRouterName = AMQPUtils.TOPIC_EXCHANGE_NAME;
                        break;
                    }
                    messageRouterName = "mqtt.topic";
                    break;
                }
                case QUEUE: {
                    messageRouterName = AMQPUtils.DIRECT_EXCHANGE_NAME;
                    break;
                }
                case DURABLE_TOPIC: {
                    if (protocolTypeArg.equals((Object)ProtocolType.AMQP)) {
                        messageRouterName = AMQPUtils.TOPIC_EXCHANGE_NAME;
                        break;
                    }
                    messageRouterName = "mqtt.topic";
                    break;
                }
                default: {
                    messageRouterName = AMQPUtils.DIRECT_EXCHANGE_NAME;
                }
            }
            matchingSubscriptions = subscriptionManager.getAllSubscriptionsByMessageRouter(protocolTypeArg, messageRouterName);
        } else {
            matchingSubscriptions = subscriptionManager.getInactiveSubscriberRepresentations();
        }
        for (AndesSubscription subscription : matchingSubscriptions) {
            if (isDurable != subscription.isDurable()) continue;
            subscriptionsToDisplay.add(subscription);
        }
        return subscriptionsToDisplay;
    }

    @Override
    public int getMessageCount(String subscribedNode, String msgPattern, String destinationName) {
        try {
            Long messageCount = MessagingEngine.getInstance().getApproximateQueueMessageCount(destinationName);
            return messageCount.intValue();
        }
        catch (Exception e) {
            throw new RuntimeException("Error in retrieving pending message count", e);
        }
    }

    @Override
    public void removeSubscription(String subscriptionId, String destinationName, String protocolType, String destinationType) {
        try {
            AndesSubscription subscriptionToRemove = this.subscriptionManager.getSubscriptionById(subscriptionId);
            if (null == subscriptionToRemove) {
                throw new AndesException("Subscription to remove not found. Requested id = " + subscriptionId);
            }
            subscriptionToRemove.forcefullyDisconnectConnections();
        }
        catch (AndesException e) {
            throw new RuntimeException("Error in accessing subscription information", e);
        }
    }

    private static String renderSubscriptionForUI(Boolean isActive, String destinationType, AndesSubscription subscription, int pendingMessageCount) throws AndesException {
        String subscriptionIdentifier = subscription.getSubscriptionId();
        StringBuilder subscriptionForUI = new StringBuilder(subscriptionIdentifier);
        subscriptionForUI.append(SEPARATOR);
        subscriptionForUI.append(subscription.getStorageQueue().getMessageRouterBindingKey());
        subscriptionForUI.append(SEPARATOR);
        subscriptionForUI.append(subscription.getStorageQueue().getMessageRouter().getName());
        subscriptionForUI.append(SEPARATOR);
        if (subscription.isLocal()) {
            subscriptionForUI.append(subscription.isDurable() ? subscription.getStorageQueue().getName() : subscription.getProtocolQueue());
        } else {
            subscriptionForUI.append(subscription.isDurable() ? subscription.getStorageQueue().getName() : NOT_AVAILABLE);
        }
        subscriptionForUI.append(SEPARATOR);
        subscriptionForUI.append(subscription.isDurable());
        subscriptionForUI.append(SEPARATOR);
        subscriptionForUI.append(isActive);
        subscriptionForUI.append(SEPARATOR);
        subscriptionForUI.append(pendingMessageCount);
        subscriptionForUI.append(SEPARATOR);
        subscriptionForUI.append(null == subscription.getSubscriberConnection() ? NOT_AVAILABLE : subscription.getSubscriberConnection().getConnectedNode());
        subscriptionForUI.append(SEPARATOR);
        subscriptionForUI.append(subscription.getStorageQueue().getMessageRouterBindingKey());
        subscriptionForUI.append(SEPARATOR);
        subscriptionForUI.append(subscription.getProtocolType().name());
        subscriptionForUI.append(SEPARATOR);
        subscriptionForUI.append(destinationType);
        subscriptionForUI.append(SEPARATOR);
        subscriptionForUI.append(null == subscription.getSubscriberConnection() ? NOT_AVAILABLE : subscription.getSubscriberConnection().getConnectedIP());
        return subscriptionForUI.toString();
    }
}

