/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.information.management;

import java.io.IOException;
import javax.management.JMException;
import org.wso2.andes.common.QpidProperties;
import org.wso2.andes.management.common.mbeans.ServerInformation;
import org.wso2.andes.management.common.mbeans.annotations.MBeanDescription;
import org.wso2.andes.server.management.AMQManagedObject;
import org.wso2.andes.server.registry.ApplicationRegistry;

@MBeanDescription(value="Server Information Interface")
public class ServerInformationMBean
extends AMQManagedObject
implements ServerInformation {
    private String buildVersion;
    private String productVersion;
    private ApplicationRegistry registry;

    public ServerInformationMBean(ApplicationRegistry applicationRegistry) throws JMException {
        super(ServerInformation.class, "ServerInformation");
        this.registry = applicationRegistry;
        this.buildVersion = QpidProperties.getBuildVersion();
        this.productVersion = QpidProperties.getReleaseVersion();
    }

    @Override
    public String getObjectInstanceName() {
        return "ServerInformation";
    }

    @Override
    public Integer getManagementApiMajorVersion() throws IOException {
        return 2;
    }

    @Override
    public Integer getManagementApiMinorVersion() throws IOException {
        return 3;
    }

    @Override
    public String getBuildVersion() throws IOException {
        return this.buildVersion;
    }

    @Override
    public String getProductVersion() throws IOException {
        return this.productVersion;
    }

    @Override
    public void resetStatistics() throws Exception {
        this.registry.resetStatistics();
    }

    @Override
    public double getPeakMessageDeliveryRate() {
        return this.registry.getMessageDeliveryStatistics().getPeak();
    }

    @Override
    public double getPeakDataDeliveryRate() {
        return this.registry.getDataDeliveryStatistics().getPeak();
    }

    @Override
    public double getMessageDeliveryRate() {
        return this.registry.getMessageDeliveryStatistics().getRate();
    }

    @Override
    public double getDataDeliveryRate() {
        return this.registry.getDataDeliveryStatistics().getRate();
    }

    @Override
    public long getTotalMessagesDelivered() {
        return this.registry.getMessageDeliveryStatistics().getTotal();
    }

    @Override
    public long getTotalDataDelivered() {
        return this.registry.getDataDeliveryStatistics().getTotal();
    }

    @Override
    public double getPeakMessageReceiptRate() {
        return this.registry.getMessageReceiptStatistics().getPeak();
    }

    @Override
    public double getPeakDataReceiptRate() {
        return this.registry.getDataReceiptStatistics().getPeak();
    }

    @Override
    public double getMessageReceiptRate() {
        return this.registry.getMessageReceiptStatistics().getRate();
    }

    @Override
    public double getDataReceiptRate() {
        return this.registry.getDataReceiptStatistics().getRate();
    }

    @Override
    public long getTotalMessagesReceived() {
        return this.registry.getMessageReceiptStatistics().getTotal();
    }

    @Override
    public long getTotalDataReceived() {
        return this.registry.getDataReceiptStatistics().getTotal();
    }

    @Override
    public boolean isStatisticsEnabled() {
        return this.registry.isStatisticsEnabled();
    }
}

