/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.information.management;

import com.gs.collections.impl.list.mutable.primitive.LongArrayList;
import com.gs.collections.impl.map.mutable.primitive.LongObjectHashMap;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jms.JMSException;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotReadableException;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.NotCompliantMBeanException;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.AMQException;
import org.wso2.andes.amqp.AMQPUtils;
import org.wso2.andes.configuration.AndesConfigurationManager;
import org.wso2.andes.configuration.enums.AndesConfiguration;
import org.wso2.andes.framing.AMQShortString;
import org.wso2.andes.framing.BasicContentHeaderProperties;
import org.wso2.andes.kernel.Andes;
import org.wso2.andes.kernel.AndesChannel;
import org.wso2.andes.kernel.AndesContext;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.AndesMessage;
import org.wso2.andes.kernel.AndesMessageMetadata;
import org.wso2.andes.kernel.AndesMessagePart;
import org.wso2.andes.kernel.AndesUtils;
import org.wso2.andes.kernel.DisablePubAckImpl;
import org.wso2.andes.kernel.FlowControlListener;
import org.wso2.andes.kernel.MessagingEngine;
import org.wso2.andes.kernel.ProtocolType;
import org.wso2.andes.kernel.disruptor.compression.LZ4CompressionHelper;
import org.wso2.andes.kernel.disruptor.inbound.InboundQueueEvent;
import org.wso2.andes.kernel.registry.StorageQueueRegistry;
import org.wso2.andes.kernel.router.AndesMessageRouter;
import org.wso2.andes.kernel.subscription.StorageQueue;
import org.wso2.andes.management.common.mbeans.QueueManagementInformation;
import org.wso2.andes.management.common.mbeans.annotations.MBeanOperationParameter;
import org.wso2.andes.server.management.AMQManagedObject;
import org.wso2.andes.server.message.AMQMessage;
import org.wso2.andes.server.queue.AMQQueue;
import org.wso2.andes.server.queue.DLCQueueUtils;
import org.wso2.andes.server.queue.QueueRegistry;
import org.wso2.andes.server.virtualhost.VirtualHostImpl;
import org.wso2.andes.transport.codec.BBDecoder;
import org.wso2.org.apache.mina.common.ByteBuffer;

public class QueueManagementInformationMBean
extends AMQManagedObject
implements QueueManagementInformation {
    public static final String MIME_TYPE_TEXT_PLAIN = "text/plain";
    public static final String MIMI_TYPE_TEXT_XML = "text/xml";
    public static final String MIME_TYPE_APPLICATION_JAVA_OBJECT_STREAM = "application/java-object-stream";
    public static final String MIME_TYPE_AMQP_MAP = "amqp/map";
    public static final String MIME_TYPE_JMS_MAP_MESSAGE = "jms/map-message";
    public static final String MIME_TYPE_JMS_STREAM_MESSAGE = "jms/stream-message";
    public static final String MIME_TYPE_APPLICATION_OCTET_STREAM = "application/octet-stream";
    private static Log log = LogFactory.getLog(QueueManagementInformationMBean.class);
    private final QueueRegistry queueRegistry;
    private final String PURGE_QUEUE_ERROR = "Error in purging queue : ";
    private final String MESSAGE_COUNT_RETRIEVE_ERROR = "Error while retrieving message count queue : ";
    private static CompositeType _msgContentType = null;
    private static OpenType[] _msgContentAttributeTypes = new OpenType[8];
    private final DisablePubAckImpl disablePubAck;
    boolean restoreBlockedByFlowControl = false;
    private static final int CHARACTERS_TO_SHOW = 15;
    public static final Integer MESSAGE_DISPLAY_LENGTH_MAX = (Integer)AndesConfigurationManager.readValue(AndesConfiguration.MANAGEMENT_CONSOLE_MAX_DISPLAY_LENGTH_FOR_MESSAGE_CONTENT);
    public static final String DISPLAY_CONTINUATION = "...";
    public static final String DISPLAY_LENGTH_EXCEEDED = "Message Content is too large to display.";
    protected static final byte BOOLEAN_TYPE = 1;
    protected static final byte BYTE_TYPE = 2;
    protected static final byte BYTEARRAY_TYPE = 3;
    protected static final byte SHORT_TYPE = 4;
    protected static final byte CHAR_TYPE = 5;
    protected static final byte INT_TYPE = 6;
    protected static final byte LONG_TYPE = 7;
    protected static final byte FLOAT_TYPE = 8;
    protected static final byte DOUBLE_TYPE = 9;
    protected static final byte STRING_TYPE = 10;
    protected static final byte NULL_STRING_TYPE = 11;
    private int byteArrayRemaining = -1;
    LZ4CompressionHelper lz4CompressionHelper;
    AndesChannel andesChannel = Andes.getInstance().createChannel(new FlowControlListener(){

        @Override
        public void block() {
            QueueManagementInformationMBean.this.restoreBlockedByFlowControl = true;
        }

        @Override
        public void unblock() {
            QueueManagementInformationMBean.this.restoreBlockedByFlowControl = false;
        }

        @Override
        public void disconnect() {
        }
    });

    public QueueManagementInformationMBean(VirtualHostImpl.VirtualHostMBean vHostMBean) throws NotCompliantMBeanException, OpenDataException {
        super(QueueManagementInformation.class, "QueueManagementInformation");
        VirtualHostImpl virtualHost = vHostMBean.getVirtualHost();
        this.queueRegistry = virtualHost.getQueueRegistry();
        this.disablePubAck = new DisablePubAckImpl();
        QueueManagementInformationMBean._msgContentAttributeTypes[0] = SimpleType.STRING;
        QueueManagementInformationMBean._msgContentAttributeTypes[1] = SimpleType.STRING;
        QueueManagementInformationMBean._msgContentAttributeTypes[2] = new ArrayType(1, SimpleType.STRING);
        QueueManagementInformationMBean._msgContentAttributeTypes[3] = SimpleType.STRING;
        QueueManagementInformationMBean._msgContentAttributeTypes[4] = SimpleType.BOOLEAN;
        QueueManagementInformationMBean._msgContentAttributeTypes[5] = SimpleType.LONG;
        QueueManagementInformationMBean._msgContentAttributeTypes[6] = SimpleType.STRING;
        QueueManagementInformationMBean._msgContentAttributeTypes[7] = SimpleType.LONG;
        _msgContentType = new CompositeType("Message Content", "Message content for queue browse", VIEW_MSG_CONTENT_COMPOSITE_ITEM_NAMES_DESC.toArray(new String[VIEW_MSG_CONTENT_COMPOSITE_ITEM_NAMES_DESC.size()]), VIEW_MSG_CONTENT_COMPOSITE_ITEM_NAMES_DESC.toArray(new String[VIEW_MSG_CONTENT_COMPOSITE_ITEM_NAMES_DESC.size()]), _msgContentAttributeTypes);
        this.lz4CompressionHelper = new LZ4CompressionHelper();
    }

    @Override
    public String getObjectInstanceName() {
        return "QueueManagementInformation";
    }

    @Override
    public synchronized String[] getAllQueueNames() {
        try {
            AndesMessageRouter queueMessageRouter = AndesContext.getInstance().getMessageRouterRegistry().getMessageRouter(AMQPUtils.DIRECT_EXCHANGE_NAME);
            List<String> queueNameList = queueMessageRouter.getNamesOfAllQueuesBound();
            String[] queues = new String[queueNameList.size()];
            queueNameList.toArray(queues);
            return queues;
        }
        catch (Exception e) {
            throw new RuntimeException("Error in accessing destination queues", e);
        }
    }

    @Override
    public Map<String, Integer> getAllQueueCounts() {
        try {
            AndesMessageRouter queueMessageRouter = AndesContext.getInstance().getMessageRouterRegistry().getMessageRouter(AMQPUtils.DIRECT_EXCHANGE_NAME);
            List<String> queueNames = queueMessageRouter.getNamesOfAllQueuesBound();
            return Andes.getInstance().getMessageCountForAllQueues(queueNames);
        }
        catch (AndesException exception) {
            throw new RuntimeException("Error retrieving message count for all queues", exception);
        }
    }

    @Override
    public CompositeData getMessageCountOfQueuesAsCompositeData() {
        CompositeDataSupport support;
        try {
            Map<String, Integer> messageCounts = this.getAllQueueCounts();
            OpenType[] messageCountAttributeTypes = new OpenType[messageCounts.size()];
            String[] itemNames = messageCounts.keySet().toArray(new String[0]);
            String[] itemDescriptions = messageCounts.keySet().toArray(new String[0]);
            for (int count = 0; count < messageCounts.size(); ++count) {
                messageCountAttributeTypes[count] = SimpleType.INTEGER;
            }
            CompositeType messageCountCompositeType = new CompositeType("Message Count of Queues", "Message count of queues", itemNames, itemDescriptions, messageCountAttributeTypes);
            support = new CompositeDataSupport(messageCountCompositeType, messageCounts);
        }
        catch (OpenDataException e) {
            log.error((Object)"Error in accessing retrieving message count information", (Throwable)e);
            throw new RuntimeException("Error in accessing retrieving message count information", e);
        }
        return support;
    }

    @Override
    public Set<String> getNamesOfAllDurableQueues() {
        HashSet<String> namesOfDurableQueues = new HashSet<String>();
        StorageQueueRegistry queueRegistry = AndesContext.getInstance().getStorageQueueRegistry();
        List<StorageQueue> queues = queueRegistry.getAllStorageQueues();
        for (StorageQueue queue : queues) {
            if (!queue.isDurable()) continue;
            namesOfDurableQueues.add(queue.getName());
        }
        return namesOfDurableQueues;
    }

    @Override
    public boolean isQueueExists(String queueName) {
        try {
            List<String> queuesList = AndesContext.getInstance().getStorageQueueRegistry().getAllStorageQueueNames();
            return queuesList.contains(queueName);
        }
        catch (Exception e) {
            throw new RuntimeException("Error in accessing destination queues", e);
        }
    }

    @Override
    public void deleteAllMessagesInQueue(@MBeanOperationParameter(name="queueName", description="Name of the queue to delete messages from") String queueName, @MBeanOperationParameter(name="ownerName", description="Username of user that calls for purge") String ownerName) throws MBeanException {
        AMQQueue queue = this.queueRegistry.getQueue(new AMQShortString(queueName));
        try {
            if (queue == null) {
                throw new JMException("The Queue " + queueName + " is not a registered queue.");
            }
            queue.purge(0L);
            InboundQueueEvent storageQueue = AMQPUtils.createInboundQueueEvent(queue);
            int purgedMessageCount = Andes.getInstance().purgeQueue(storageQueue);
            log.info((Object)("Total message count purged for queue (from store) : " + queueName + " : " + purgedMessageCount + ". All in memory messages received before the purge call are abandoned from delivery phase. "));
        }
        catch (JMException jme) {
            if (jme.toString().contains("not a registered queue")) {
                throw new MBeanException(jme, "The Queue " + queueName + " is not a registered queue.");
            }
            throw new MBeanException(jme, "Error in purging queue : " + queueName);
        }
        catch (AMQException | AndesException amqex) {
            throw new MBeanException(amqex, "Error in purging queue : " + queueName);
        }
    }

    @Override
    public void deleteMessagesFromDeadLetterQueue(@MBeanOperationParameter(name="andesMetadataIDs", description="ID of the Messages to Be DELETED") long[] andesMetadataIDs, @MBeanOperationParameter(name="destinationQueueName", description="The Dead Letter Queue Name for the selected tenant") String destinationQueueName) {
        ArrayList<AndesMessageMetadata> messageMetadataList = new ArrayList<AndesMessageMetadata>(andesMetadataIDs.length);
        for (long andesMetadataID : andesMetadataIDs) {
            AndesMessageMetadata messageToRemove = new AndesMessageMetadata(andesMetadataID, null, false);
            messageToRemove.setStorageQueueName(destinationQueueName);
            messageToRemove.setDestination(destinationQueueName);
            messageMetadataList.add(messageToRemove);
        }
        try {
            Andes.getInstance().deleteMessagesFromDLC(messageMetadataList);
        }
        catch (AndesException e) {
            throw new RuntimeException("Error deleting messages from Dead Letter Channel", e);
        }
    }

    @Override
    public void restoreSelectedMessagesFromDeadLetterChannel(@MBeanOperationParameter(name="andesMessageIds", description="IDs of the Messages to Be restored") long[] andesMessageIds, @MBeanOperationParameter(name="destinationQueueName", description="Original destination queue of the messages") String destinationQueueName) throws MBeanException {
        if (null != andesMessageIds) {
            int movedMessageCount = -1;
            ArrayList<Long> andesMessageIdList = new ArrayList<Long>(andesMessageIds.length);
            Collections.addAll(andesMessageIdList, ArrayUtils.toObject((long[])andesMessageIds));
            try {
                movedMessageCount = this.moveMessagesFromDLCToNewDestination(andesMessageIdList, destinationQueueName, destinationQueueName, true);
            }
            catch (AndesException ex) {
                throw new MBeanException(ex, "Error occurred when restoring messages from DLC to original qeueue : " + destinationQueueName + " movedMessageCount : " + movedMessageCount);
            }
        }
    }

    @Override
    public void rerouteSelectedMessagesFromDeadLetterChannel(@MBeanOperationParameter(name="andesMessageIds", description="IDs of the Messages to Be Restored") long[] andesMessageIds, @MBeanOperationParameter(name="sourceQueue", description="The  original queue name of the messages") String sourceQueue, @MBeanOperationParameter(name="targetQueue", description="New destination queue for the messages") String targetQueue) throws MBeanException {
        if (null != andesMessageIds) {
            int movedMessageCount = -1;
            ArrayList<Long> andesMessageIdList = new ArrayList<Long>(andesMessageIds.length);
            Collections.addAll(andesMessageIdList, ArrayUtils.toObject((long[])andesMessageIds));
            try {
                movedMessageCount = this.moveMessagesFromDLCToNewDestination(andesMessageIdList, sourceQueue, targetQueue, false);
            }
            catch (AndesException ex) {
                throw new MBeanException(ex, "Error occurred when moving messages destined to sourceQueue : " + sourceQueue + " from DLC to targetQueue : " + targetQueue + ". movedMessageCount : " + movedMessageCount);
            }
        }
    }

    private AndesMessage createMessage(AndesMessageMetadata messageMetadata, List<AndesMessagePart> messageParts) {
        AndesMessageMetadata clonedMetadata = messageMetadata.shallowCopy(messageMetadata.getMessageID());
        AndesMessage andesMessage = new AndesMessage(clonedMetadata);
        for (AndesMessagePart messagePart : messageParts) {
            andesMessage.addMessagePart(messagePart);
        }
        return andesMessage;
    }

    @Override
    public CompositeData[] browseQueue(@MBeanOperationParameter(name="queueName", description="Name of queue to browse messages") String queueName, @MBeanOperationParameter(name="lastMsgId", description="Browse message this message id onwards") long nextMsgId, @MBeanOperationParameter(name="maxMsgCount", description="Maximum message count per request") int maxMsgCount) throws MBeanException {
        ArrayList compositeDataList = new ArrayList();
        try {
            List<AndesMessageMetadata> nextNMessageMetadataFromQueue = !DLCQueueUtils.isDeadLetterQueue(queueName) ? Andes.getInstance().getNextNMessageMetadataFromQueue(queueName, nextMsgId, maxMsgCount) : Andes.getInstance().getNextNMessageMetadataFromDLC(queueName, nextMsgId, maxMsgCount);
            return this.getDisplayableMetaData(nextNMessageMetadataFromQueue, true);
        }
        catch (AndesException e) {
            throw new MBeanException(e, "Error occurred in browse queue.");
        }
    }

    @Override
    public long getNumberOfMessagesInDLCForQueue(String queueName) throws MBeanException {
        try {
            return Andes.getInstance().getMessageCountInDLCForQueue(queueName, DLCQueueUtils.identifyTenantInformationAndGenerateDLCString(queueName));
        }
        catch (AndesException e) {
            throw new MBeanException(e, "Error restoring messages from dead letter channel for:" + queueName);
        }
    }

    @Override
    public CompositeData[] getMessagesInDLCForQueue(@MBeanOperationParameter(name="queueName", description="Name of queue to browse messages") String queueName, @MBeanOperationParameter(name="lastMsgId", description="Browse message this onwards") long nextMsgId, @MBeanOperationParameter(name="maxMsgCount", description="Maximum message count per request") int maxMessageCount) throws MBeanException {
        try {
            List<AndesMessageMetadata> nextNMessageMetadataFromQueue = !DLCQueueUtils.isDeadLetterQueue(queueName) ? Andes.getInstance().getNextNMessageMetadataInDLCForQueue(queueName, DLCQueueUtils.identifyTenantInformationAndGenerateDLCString(queueName), nextMsgId, maxMessageCount) : Andes.getInstance().getNextNMessageMetadataFromDLC(DLCQueueUtils.identifyTenantInformationAndGenerateDLCString(queueName), nextMsgId, maxMessageCount);
            return this.getDisplayableMetaData(nextNMessageMetadataFromQueue, true);
        }
        catch (AndesException e) {
            throw new MBeanException(e, "Error occurred in browse queue.");
        }
    }

    private String extractMapMessageContent(ByteBuffer wrapMsgContent) {
        wrapMsgContent.rewind();
        BBDecoder decoder = new BBDecoder();
        decoder.init(wrapMsgContent.buf());
        Map mapMassage = decoder.readMap();
        String wholeMsg = "";
        for (Map.Entry entry : mapMassage.entrySet()) {
            String mapName = (String)entry.getKey();
            String mapVal = entry.getValue().toString();
            StringBuilder messageContentBuilder = new StringBuilder();
            wholeMsg = StringEscapeUtils.escapeHtml((String)messageContentBuilder.append(mapName).append(": ").append(mapVal).append(", ").toString()).trim();
        }
        return wholeMsg;
    }

    private String extractStreamMessageContent(ByteBuffer wrapMsgContent, String encoding) throws CharacterCodingException {
        boolean eofReached = false;
        StringBuilder messageContentBuilder = new StringBuilder();
        while (!eofReached) {
            try {
                Object obj = this.readObject(wrapMsgContent, encoding);
                if (null == obj) continue;
                messageContentBuilder.append(obj.toString()).append(", ");
            }
            catch (MessageEOFException ex) {
                eofReached = true;
            }
            catch (MessageNotReadableException e) {
                eofReached = true;
            }
            catch (MessageFormatException e) {
                eofReached = true;
            }
            catch (JMSException e) {
                eofReached = true;
            }
        }
        String wholeMsg = StringEscapeUtils.escapeHtml((String)messageContentBuilder.toString());
        return wholeMsg;
    }

    private String extractTextMessageContent(ByteBuffer wrapMsgContent, String encoding) throws CharacterCodingException {
        String wholeMsg = wrapMsgContent.getString(Charset.forName(encoding).newDecoder());
        return wholeMsg;
    }

    private Object readObject(ByteBuffer wrapMsgContent, String encoding) throws JMSException, CharacterCodingException {
        int position = wrapMsgContent.position();
        this.checkAvailable(1, wrapMsgContent);
        byte wireType = wrapMsgContent.get();
        Object result = null;
        try {
            switch (wireType) {
                case 1: {
                    this.checkAvailable(1, wrapMsgContent);
                    result = wrapMsgContent.get() != 0;
                    break;
                }
                case 2: {
                    this.checkAvailable(1, wrapMsgContent);
                    result = wrapMsgContent.get();
                    break;
                }
                case 3: {
                    this.checkAvailable(4, wrapMsgContent);
                    int size = wrapMsgContent.getInt();
                    if (size == -1) {
                        result = null;
                        break;
                    }
                    this.byteArrayRemaining = size;
                    byte[] bytesResult = new byte[size];
                    this.readBytesImpl(wrapMsgContent, bytesResult);
                    result = bytesResult;
                    break;
                }
                case 4: {
                    this.checkAvailable(2, wrapMsgContent);
                    result = wrapMsgContent.getShort();
                    break;
                }
                case 5: {
                    this.checkAvailable(2, wrapMsgContent);
                    result = Character.valueOf(wrapMsgContent.getChar());
                    break;
                }
                case 6: {
                    this.checkAvailable(4, wrapMsgContent);
                    result = wrapMsgContent.getInt();
                    break;
                }
                case 7: {
                    this.checkAvailable(8, wrapMsgContent);
                    result = wrapMsgContent.getLong();
                    break;
                }
                case 8: {
                    this.checkAvailable(4, wrapMsgContent);
                    result = Float.valueOf(wrapMsgContent.getFloat());
                    break;
                }
                case 9: {
                    this.checkAvailable(8, wrapMsgContent);
                    result = wrapMsgContent.getDouble();
                    break;
                }
                case 11: {
                    result = null;
                    break;
                }
                case 10: {
                    this.checkAvailable(1, wrapMsgContent);
                    result = wrapMsgContent.getString(Charset.forName(encoding).newDecoder());
                }
            }
            return result;
        }
        catch (RuntimeException e) {
            wrapMsgContent.position(position);
            throw e;
        }
    }

    private int readBytesImpl(ByteBuffer wrapMsgContent, byte[] bytes) {
        int count = this.byteArrayRemaining >= bytes.length ? bytes.length : this.byteArrayRemaining;
        this.byteArrayRemaining -= count;
        if (count == 0) {
            return 0;
        }
        wrapMsgContent.get(bytes, 0, count);
        return count;
    }

    private void checkAvailable(int length, ByteBuffer byteBuffer) throws MessageEOFException {
        if (byteBuffer.remaining() < length) {
            throw new MessageEOFException("Unable to read " + length + " bytes");
        }
    }

    private String getReadableNameForMessageContentType(String contentType) {
        if (StringUtils.isNotBlank((String)contentType)) {
            if (contentType.equals(MIME_TYPE_TEXT_PLAIN) || contentType.equals(MIMI_TYPE_TEXT_XML)) {
                contentType = "Text";
            } else if (contentType.equals(MIME_TYPE_APPLICATION_JAVA_OBJECT_STREAM)) {
                contentType = "Object";
            } else if (contentType.equals(MIME_TYPE_AMQP_MAP) || contentType.equals(MIME_TYPE_JMS_MAP_MESSAGE)) {
                contentType = "Map";
            } else if (contentType.equals(MIME_TYPE_JMS_STREAM_MESSAGE)) {
                contentType = "Stream";
            } else if (contentType.equals(MIME_TYPE_APPLICATION_OCTET_STREAM)) {
                contentType = "Byte";
            }
        }
        return contentType;
    }

    private LongArrayList getValidAndesMessageIdList(String[] browserMessageIdList) {
        LongArrayList andesMessageIdList = new LongArrayList(browserMessageIdList.length);
        for (String browserMessageId : browserMessageIdList) {
            Long andesMessageId = AndesUtils.getAndesMessageId(browserMessageId);
            if (andesMessageId > 0L) {
                andesMessageIdList.add(andesMessageId);
                continue;
            }
            log.warn((Object)("A valid message could not be found for the message Id : " + browserMessageId));
        }
        return andesMessageIdList;
    }

    @Override
    public long getMessageCount(String queueName, String msgPattern) throws MBeanException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Counting at queue : " + queueName));
        }
        long messageCount = 0L;
        try {
            if (!DLCQueueUtils.isDeadLetterQueue(queueName)) {
                if ("queue".equals(msgPattern)) {
                    messageCount = Andes.getInstance().getMessageCountOfQueue(queueName);
                }
            } else {
                messageCount = Andes.getInstance().getMessageCountInDLC(queueName);
            }
        }
        catch (AndesException e) {
            log.error((Object)("Error while retrieving message count queue : " + queueName), (Throwable)e);
            throw new MBeanException(e, "Error while retrieving message count queue : " + queueName);
        }
        return messageCount;
    }

    @Override
    public Map<String, Long> getDLCQueueInformation(String queueName) throws MBeanException {
        HashMap<String, Long> DLCQueueInformation;
        try {
            DLCQueueInformation = new HashMap<String, Long>(1);
            AndesMessageRouter DLCMessageRouter = AndesContext.getInstance().getMessageRouterRegistry().getMessageRouter(AMQPUtils.DLC_EXCHANGE_NAME);
            List<StorageQueue> DLCQueues = DLCMessageRouter.getAllBoundQueues();
            for (StorageQueue dlcQueue : DLCQueues) {
                if (!queueName.equals(dlcQueue.getName())) continue;
                DLCQueueInformation.put(dlcQueue.getName(), dlcQueue.getMessageCount());
                break;
            }
        }
        catch (AndesException e) {
            throw new MBeanException(e, "Error while receiving DLC queue Information from MBeans");
        }
        return DLCQueueInformation;
    }

    @Override
    public int getSubscriptionCount(String queueName) {
        try {
            return AndesContext.getInstance().getAndesSubscriptionManager().numberOfSubscriptionsInCluster(queueName, ProtocolType.AMQP);
        }
        catch (Exception e) {
            throw new RuntimeException("Error in getting subscriber count", e);
        }
    }

    private CompositeData[] getDisplayableMetaData(List<AndesMessageMetadata> metadataList, boolean includeContent) throws MBeanException {
        ArrayList<CompositeDataSupport> compositeDataList = new ArrayList<CompositeDataSupport>();
        try {
            for (AndesMessageMetadata andesMessageMetadata : metadataList) {
                Object[] itemValues = this.getItemValues(andesMessageMetadata, includeContent);
                if (null == itemValues) continue;
                CompositeDataSupport support = new CompositeDataSupport(_msgContentType, VIEW_MSG_CONTENT_COMPOSITE_ITEM_NAMES_DESC.toArray(new String[VIEW_MSG_CONTENT_COMPOSITE_ITEM_NAMES_DESC.size()]), itemValues);
                compositeDataList.add(support);
            }
        }
        catch (OpenDataException exception) {
            throw new MBeanException(exception, "Error occurred when formatting message in queue.");
        }
        return compositeDataList.toArray(new CompositeData[compositeDataList.size()]);
    }

    private Object[] getItemValues(AndesMessageMetadata andesMessageMetadata, boolean includeContent) throws MBeanException {
        try {
            Object[] itemValues = null;
            AMQMessage amqMessage = AMQPUtils.getAMQMessageFromAndesMetaData(andesMessageMetadata);
            BasicContentHeaderProperties properties = (BasicContentHeaderProperties)amqMessage.getContentHeaderBody().getProperties();
            StringBuilder stringBuilder = new StringBuilder();
            for (String headerKey : properties.getHeaders().keys()) {
                stringBuilder.append(headerKey).append(" = ").append(properties.getHeaders().get(headerKey));
                stringBuilder.append(", ");
            }
            if (null != properties.getCorrelationId()) {
                stringBuilder.append("JMSCorrelationID").append(" = ").append(properties.getCorrelationId()).append(", ");
            }
            if (null != properties.getReplyTo()) {
                stringBuilder.append("JMSReplyTo").append(" = ").append(properties.getReplyTo()).append(", ");
            }
            if (null != properties.getType()) {
                stringBuilder.append("JMSType").append(" = ").append(properties.getType()).append(", ");
            }
            String msgProperties = stringBuilder.toString();
            String contentType = properties.getContentTypeAsString();
            String messageId = properties.getMessageIdAsString();
            boolean redelivered = false;
            long timeStamp = properties.getTimestamp();
            String destination = andesMessageMetadata.getDestination();
            long andesMessageMetadataId = andesMessageMetadata.getMessageID();
            int bodySize = (int)amqMessage.getSize();
            if (includeContent) {
                AndesMessagePart constructedContent = this.constructContent(bodySize, amqMessage);
                byte[] messageContent = constructedContent.getData();
                int position = constructedContent.getOffset();
                if (bodySize == 0 || position != 0) {
                    String[] content = this.decodeContent(amqMessage, messageContent);
                    contentType = this.getReadableNameForMessageContentType(contentType);
                    itemValues = new Object[]{msgProperties, contentType, content, messageId, redelivered, timeStamp, destination, andesMessageMetadataId};
                } else if (bodySize == 0) {
                    itemValues = new Object[]{msgProperties, contentType, "", messageId, redelivered, timeStamp, destination, andesMessageMetadataId};
                }
            } else {
                itemValues = new Object[]{msgProperties, contentType, new String[0], messageId, redelivered, timeStamp, destination, andesMessageMetadataId};
            }
            return itemValues;
        }
        catch (AMQException exception) {
            throw new MBeanException(exception, "Error occurred when formatting message with Id : " + andesMessageMetadata.getMessageID() + " assigned to queue : " + andesMessageMetadata.getDestination());
        }
    }

    private AndesMessagePart constructContent(int bodySize, AMQMessage amqMessage) throws MBeanException {
        AndesMessagePart andesMessagePart;
        if (amqMessage.getMessageMetaData().isCompressed()) {
            long messageID = amqMessage.getMessageId();
            LongArrayList messList = new LongArrayList();
            messList.add(messageID);
            try {
                LongObjectHashMap<List<AndesMessagePart>> contentListMap = MessagingEngine.getInstance().getContent(messList);
                List<AndesMessagePart> contentList = contentListMap.get(messageID);
                andesMessagePart = this.lz4CompressionHelper.getDecompressedMessage(contentList, bodySize);
            }
            catch (AndesException e) {
                throw new MBeanException(e, "Error occurred while construct the message content. Message ID:" + amqMessage.getMessageId());
            }
        } else {
            int position;
            byte[] messageContent = new byte[bodySize];
            java.nio.ByteBuffer buffer = java.nio.ByteBuffer.wrap(messageContent);
            for (position = 0; position < bodySize; position += amqMessage.getContent(buffer, position)) {
                if (0 != bodySize && 0 == position) break;
                buffer.flip();
                buffer.clear();
            }
            andesMessagePart = new AndesMessagePart();
            andesMessagePart.setData(messageContent);
            andesMessagePart.setOffSet(position);
        }
        return andesMessagePart;
    }

    private String[] decodeContent(AMQMessage amqMessage, byte[] messageContent) throws MBeanException {
        try {
            String mimeType;
            String encoding = amqMessage.getMessageHeader().getEncoding();
            if (encoding == null) {
                encoding = "UTF-8";
            }
            if (StringUtils.isBlank((String)(mimeType = amqMessage.getMessageHeader().getMimeType()))) {
                mimeType = MIME_TYPE_TEXT_PLAIN;
            }
            ByteBuffer wrapMsgContent = ByteBuffer.wrap(messageContent);
            String[] content = new String[2];
            String summaryMsg = "";
            String wholeMsg = "";
            if (mimeType.equals(MIME_TYPE_TEXT_PLAIN) || mimeType.equals(MIMI_TYPE_TEXT_XML)) {
                wholeMsg = this.extractTextMessageContent(wrapMsgContent, encoding);
            } else if (mimeType.equals(MIME_TYPE_APPLICATION_JAVA_OBJECT_STREAM) || mimeType.equals(MIME_TYPE_APPLICATION_OCTET_STREAM)) {
                wholeMsg = "This Operation is Not Supported!";
            } else if (mimeType.equals(MIME_TYPE_JMS_STREAM_MESSAGE)) {
                wholeMsg = this.extractStreamMessageContent(wrapMsgContent, encoding);
            } else if (mimeType.equals(MIME_TYPE_AMQP_MAP) || mimeType.equals(MIME_TYPE_JMS_MAP_MESSAGE)) {
                wholeMsg = this.extractMapMessageContent(wrapMsgContent);
            }
            summaryMsg = wholeMsg.length() >= 15 ? wholeMsg.substring(0, 15) : wholeMsg;
            if (wholeMsg.length() > MESSAGE_DISPLAY_LENGTH_MAX) {
                wholeMsg = wholeMsg.substring(0, MESSAGE_DISPLAY_LENGTH_MAX - 3) + DISPLAY_CONTINUATION + DISPLAY_LENGTH_EXCEEDED;
            }
            content[0] = summaryMsg;
            content[1] = wholeMsg;
            return content;
        }
        catch (CharacterCodingException exception) {
            throw new MBeanException(exception, "Error occurred in browse queue.");
        }
    }

    private int moveMessagesFromDLCToNewDestination(List<Long> messageIds, String sourceQueue, String targetQueue, boolean restoreToOriginalQueue) throws AndesException {
        ArrayList<AndesMessageMetadata> messagesToRemove = new ArrayList<AndesMessageMetadata>(messageIds.size());
        LongArrayList messageIdCollection = new LongArrayList();
        for (Long messageId : messageIds) {
            messageIdCollection.add(messageId);
        }
        int movedMessageCount = 0;
        LongObjectHashMap<List<AndesMessagePart>> messageContent = Andes.getInstance().getContent(messageIdCollection);
        boolean interruptedByFlowControl = false;
        for (Long messageId : messageIds) {
            List<AndesMessagePart> messageParts;
            if (this.restoreBlockedByFlowControl) {
                interruptedByFlowControl = true;
                break;
            }
            AndesMessageMetadata metadata = Andes.getInstance().getMessageMetaData(messageId);
            if (!restoreToOriginalQueue) {
                StorageQueue newStorageQueue = AndesContext.getInstance().getStorageQueueRegistry().getStorageQueue(targetQueue);
                metadata.setDestination(targetQueue);
                metadata.setStorageQueueName(targetQueue);
                metadata.setMessageRouterName(newStorageQueue.getMessageRouter().getName());
                metadata.updateMetadata(targetQueue, newStorageQueue.getMessageRouter().getName(), System.currentTimeMillis());
            } else {
                metadata.updateMetadata(metadata.getDestination(), metadata.getMessageRouterName(), System.currentTimeMillis());
            }
            long now = System.currentTimeMillis();
            metadata.setExpirationTime(now + (metadata.getExpirationTime() - metadata.getArrivalTime()));
            AndesMessageMetadata clonedMetadata = metadata.shallowCopy(metadata.getMessageID());
            AndesMessage andesMessage = new AndesMessage(clonedMetadata);
            messagesToRemove.add(metadata);
            if (!messageContent.isEmpty() && (messageParts = messageContent.get(messageId)) != null) {
                for (AndesMessagePart messagePart : messageParts) {
                    andesMessage.addMessagePart(messagePart);
                }
            }
            Andes.getInstance().messageReceived(andesMessage, this.andesChannel, this.disablePubAck);
            ++movedMessageCount;
        }
        if (interruptedByFlowControl) {
            throw new AndesException("Message restore from dead letter queue has been interrupted by flow control. Messages in the DLC for sourceQueue : " + sourceQueue + " may be duplicated due to this situation. Please try again later. movedMessageCount : " + movedMessageCount);
        }
        Andes.getInstance().deleteMessagesFromDLC(messagesToRemove);
        return movedMessageCount;
    }

    @Override
    public CompositeData[] getMessageMetadataInDeadLetterChannel(@MBeanOperationParameter(name="targetQueue", description="Name of destination queue ") String targetQueue, @MBeanOperationParameter(name="startMessageId", description="Message Id to start the resultset with.") long startMessageId, @MBeanOperationParameter(name="pageLimit", description="Maximum message count required in a single response") int pageLimit) throws MBeanException {
        try {
            List<AndesMessageMetadata> nextNMessageMetadataFromQueue = !DLCQueueUtils.isDeadLetterQueue(targetQueue) ? Andes.getInstance().getNextNMessageMetadataInDLCForQueue(targetQueue, DLCQueueUtils.identifyTenantInformationAndGenerateDLCString(targetQueue), startMessageId, pageLimit) : Andes.getInstance().getNextNMessageMetadataFromDLC(DLCQueueUtils.identifyTenantInformationAndGenerateDLCString(targetQueue), startMessageId, pageLimit);
            return this.getDisplayableMetaData(nextNMessageMetadataFromQueue, false);
        }
        catch (AndesException e) {
            throw new MBeanException(e, "Error occurred when listing metadata in DLC for queue : " + targetQueue + " from message Id : " + startMessageId + " onwards.");
        }
    }

    @Override
    public int rerouteAllMessagesInDeadLetterChannelForQueue(@MBeanOperationParameter(name="sourceQueue", description="Name of the source queue") String sourceQueue, @MBeanOperationParameter(name="targetQueue", description="Name of the target queue") String targetQueue, @MBeanOperationParameter(name="internalBatchSize", description="Number of messages processed in a single database call.") int internalBatchSize) throws MBeanException {
        Long lastMessageId = 0L;
        int movedMessageCount = 0;
        String dlcQueueName = DLCQueueUtils.identifyTenantInformationAndGenerateDLCString(sourceQueue);
        try {
            if (DLCQueueUtils.isDeadLetterQueue(sourceQueue)) {
                List<Long> currentMessageIdList = Andes.getInstance().getNextNMessageIdsInDLC(dlcQueueName, lastMessageId, internalBatchSize);
                while (currentMessageIdList.size() > 0) {
                    int movedMessageCountInThisBatch = this.moveMessagesFromDLCToNewDestination(currentMessageIdList, sourceQueue, targetQueue, false);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Successfully restored messages from DLC to targetQueue: " + targetQueue + " movedMessageCountInThisBatch : " + movedMessageCountInThisBatch));
                    }
                    movedMessageCount += movedMessageCountInThisBatch;
                    lastMessageId = currentMessageIdList.get(currentMessageIdList.size() - 1);
                    currentMessageIdList = Andes.getInstance().getNextNMessageIdsInDLC(dlcQueueName, lastMessageId, internalBatchSize);
                }
            } else {
                List<Long> currentMessageIdList = Andes.getInstance().getNextNMessageIdsInDLCForQueue(sourceQueue, dlcQueueName, lastMessageId, internalBatchSize);
                while (currentMessageIdList.size() > 0) {
                    int movedMessageCountInThisBatch = this.moveMessagesFromDLCToNewDestination(currentMessageIdList, sourceQueue, targetQueue, false);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Successfully restored messages from sourceQueue : " + sourceQueue + " to targetQueue : " + targetQueue + " movedMessageCountInThisBatch : " + movedMessageCountInThisBatch));
                    }
                    movedMessageCount += movedMessageCountInThisBatch;
                    lastMessageId = currentMessageIdList.get(currentMessageIdList.size() - 1);
                    currentMessageIdList = Andes.getInstance().getNextNMessageIdsInDLCForQueue(sourceQueue, dlcQueueName, lastMessageId, internalBatchSize);
                }
            }
        }
        catch (AndesException ex) {
            throw new MBeanException(ex, "Error occurred when moving metadata destined to sourceQueue : " + sourceQueue + " from DLC to targetQueue : " + targetQueue + ". movedMessageCount : " + movedMessageCount);
        }
        return movedMessageCount;
    }
}

