/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.handler;

import org.apache.log4j.Logger;
import org.wso2.andes.AMQException;
import org.wso2.andes.framing.MethodRegistry;
import org.wso2.andes.framing.TxCommitBody;
import org.wso2.andes.framing.TxCommitOkBody;
import org.wso2.andes.server.AMQChannel;
import org.wso2.andes.server.protocol.AMQProtocolSession;
import org.wso2.andes.server.state.AMQStateManager;
import org.wso2.andes.server.state.StateAwareMethodListener;

public class TxCommitHandler
implements StateAwareMethodListener<TxCommitBody> {
    private static final Logger _log = Logger.getLogger(TxCommitHandler.class);
    private static TxCommitHandler _instance = new TxCommitHandler();

    public static TxCommitHandler getInstance() {
        return _instance;
    }

    private TxCommitHandler() {
    }

    @Override
    public void methodReceived(AMQStateManager stateManager, TxCommitBody body, int channelId) throws AMQException {
        AMQProtocolSession session = stateManager.getProtocolSession();
        try {
            AMQChannel channel;
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Commit received on channel " + channelId));
            }
            if ((channel = session.getChannel(channelId)) == null) {
                throw body.getChannelNotFoundException(channelId);
            }
            channel.resetLastRollbackedMessageId();
            channel.commit();
            MethodRegistry methodRegistry = session.getMethodRegistry();
            TxCommitOkBody responseBody = methodRegistry.createTxCommitOkBody();
            session.writeFrame(responseBody.generateFrame(channelId));
        }
        catch (AMQException e) {
            throw body.getChannelException(e.getErrorCode(), "Failed to commit: " + e.getMessage());
        }
    }
}

