/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.handler;

import org.apache.log4j.Logger;
import org.wso2.andes.AMQException;
import org.wso2.andes.framing.AMQShortString;
import org.wso2.andes.framing.FieldTable;
import org.wso2.andes.framing.QueueUnbindBody;
import org.wso2.andes.framing.QueueUnbindOkBody;
import org.wso2.andes.framing.amqp_0_9.MethodRegistry_0_9;
import org.wso2.andes.protocol.AMQConstant;
import org.wso2.andes.server.AMQChannel;
import org.wso2.andes.server.exchange.Exchange;
import org.wso2.andes.server.exchange.ExchangeRegistry;
import org.wso2.andes.server.protocol.AMQProtocolSession;
import org.wso2.andes.server.queue.AMQQueue;
import org.wso2.andes.server.queue.QueueRegistry;
import org.wso2.andes.server.state.AMQStateManager;
import org.wso2.andes.server.state.StateAwareMethodListener;
import org.wso2.andes.server.virtualhost.VirtualHost;

public class QueueUnbindHandler
implements StateAwareMethodListener<QueueUnbindBody> {
    private static final Logger _log = Logger.getLogger(QueueUnbindHandler.class);
    private static final QueueUnbindHandler _instance = new QueueUnbindHandler();

    public static QueueUnbindHandler getInstance() {
        return _instance;
    }

    private QueueUnbindHandler() {
    }

    @Override
    public void methodReceived(AMQStateManager stateManager, QueueUnbindBody body, int channelId) throws AMQException {
        AMQQueue queue;
        AMQProtocolSession session = stateManager.getProtocolSession();
        VirtualHost virtualHost = session.getVirtualHost();
        ExchangeRegistry exchangeRegistry = virtualHost.getExchangeRegistry();
        QueueRegistry queueRegistry = virtualHost.getQueueRegistry();
        if (body.getQueue() == null) {
            AMQChannel channel = session.getChannel(channelId);
            if (channel == null) {
                throw body.getChannelNotFoundException(channelId);
            }
            queue = channel.getDefaultQueue();
            if (queue == null) {
                throw body.getChannelException(AMQConstant.NOT_FOUND, "No default queue defined on channel and queue was null");
            }
        } else {
            queue = queueRegistry.getQueue(AMQShortString.toLowerCase(body.getQueue()));
        }
        AMQShortString routingKey = null == body.getRoutingKey() ? null : AMQShortString.toLowerCase(body.getRoutingKey().intern());
        if (queue == null) {
            throw body.getChannelException(AMQConstant.NOT_FOUND, "Queue " + body.getQueue() + " does not exist.");
        }
        Exchange exch = exchangeRegistry.getExchange(body.getExchange());
        if (exch == null) {
            throw body.getChannelException(AMQConstant.NOT_FOUND, "Exchange " + body.getExchange() + " does not exist.");
        }
        if (virtualHost.getBindingFactory().getBinding(String.valueOf(routingKey), queue, exch, FieldTable.convertToMap(body.getArguments())) == null) {
            throw body.getChannelException(AMQConstant.NOT_FOUND, "No such binding");
        }
        virtualHost.getBindingFactory().removeBinding(String.valueOf(routingKey), queue, exch, FieldTable.convertToMap(body.getArguments()), true);
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Binding queue " + queue + " to exchange " + exch + " with routing key " + routingKey));
        }
        MethodRegistry_0_9 methodRegistry = (MethodRegistry_0_9)session.getMethodRegistry();
        QueueUnbindOkBody responseBody = methodRegistry.createQueueUnbindOkBody();
        session.writeFrame(responseBody.generateFrame(channelId));
    }
}

