/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.handler;

import org.wso2.andes.AMQException;
import org.wso2.andes.framing.AMQShortString;
import org.wso2.andes.framing.MethodRegistry;
import org.wso2.andes.framing.QueuePurgeBody;
import org.wso2.andes.framing.QueuePurgeOkBody;
import org.wso2.andes.protocol.AMQConstant;
import org.wso2.andes.server.AMQChannel;
import org.wso2.andes.server.protocol.AMQProtocolSession;
import org.wso2.andes.server.protocol.AMQSessionModel;
import org.wso2.andes.server.queue.AMQQueue;
import org.wso2.andes.server.queue.QueueRegistry;
import org.wso2.andes.server.state.AMQStateManager;
import org.wso2.andes.server.state.StateAwareMethodListener;
import org.wso2.andes.server.virtualhost.VirtualHost;

public class QueuePurgeHandler
implements StateAwareMethodListener<QueuePurgeBody> {
    private static final QueuePurgeHandler _instance = new QueuePurgeHandler();
    private final boolean _failIfNotFound;

    public static QueuePurgeHandler getInstance() {
        return _instance;
    }

    public QueuePurgeHandler() {
        this(true);
    }

    public QueuePurgeHandler(boolean failIfNotFound) {
        this._failIfNotFound = failIfNotFound;
    }

    @Override
    public void methodReceived(AMQStateManager stateManager, QueuePurgeBody body, int channelId) throws AMQException {
        AMQQueue queue;
        AMQProtocolSession protocolConnection = stateManager.getProtocolSession();
        VirtualHost virtualHost = protocolConnection.getVirtualHost();
        QueueRegistry queueRegistry = virtualHost.getQueueRegistry();
        AMQChannel channel = protocolConnection.getChannel(channelId);
        if (body.getQueue() == null) {
            if (channel == null) {
                throw body.getChannelNotFoundException(channelId);
            }
            queue = channel.getDefaultQueue();
            if (queue == null && this._failIfNotFound) {
                throw body.getConnectionException(AMQConstant.NOT_ALLOWED, "No queue specified.");
            }
        } else {
            queue = queueRegistry.getQueue(AMQShortString.toLowerCase(body.getQueue()));
        }
        if (queue == null) {
            if (this._failIfNotFound) {
                throw body.getChannelException(AMQConstant.NOT_FOUND, "Queue " + body.getQueue() + " does not exist.");
            }
        } else {
            AMQSessionModel session = queue.getExclusiveOwningSession();
            if (queue.isExclusive() && (session == null || session.getConnectionModel() != protocolConnection)) {
                throw body.getConnectionException(AMQConstant.NOT_ALLOWED, "Queue is exclusive, but not created on this Connection.");
            }
            long purged = queue.clearQueue();
            if (!body.getNowait()) {
                MethodRegistry methodRegistry = protocolConnection.getMethodRegistry();
                QueuePurgeOkBody responseBody = methodRegistry.createQueuePurgeOkBody(purged);
                protocolConnection.writeFrame(responseBody.generateFrame(channelId));
            }
        }
    }
}

