/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.handler;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.andes.AMQException;
import org.wso2.andes.amqp.AMQPUtils;
import org.wso2.andes.amqp.QpidAndesBridge;
import org.wso2.andes.framing.AMQShortString;
import org.wso2.andes.framing.MethodRegistry;
import org.wso2.andes.framing.QueueDeleteBody;
import org.wso2.andes.framing.QueueDeleteOkBody;
import org.wso2.andes.kernel.Andes;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.protocol.AMQConstant;
import org.wso2.andes.server.AMQChannel;
import org.wso2.andes.server.protocol.AMQProtocolSession;
import org.wso2.andes.server.protocol.AMQSessionModel;
import org.wso2.andes.server.queue.AMQQueue;
import org.wso2.andes.server.queue.DLCQueueUtils;
import org.wso2.andes.server.queue.QueueRegistry;
import org.wso2.andes.server.state.AMQStateManager;
import org.wso2.andes.server.state.StateAwareMethodListener;
import org.wso2.andes.server.store.DurableConfigurationStore;
import org.wso2.andes.server.virtualhost.VirtualHost;

public class QueueDeleteHandler
implements StateAwareMethodListener<QueueDeleteBody> {
    private static final Logger _logger = LoggerFactory.getLogger(QueueDeleteHandler.class);
    private static final QueueDeleteHandler _instance = new QueueDeleteHandler();
    private final boolean _failIfNotFound;

    public static QueueDeleteHandler getInstance() {
        return _instance;
    }

    public QueueDeleteHandler() {
        this(true);
    }

    public QueueDeleteHandler(boolean failIfNotFound) {
        this._failIfNotFound = failIfNotFound;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void methodReceived(AMQStateManager stateManager, QueueDeleteBody body, int channelId) throws AMQException {
        AMQQueue queue;
        AMQProtocolSession protocolConnection = stateManager.getProtocolSession();
        VirtualHost virtualHost = protocolConnection.getVirtualHost();
        QueueRegistry queueRegistry = virtualHost.getQueueRegistry();
        DurableConfigurationStore store = virtualHost.getDurableConfigurationStore();
        if (body.getQueue() == null) {
            AMQChannel channel = protocolConnection.getChannel(channelId);
            if (channel == null) {
                throw body.getChannelNotFoundException(channelId);
            }
            queue = channel.getDefaultQueue();
        } else {
            queue = queueRegistry.getQueue(AMQShortString.toLowerCase(body.getQueue()));
        }
        if (DLCQueueUtils.isDeadLetterQueue(queue.getName())) {
            _logger.warn("Deletion of Dead letter channel not permitted.");
            throw new AMQException("Deletion of Dead letter channel not permitted.");
        }
        if (null == queue) {
            if (!this._failIfNotFound) return;
            throw body.getChannelException(AMQConstant.NOT_FOUND, "Queue " + body.getQueue() + " does not exist.");
        }
        if (body.getIfEmpty() && !queue.isEmpty()) {
            throw body.getChannelException(AMQConstant.IN_USE, "Queue: " + body.getQueue() + " is not empty.");
        }
        if (body.getIfUnused() && !queue.isUnused()) {
            throw body.getChannelException(AMQConstant.IN_USE, "Queue: " + body.getQueue() + " is still used.");
        }
        AMQSessionModel session = queue.getExclusiveOwningSession();
        if (queue.isExclusive() && !queue.isDurable()) {
            if (null == session) throw body.getConnectionException(AMQConstant.NOT_ALLOWED, "Queue " + queue.getNameShortString() + " is exclusive, but not created on this Connection.");
            if (session.getConnectionModel() != protocolConnection) {
                throw body.getConnectionException(AMQConstant.NOT_ALLOWED, "Queue " + queue.getNameShortString() + " is exclusive, but not created on this Connection.");
            }
        }
        boolean isQueueDeletable = false;
        try {
            isQueueDeletable = Andes.getInstance().checkIfQueueDeletable(AMQPUtils.createInboundQueueEvent(queue));
        }
        catch (AndesException e) {
            throw new AMQException("Error while checking if queue is deletable queue= " + queue.getName(), e);
        }
        if (!isQueueDeletable) {
            _logger.warn("Cannot Delete Queue" + queue.getName() + " It Has Registered Subscriptions.");
            throw new AMQException("Cannot Delete Queue" + queue.getName() + " It Has Registered Subscriptions.");
        }
        int purged = queue.delete();
        if (queue.isDurable()) {
            store.removeQueue(queue);
        }
        QpidAndesBridge.deleteQueue(queue);
        MethodRegistry methodRegistry = protocolConnection.getMethodRegistry();
        QueueDeleteOkBody responseBody = methodRegistry.createQueueDeleteOkBody(purged);
        protocolConnection.writeFrame(responseBody.generateFrame(channelId));
    }
}

