/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.handler;

import java.util.Map;
import org.apache.log4j.Logger;
import org.wso2.andes.AMQException;
import org.wso2.andes.framing.AMQShortString;
import org.wso2.andes.framing.FieldTable;
import org.wso2.andes.framing.MethodRegistry;
import org.wso2.andes.framing.QueueBindBody;
import org.wso2.andes.framing.QueueBindOkBody;
import org.wso2.andes.protocol.AMQConstant;
import org.wso2.andes.server.AMQChannel;
import org.wso2.andes.server.binding.Binding;
import org.wso2.andes.server.exchange.Exchange;
import org.wso2.andes.server.exchange.ExchangeRegistry;
import org.wso2.andes.server.protocol.AMQProtocolSession;
import org.wso2.andes.server.protocol.AMQSessionModel;
import org.wso2.andes.server.queue.AMQQueue;
import org.wso2.andes.server.queue.QueueRegistry;
import org.wso2.andes.server.state.AMQStateManager;
import org.wso2.andes.server.state.StateAwareMethodListener;
import org.wso2.andes.server.virtualhost.VirtualHost;

public class QueueBindHandler
implements StateAwareMethodListener<QueueBindBody> {
    private static final Logger _log = Logger.getLogger(QueueBindHandler.class);
    private static final QueueBindHandler _instance = new QueueBindHandler();

    public static QueueBindHandler getInstance() {
        return _instance;
    }

    private QueueBindHandler() {
    }

    @Override
    public void methodReceived(AMQStateManager stateManager, QueueBindBody body, int channelId) throws AMQException {
        AMQShortString routingKey;
        AMQQueue queue;
        AMQProtocolSession protocolConnection = stateManager.getProtocolSession();
        VirtualHost virtualHost = protocolConnection.getVirtualHost();
        ExchangeRegistry exchangeRegistry = virtualHost.getExchangeRegistry();
        QueueRegistry queueRegistry = virtualHost.getQueueRegistry();
        if (body.getQueue() == null) {
            AMQChannel channel = protocolConnection.getChannel(channelId);
            if (channel == null) {
                throw body.getChannelNotFoundException(channelId);
            }
            queue = channel.getDefaultQueue();
            if (queue == null) {
                throw body.getChannelException(AMQConstant.NOT_FOUND, "No default queue defined on channel and queue was null");
            }
            routingKey = body.getRoutingKey() == null ? AMQShortString.toLowerCase(queue.getNameShortString()) : AMQShortString.toLowerCase(body.getRoutingKey().intern());
        } else {
            queue = queueRegistry.getQueue(AMQShortString.toLowerCase(body.getQueue()));
            routingKey = AMQShortString.toLowerCase(body.getRoutingKey() == null ? AMQShortString.EMPTY_STRING : body.getRoutingKey().intern());
        }
        if (queue == null) {
            throw body.getChannelException(AMQConstant.NOT_FOUND, "Queue " + body.getQueue() + " does not exist.");
        }
        Exchange exch = exchangeRegistry.getExchange(body.getExchange());
        if (exch == null) {
            throw body.getChannelException(AMQConstant.NOT_FOUND, "Exchange " + body.getExchange() + " does not exist.");
        }
        try {
            AMQSessionModel session;
            if (queue.isExclusive() && !queue.isDurable() && ((session = queue.getExclusiveOwningSession()) == null || session.getConnectionModel() != protocolConnection)) {
                throw body.getConnectionException(AMQConstant.NOT_ALLOWED, "Queue " + queue.getNameShortString() + " is exclusive, but not created on this Connection.");
            }
            String bindingKey = String.valueOf(routingKey);
            if (!exch.isBound(routingKey, null, queue)) {
                Binding oldBinding;
                Map<String, Object> oldArgs;
                Map<String, Object> arguments = FieldTable.convertToMap(body.getArguments());
                if (!virtualHost.getBindingFactory().addBinding(bindingKey, queue, exch, arguments) && ((oldArgs = (oldBinding = virtualHost.getBindingFactory().getBinding(bindingKey, queue, exch, arguments)).getArguments()) == null && !arguments.isEmpty() || oldArgs != null && !oldArgs.equals(arguments))) {
                    virtualHost.getBindingFactory().replaceBinding(bindingKey, queue, exch, arguments);
                }
            } else {
                virtualHost.getBindingFactory().authoriseBind(bindingKey, queue, exch);
            }
        }
        catch (AMQException e) {
            throw body.getChannelException(AMQConstant.CHANNEL_ERROR, e.toString());
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Binding queue " + queue + " to exchange " + exch + " with routing key " + routingKey));
        }
        if (!body.getNowait()) {
            MethodRegistry methodRegistry = protocolConnection.getMethodRegistry();
            QueueBindOkBody responseBody = methodRegistry.createQueueBindOkBody();
            protocolConnection.writeFrame(responseBody.generateFrame(channelId));
        }
    }
}

