/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.handler;

import org.wso2.andes.AMQException;
import org.wso2.andes.framing.AMQShortString;
import org.wso2.andes.framing.ExchangeBoundBody;
import org.wso2.andes.framing.ExchangeBoundOkBody;
import org.wso2.andes.framing.MethodRegistry;
import org.wso2.andes.server.exchange.Exchange;
import org.wso2.andes.server.protocol.AMQProtocolSession;
import org.wso2.andes.server.queue.AMQQueue;
import org.wso2.andes.server.queue.QueueRegistry;
import org.wso2.andes.server.state.AMQStateManager;
import org.wso2.andes.server.state.StateAwareMethodListener;
import org.wso2.andes.server.virtualhost.VirtualHost;

public class ExchangeBoundHandler
implements StateAwareMethodListener<ExchangeBoundBody> {
    private static final ExchangeBoundHandler _instance = new ExchangeBoundHandler();
    public static final int OK = 0;
    public static final int EXCHANGE_NOT_FOUND = 1;
    public static final int QUEUE_NOT_FOUND = 2;
    public static final int NO_BINDINGS = 3;
    public static final int QUEUE_NOT_BOUND = 4;
    public static final int NO_QUEUE_BOUND_WITH_RK = 5;
    public static final int SPECIFIC_QUEUE_NOT_BOUND_WITH_RK = 6;

    public static ExchangeBoundHandler getInstance() {
        return _instance;
    }

    private ExchangeBoundHandler() {
    }

    @Override
    public void methodReceived(AMQStateManager stateManager, ExchangeBoundBody body, int channelId) throws AMQException {
        AMQQueue queue;
        AMQProtocolSession session = stateManager.getProtocolSession();
        VirtualHost virtualHost = session.getVirtualHost();
        QueueRegistry queueRegistry = virtualHost.getQueueRegistry();
        MethodRegistry methodRegistry = session.getMethodRegistry();
        AMQShortString exchangeName = body.getExchange();
        AMQShortString queueName = AMQShortString.toLowerCase(body.getQueue());
        AMQShortString routingKey = AMQShortString.toLowerCase(body.getRoutingKey());
        if (exchangeName == null) {
            throw new AMQException("Exchange exchange must not be null");
        }
        Exchange exchange = virtualHost.getExchangeRegistry().getExchange(exchangeName);
        ExchangeBoundOkBody response = exchange == null ? methodRegistry.createExchangeBoundOkBody(1, new AMQShortString("Exchange " + exchangeName + " not found")) : (routingKey == null ? (queueName == null ? (exchange.hasBindings() ? methodRegistry.createExchangeBoundOkBody(0, null) : methodRegistry.createExchangeBoundOkBody(3, null)) : ((queue = queueRegistry.getQueue(queueName)) == null ? methodRegistry.createExchangeBoundOkBody(2, new AMQShortString("Queue " + queueName + " not found")) : (exchange.isBound(queue) ? methodRegistry.createExchangeBoundOkBody(0, null) : methodRegistry.createExchangeBoundOkBody(4, new AMQShortString("Queue " + queueName + " not bound to exchange " + exchangeName))))) : (queueName != null ? ((queue = queueRegistry.getQueue(queueName)) == null ? methodRegistry.createExchangeBoundOkBody(2, new AMQShortString("Queue " + queueName + " not found")) : (exchange.isBound(routingKey, queue) ? methodRegistry.createExchangeBoundOkBody(0, null) : methodRegistry.createExchangeBoundOkBody(6, new AMQShortString("Queue " + queueName + " not bound with routing key " + body.getRoutingKey() + " to exchange " + exchangeName)))) : (exchange.isBound(routingKey) ? methodRegistry.createExchangeBoundOkBody(0, null) : methodRegistry.createExchangeBoundOkBody(5, new AMQShortString("No queue bound with routing key " + body.getRoutingKey() + " to exchange " + exchangeName)))));
        session.writeFrame(response.generateFrame(channelId));
    }
}

