/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.handler;

import org.wso2.andes.AMQException;
import org.wso2.andes.dtx.XidImpl;
import org.wso2.andes.framing.DtxStartOkBody;
import org.wso2.andes.framing.amqp_0_91.DtxStartBodyImpl;
import org.wso2.andes.framing.amqp_0_91.MethodRegistry_0_91;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.dtx.AlreadyKnownDtxException;
import org.wso2.andes.kernel.dtx.JoinAndResumeDtxException;
import org.wso2.andes.kernel.dtx.UnknownDtxBranchException;
import org.wso2.andes.protocol.AMQConstant;
import org.wso2.andes.server.AMQChannel;
import org.wso2.andes.server.protocol.AMQProtocolSession;
import org.wso2.andes.server.state.AMQStateManager;
import org.wso2.andes.server.state.StateAwareMethodListener;
import org.wso2.andes.server.txn.DtxNotSelectedException;
import org.wso2.andes.transport.DtxXaStatus;

public class DtxStartHandler
implements StateAwareMethodListener<DtxStartBodyImpl> {
    private static DtxStartHandler _instance = new DtxStartHandler();

    public static DtxStartHandler getInstance() {
        return _instance;
    }

    private DtxStartHandler() {
    }

    @Override
    public void methodReceived(AMQStateManager stateManager, DtxStartBodyImpl body, int channelId) throws AMQException {
        XidImpl xid = new XidImpl(body.getBranchId(), body.getFormat(), body.getGlobalId());
        AMQProtocolSession session = stateManager.getProtocolSession();
        AMQChannel channel = session.getChannel(channelId);
        if (channel == null) {
            throw body.getChannelNotFoundException(channelId);
        }
        try {
            channel.startDtxTransaction(xid, body.getJoin(), body.getResume());
            MethodRegistry_0_91 methodRegistry = (MethodRegistry_0_91)session.getMethodRegistry();
            DtxStartOkBody dtxStartOkBody = methodRegistry.createDtxStartOkBody(DtxXaStatus.XA_OK.getValue());
            session.writeFrame(dtxStartOkBody.generateFrame(channelId));
        }
        catch (DtxNotSelectedException e) {
            throw body.getChannelException(AMQConstant.NOT_ALLOWED, "Not a distributed transacted session", e);
        }
        catch (AlreadyKnownDtxException e) {
            throw body.getChannelException(AMQConstant.NOT_ALLOWED, "XID already started an neither join nor resume set" + xid, e);
        }
        catch (JoinAndResumeDtxException e) {
            throw body.getChannelException(AMQConstant.NOT_ALLOWED, "Cannot start a branch with both join and resume set ", e);
        }
        catch (UnknownDtxBranchException e) {
            throw body.getChannelException(AMQConstant.NOT_ALLOWED, "Unknown XID " + xid, e);
        }
        catch (AndesException e) {
            throw body.getChannelException(AMQConstant.INTERNAL_ERROR, "Internal error occurred while starting transaction for " + xid, e);
        }
    }
}

