/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.handler;

import org.wso2.andes.AMQException;
import org.wso2.andes.framing.DtxSelectBody;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.protocol.AMQConstant;
import org.wso2.andes.server.AMQChannel;
import org.wso2.andes.server.protocol.AMQProtocolSession;
import org.wso2.andes.server.state.AMQStateManager;
import org.wso2.andes.server.state.StateAwareMethodListener;

public class DtxSelectHandler
implements StateAwareMethodListener<DtxSelectBody> {
    private static DtxSelectHandler _instance = new DtxSelectHandler();

    public static DtxSelectHandler getInstance() {
        return _instance;
    }

    private DtxSelectHandler() {
    }

    @Override
    public void methodReceived(AMQStateManager stateManager, DtxSelectBody body, int channelId) throws AMQException {
        AMQProtocolSession session = stateManager.getProtocolSession();
        AMQChannel channel = session.getChannel(channelId);
        if (channel == null) {
            throw body.getChannelNotFoundException(channelId);
        }
        try {
            channel.setDtxTransactional();
        }
        catch (AndesException e) {
            throw body.getChannelException(AMQConstant.INTERNAL_ERROR, "Maximum number of parallel transactions limit reached", e);
        }
    }
}

