/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.handler;

import org.wso2.andes.AMQChannelException;
import org.wso2.andes.AMQException;
import org.wso2.andes.dtx.XidImpl;
import org.wso2.andes.framing.DtxRollbackOkBody;
import org.wso2.andes.framing.amqp_0_91.DtxRollbackBodyImpl;
import org.wso2.andes.framing.amqp_0_91.MethodRegistry_0_91;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.disruptor.DisruptorEventCallback;
import org.wso2.andes.kernel.dtx.UnknownDtxBranchException;
import org.wso2.andes.protocol.AMQConstant;
import org.wso2.andes.server.AMQChannel;
import org.wso2.andes.server.protocol.AMQProtocolSession;
import org.wso2.andes.server.state.AMQStateManager;
import org.wso2.andes.server.state.StateAwareMethodListener;
import org.wso2.andes.server.txn.DtxNotSelectedException;
import org.wso2.andes.server.txn.IncorrectDtxStateException;
import org.wso2.andes.server.txn.TimeoutDtxException;
import org.wso2.andes.transport.DtxXaStatus;

public class DtxRollbackHandler
implements StateAwareMethodListener<DtxRollbackBodyImpl> {
    private static DtxRollbackHandler _instance = new DtxRollbackHandler();

    public static DtxRollbackHandler getInstance() {
        return _instance;
    }

    private DtxRollbackHandler() {
    }

    @Override
    public void methodReceived(AMQStateManager stateManager, final DtxRollbackBodyImpl body, final int channelId) throws AMQException {
        XidImpl xid = new XidImpl(body.getBranchId(), body.getFormat(), body.getGlobalId());
        final AMQProtocolSession session = stateManager.getProtocolSession();
        AMQChannel channel = session.getChannel(channelId);
        if (channel == null) {
            throw body.getChannelNotFoundException(channelId);
        }
        try {
            try {
                channel.rollbackDtxTransaction(xid, new DisruptorEventCallback(){

                    @Override
                    public void execute() {
                        MethodRegistry_0_91 methodRegistry = (MethodRegistry_0_91)session.getMethodRegistry();
                        DtxRollbackOkBody dtxRollbackOkBody = methodRegistry.createDtxRollbackOkBody(DtxXaStatus.XA_OK.getValue());
                        session.writeFrame(dtxRollbackOkBody.generateFrame(channelId));
                    }

                    @Override
                    public void onException(Exception exception) {
                        if (exception instanceof AndesException) {
                            AMQChannelException channelException = body.getChannelException(AMQConstant.INTERNAL_ERROR, "Internal error occurred while rolling back records", exception);
                            session.writeFrame(channelException.getCloseFrame(channelId));
                        }
                    }
                });
            }
            catch (TimeoutDtxException e) {
                MethodRegistry_0_91 methodRegistry = (MethodRegistry_0_91)session.getMethodRegistry();
                DtxRollbackOkBody dtxRollbackOkBody = methodRegistry.createDtxRollbackOkBody(DtxXaStatus.XA_RBTIMEOUT.getValue());
                session.writeFrame(dtxRollbackOkBody.generateFrame(channelId));
            }
        }
        catch (DtxNotSelectedException e) {
            throw body.getChannelException(AMQConstant.COMMAND_INVALID, "Error rolling back dtx ", e);
        }
        catch (IncorrectDtxStateException e) {
            throw body.getChannelException(AMQConstant.COMMAND_INVALID, "Cannot rollback, branch in an invalid state", e);
        }
        catch (AndesException e) {
            throw body.getChannelException(AMQConstant.INTERNAL_ERROR, "Internal error occurred while rolling back records", e);
        }
        catch (UnknownDtxBranchException e) {
            throw body.getChannelException(AMQConstant.NOT_FOUND, "Could not find the specified dtx branch", e);
        }
    }
}

