/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.handler;

import java.util.ArrayList;
import javax.transaction.xa.Xid;
import org.apache.commons.lang.SerializationUtils;
import org.wso2.andes.AMQException;
import org.wso2.andes.framing.DtxRecoverOkBody;
import org.wso2.andes.framing.amqp_0_91.DtxRecoverBodyImpl;
import org.wso2.andes.framing.amqp_0_91.MethodRegistry_0_91;
import org.wso2.andes.protocol.AMQConstant;
import org.wso2.andes.server.AMQChannel;
import org.wso2.andes.server.protocol.AMQProtocolSession;
import org.wso2.andes.server.state.AMQStateManager;
import org.wso2.andes.server.state.StateAwareMethodListener;
import org.wso2.andes.server.txn.DtxNotSelectedException;

public class DtxRecoverHandler
implements StateAwareMethodListener<DtxRecoverBodyImpl> {
    private static DtxRecoverHandler instance = new DtxRecoverHandler();

    public static DtxRecoverHandler getInstance() {
        return instance;
    }

    private DtxRecoverHandler() {
    }

    @Override
    public void methodReceived(AMQStateManager stateManager, DtxRecoverBodyImpl body, int channelId) throws AMQException {
        AMQProtocolSession session = stateManager.getProtocolSession();
        AMQChannel channel = session.getChannel(channelId);
        if (channel == null) {
            throw body.getChannelNotFoundException(channelId);
        }
        try {
            ArrayList<Xid> inDoubtXids = channel.recoverDtxTransactions();
            MethodRegistry_0_91 methodRegistry = (MethodRegistry_0_91)session.getMethodRegistry();
            byte[] serializedData = SerializationUtils.serialize(inDoubtXids);
            DtxRecoverOkBody dtxRecoverOkBody = methodRegistry.createDtxRecoverOkBody(serializedData);
            session.writeFrame(dtxRecoverOkBody.generateFrame(channelId));
        }
        catch (DtxNotSelectedException e) {
            throw body.getChannelException(AMQConstant.NOT_ALLOWED, "Not a distributed transacted session", e);
        }
    }
}

