/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.handler;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.andes.AMQChannelException;
import org.wso2.andes.AMQException;
import org.wso2.andes.dtx.XidImpl;
import org.wso2.andes.framing.DtxPrepareOkBody;
import org.wso2.andes.framing.amqp_0_91.DtxPrepareBodyImpl;
import org.wso2.andes.framing.amqp_0_91.MethodRegistry_0_91;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.disruptor.DisruptorEventCallback;
import org.wso2.andes.kernel.dtx.UnknownDtxBranchException;
import org.wso2.andes.protocol.AMQConstant;
import org.wso2.andes.server.AMQChannel;
import org.wso2.andes.server.protocol.AMQProtocolSession;
import org.wso2.andes.server.state.AMQStateManager;
import org.wso2.andes.server.state.StateAwareMethodListener;
import org.wso2.andes.server.txn.DtxNotSelectedException;
import org.wso2.andes.server.txn.IncorrectDtxStateException;
import org.wso2.andes.server.txn.RollbackOnlyDtxException;
import org.wso2.andes.server.txn.TimeoutDtxException;
import org.wso2.andes.transport.DtxXaStatus;

public class DtxPrepareHandler
implements StateAwareMethodListener<DtxPrepareBodyImpl> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DtxPrepareHandler.class);
    private static DtxPrepareHandler _instance = new DtxPrepareHandler();

    public static DtxPrepareHandler getInstance() {
        return _instance;
    }

    private DtxPrepareHandler() {
    }

    @Override
    public void methodReceived(AMQStateManager stateManager, final DtxPrepareBodyImpl body, final int channelId) throws AMQException {
        XidImpl xid = new XidImpl(body.getBranchId(), body.getFormat(), body.getGlobalId());
        final AMQProtocolSession session = stateManager.getProtocolSession();
        AMQChannel channel = session.getChannel(channelId);
        if (channel == null) {
            throw body.getChannelNotFoundException(channelId);
        }
        try {
            channel.prepareDtxTransaction(xid, new DisruptorEventCallback(){

                @Override
                public void execute() {
                    MethodRegistry_0_91 methodRegistry = (MethodRegistry_0_91)session.getMethodRegistry();
                    DtxPrepareOkBody dtxPrepareOkBody = methodRegistry.createDtxPrepareOkBody(DtxXaStatus.XA_OK.getValue());
                    session.writeFrame(dtxPrepareOkBody.generateFrame(channelId));
                }

                @Override
                public void onException(Exception exception) {
                    LOGGER.error("Exception occurred when preparing ", (Throwable)exception);
                    AMQChannelException channelException = body.getChannelException(AMQConstant.INTERNAL_ERROR, exception.getMessage());
                    session.writeFrame(channelException.getCloseFrame(channelId));
                    try {
                        session.closeChannel(channelId);
                    }
                    catch (AMQException e) {
                        LOGGER.error("Couldn't close channel (channel id ) " + channelId, (Throwable)e);
                    }
                }
            });
        }
        catch (TimeoutDtxException e) {
            LOGGER.info("Error while preparing dtx: " + e.getMessage());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Error while preparing dtx", (Throwable)e);
            }
            MethodRegistry_0_91 methodRegistry = (MethodRegistry_0_91)session.getMethodRegistry();
            DtxPrepareOkBody dtxPrepareOkBody = methodRegistry.createDtxPrepareOkBody(DtxXaStatus.XA_RBTIMEOUT.getValue());
            session.writeFrame(dtxPrepareOkBody.generateFrame(channelId));
        }
        catch (RollbackOnlyDtxException e) {
            LOGGER.info("Error while preparing dtx: " + e.getMessage());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Error while preparing dtx", (Throwable)e);
            }
            MethodRegistry_0_91 methodRegistry = (MethodRegistry_0_91)session.getMethodRegistry();
            DtxPrepareOkBody dtxPrepareOkBody = methodRegistry.createDtxPrepareOkBody(DtxXaStatus.XA_RBROLLBACK.getValue());
            session.writeFrame(dtxPrepareOkBody.generateFrame(channelId));
        }
        catch (DtxNotSelectedException e) {
            throw body.getChannelException(AMQConstant.COMMAND_INVALID, "Not a distributed transacted session", e);
        }
        catch (IncorrectDtxStateException e) {
            throw body.getChannelException(AMQConstant.COMMAND_INVALID, e.getMessage(), e);
        }
        catch (AndesException e) {
            throw body.getChannelException(AMQConstant.INTERNAL_ERROR, "Internal error occurred while persisting records", e);
        }
        catch (UnknownDtxBranchException e) {
            throw body.getChannelException(AMQConstant.COMMAND_INVALID, "Could not find the specified dtx branch ", e);
        }
    }
}

