/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.server.handler;

import org.wso2.andes.AMQException;
import org.wso2.andes.dtx.XidImpl;
import org.wso2.andes.framing.DtxForgetOkBody;
import org.wso2.andes.framing.amqp_0_91.DtxForgetBodyImpl;
import org.wso2.andes.framing.amqp_0_91.MethodRegistry_0_91;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.dtx.UnknownDtxBranchException;
import org.wso2.andes.protocol.AMQConstant;
import org.wso2.andes.server.AMQChannel;
import org.wso2.andes.server.protocol.AMQProtocolSession;
import org.wso2.andes.server.state.AMQStateManager;
import org.wso2.andes.server.state.StateAwareMethodListener;
import org.wso2.andes.server.txn.DtxNotSelectedException;
import org.wso2.andes.server.txn.IncorrectDtxStateException;
import org.wso2.andes.transport.DtxXaStatus;

public class DtxForgetHandler
implements StateAwareMethodListener<DtxForgetBodyImpl> {
    private static DtxForgetHandler _instance = new DtxForgetHandler();

    public static DtxForgetHandler getInstance() {
        return _instance;
    }

    private DtxForgetHandler() {
    }

    @Override
    public void methodReceived(AMQStateManager stateManager, DtxForgetBodyImpl body, int channelId) throws AMQException {
        XidImpl xid = new XidImpl(body.getBranchId(), body.getFormat(), body.getGlobalId());
        AMQProtocolSession session = stateManager.getProtocolSession();
        AMQChannel channel = session.getChannel(channelId);
        if (channel == null) {
            throw body.getChannelNotFoundException(channelId);
        }
        try {
            channel.forgetDtxTransaction(xid);
            MethodRegistry_0_91 methodRegistry = (MethodRegistry_0_91)session.getMethodRegistry();
            DtxForgetOkBody dtxForgetOkBody = methodRegistry.createDtxForgetOkBody(DtxXaStatus.XA_OK.getValue());
            session.writeFrame(dtxForgetOkBody.generateFrame(channelId));
        }
        catch (DtxNotSelectedException e) {
            throw body.getChannelException(AMQConstant.NOT_ALLOWED, "Not a distributed transacted session", e);
        }
        catch (UnknownDtxBranchException e) {
            throw body.getChannelException(AMQConstant.NOT_ALLOWED, "Error forgetting dtx. Unknown branch for the given xid ", e);
        }
        catch (IncorrectDtxStateException e) {
            throw body.getChannelException(AMQConstant.COMMAND_INVALID, e.getMessage(), e);
        }
        catch (AndesException e) {
            throw body.getChannelException(AMQConstant.INTERNAL_ERROR, "Error forgetting dtx. Internal Error occurred ", e);
        }
    }
}

